/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.StatPersisted;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;

public class DigestCalculator {
    private static final int DIGEST_VERSION = 2;

    long calculateDigest(String string, byte[] byArray, StatPersisted statPersisted) {
        if (!ZooKeeperServer.isDigestEnabled()) {
            return 0L;
        }
        if (string.startsWith("/zookeeper/")) {
            return 0L;
        }
        if (string.equals("/")) {
            string = "";
        }
        byte[] byArray2 = new byte[60];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byteBuffer.putLong(statPersisted.getCzxid());
        byteBuffer.putLong(statPersisted.getMzxid());
        byteBuffer.putLong(statPersisted.getPzxid());
        byteBuffer.putLong(statPersisted.getCtime());
        byteBuffer.putLong(statPersisted.getMtime());
        byteBuffer.putInt(statPersisted.getVersion());
        byteBuffer.putInt(statPersisted.getCversion());
        byteBuffer.putInt(statPersisted.getAversion());
        byteBuffer.putLong(statPersisted.getEphemeralOwner());
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        if (byArray != null) {
            cRC32.update(byArray);
        }
        cRC32.update(byArray2);
        return cRC32.getValue();
    }

    long calculateDigest(String string, DataNode dataNode) {
        if (!dataNode.isDigestCached()) {
            dataNode.setDigest(this.calculateDigest(string, dataNode.getData(), dataNode.stat));
            dataNode.setDigestCached(true);
        }
        return dataNode.getDigest();
    }

    int getDigestVersion() {
        return 2;
    }
}

