/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.PurgeTxnLog;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class DatadirCleanupManager {
    private static final foe LOG = goe.a(DatadirCleanupManager.class);
    private PurgeTaskStatus purgeTaskStatus = PurgeTaskStatus.NOT_STARTED;
    private final File snapDir;
    private final File dataLogDir;
    private final int snapRetainCount;
    private final int purgeInterval;
    private Timer timer;

    public DatadirCleanupManager(File file, File file2, int n2, int n3) {
        this.snapDir = file;
        this.dataLogDir = file2;
        this.snapRetainCount = n2;
        this.purgeInterval = n3;
        LOG.c("autopurge.snapRetainCount set to {}", (Object)n2);
        LOG.c("autopurge.purgeInterval set to {}", (Object)n3);
    }

    public void start() {
        if (PurgeTaskStatus.STARTED == this.purgeTaskStatus) {
            LOG.d("Purge task is already running.");
            return;
        }
        if (this.purgeInterval <= 0) {
            LOG.c("Purge task is not scheduled.");
            return;
        }
        this.timer = new Timer("PurgeTask", true);
        PurgeTask purgeTask = new PurgeTask(this.dataLogDir, this.snapDir, this.snapRetainCount);
        this.timer.scheduleAtFixedRate((TimerTask)purgeTask, 0L, TimeUnit.HOURS.toMillis(this.purgeInterval));
        this.purgeTaskStatus = PurgeTaskStatus.STARTED;
    }

    public void shutdown() {
        if (PurgeTaskStatus.STARTED == this.purgeTaskStatus) {
            LOG.c("Shutting down purge task.");
            this.timer.cancel();
            this.purgeTaskStatus = PurgeTaskStatus.COMPLETED;
        } else {
            LOG.d("Purge task not started. Ignoring shutdown!");
        }
    }

    public PurgeTaskStatus getPurgeTaskStatus() {
        return this.purgeTaskStatus;
    }

    public File getSnapDir() {
        return this.snapDir;
    }

    public File getDataLogDir() {
        return this.dataLogDir;
    }

    public int getPurgeInterval() {
        return this.purgeInterval;
    }

    public int getSnapRetainCount() {
        return this.snapRetainCount;
    }

    static class PurgeTask
    extends TimerTask {
        private File logsDir;
        private File snapsDir;
        private int snapRetainCount;

        public PurgeTask(File file, File file2, int n2) {
            this.logsDir = file;
            this.snapsDir = file2;
            this.snapRetainCount = n2;
        }

        @Override
        public void run() {
            LOG.c("Purge task started.");
            try {
                PurgeTxnLog.purge(this.logsDir, this.snapsDir, this.snapRetainCount);
            }
            catch (Exception exception) {
                LOG.d("Error occurred while purging.", exception);
            }
            LOG.c("Purge task completed.");
        }
    }

    public static enum PurgeTaskStatus {
        NOT_STARTED,
        STARTED,
        COMPLETED;

    }
}

