/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import java.util.Random;

public class BlueThrottle {
    private static final foe LOG = goe.a(BlueThrottle.class);
    private int maxTokens = DEFAULT_CONNECTION_THROTTLE_TOKENS;
    private int fillTime = DEFAULT_CONNECTION_THROTTLE_FILL_TIME;
    private int fillCount = DEFAULT_CONNECTION_THROTTLE_FILL_COUNT;
    private int tokens = this.maxTokens;
    private long lastTime = Time.currentElapsedTime();
    private int freezeTime = DEFAULT_CONNECTION_THROTTLE_FREEZE_TIME;
    private long lastFreeze = Time.currentElapsedTime();
    private double dropIncrease = DEFAULT_CONNECTION_THROTTLE_DROP_INCREASE;
    private double dropDecrease = DEFAULT_CONNECTION_THROTTLE_DROP_DECREASE;
    private double decreasePoint = DEFAULT_CONNECTION_THROTTLE_DECREASE_RATIO;
    private double drop = 0.0;
    Random rng = new Random();
    public static final String CONNECTION_THROTTLE_TOKENS = "zookeeper.connection_throttle_tokens";
    private static final int DEFAULT_CONNECTION_THROTTLE_TOKENS;
    public static final String CONNECTION_THROTTLE_FILL_TIME = "zookeeper.connection_throttle_fill_time";
    private static final int DEFAULT_CONNECTION_THROTTLE_FILL_TIME;
    public static final String CONNECTION_THROTTLE_FILL_COUNT = "zookeeper.connection_throttle_fill_count";
    private static final int DEFAULT_CONNECTION_THROTTLE_FILL_COUNT;
    public static final String CONNECTION_THROTTLE_FREEZE_TIME = "zookeeper.connection_throttle_freeze_time";
    private static final int DEFAULT_CONNECTION_THROTTLE_FREEZE_TIME;
    public static final String CONNECTION_THROTTLE_DROP_INCREASE = "zookeeper.connection_throttle_drop_increase";
    private static final double DEFAULT_CONNECTION_THROTTLE_DROP_INCREASE;
    public static final String CONNECTION_THROTTLE_DROP_DECREASE = "zookeeper.connection_throttle_drop_decrease";
    private static final double DEFAULT_CONNECTION_THROTTLE_DROP_DECREASE;
    public static final String CONNECTION_THROTTLE_DECREASE_RATIO = "zookeeper.connection_throttle_decrease_ratio";
    private static final double DEFAULT_CONNECTION_THROTTLE_DECREASE_RATIO;
    public static final String WEIGHED_CONNECTION_THROTTLE = "zookeeper.connection_throttle_weight_enabled";
    private static boolean connectionWeightEnabled;
    public static final String GLOBAL_SESSION_WEIGHT = "zookeeper.connection_throttle_global_session_weight";
    private static final int DEFAULT_GLOBAL_SESSION_WEIGHT;
    public static final String LOCAL_SESSION_WEIGHT = "zookeeper.connection_throttle_local_session_weight";
    private static final int DEFAULT_LOCAL_SESSION_WEIGHT;
    public static final String RENEW_SESSION_WEIGHT = "zookeeper.connection_throttle_renew_session_weight";
    private static final int DEFAULT_RENEW_SESSION_WEIGHT;

    protected static void setConnectionWeightEnabled(boolean bl2) {
        connectionWeightEnabled = bl2;
        BlueThrottle.logWeighedThrottlingSetting();
    }

    private static void logWeighedThrottlingSetting() {
        if (connectionWeightEnabled) {
            LOG.c("Weighed connection throttling is enabled. But it will only be effective if connection throttling is enabled");
            LOG.c("The weights for different session types are: global {} renew {} local {}", DEFAULT_GLOBAL_SESSION_WEIGHT, DEFAULT_RENEW_SESSION_WEIGHT, DEFAULT_LOCAL_SESSION_WEIGHT);
        } else {
            LOG.c("Weighed connection throttling is disabled");
        }
    }

    private static double getDoubleProp(String string, double d2) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return Double.parseDouble(string2);
        }
        return d2;
    }

    public synchronized void setMaxTokens(int n2) {
        int n3 = this.maxTokens - this.tokens;
        this.maxTokens = n2;
        this.tokens = n2 - n3;
    }

    public synchronized void setFillTime(int n2) {
        this.fillTime = n2;
    }

    public synchronized void setFillCount(int n2) {
        this.fillCount = n2;
    }

    public synchronized void setFreezeTime(int n2) {
        this.freezeTime = n2;
    }

    public synchronized void setDropIncrease(double d2) {
        this.dropIncrease = d2;
    }

    public synchronized void setDropDecrease(double d2) {
        this.dropDecrease = d2;
    }

    public synchronized void setDecreasePoint(double d2) {
        this.decreasePoint = d2;
    }

    public synchronized int getMaxTokens() {
        return this.maxTokens;
    }

    public synchronized int getFillTime() {
        return this.fillTime;
    }

    public synchronized int getFillCount() {
        return this.fillCount;
    }

    public synchronized int getFreezeTime() {
        return this.freezeTime;
    }

    public synchronized double getDropIncrease() {
        return this.dropIncrease;
    }

    public synchronized double getDropDecrease() {
        return this.dropDecrease;
    }

    public synchronized double getDecreasePoint() {
        return this.decreasePoint;
    }

    public synchronized double getDropChance() {
        return this.drop;
    }

    public synchronized int getDeficit() {
        return this.maxTokens - this.tokens;
    }

    public int getRequiredTokensForGlobal() {
        return DEFAULT_GLOBAL_SESSION_WEIGHT;
    }

    public int getRequiredTokensForLocal() {
        return DEFAULT_LOCAL_SESSION_WEIGHT;
    }

    public int getRequiredTokensForRenew() {
        return DEFAULT_RENEW_SESSION_WEIGHT;
    }

    public boolean isConnectionWeightEnabled() {
        return connectionWeightEnabled;
    }

    public synchronized boolean checkLimit(int n2) {
        if (this.maxTokens == 0) {
            return true;
        }
        long l2 = Time.currentElapsedTime();
        long l3 = l2 - this.lastTime;
        if (l3 > (long)this.fillTime) {
            int n3 = (int)(l3 * (long)this.fillCount / (long)this.fillTime);
            this.tokens = Math.min(this.tokens + n3, this.maxTokens);
            this.lastTime = l2;
        }
        if (this.freezeTime != -1 && !this.checkBlue(l2)) {
            return false;
        }
        if (this.tokens < n2) {
            return false;
        }
        this.tokens -= n2;
        return true;
    }

    public synchronized boolean checkBlue(long l2) {
        int n2 = this.maxTokens - this.tokens;
        int n3 = this.maxTokens;
        long l3 = l2 - this.lastFreeze;
        long l4 = Math.round((double)this.maxTokens * this.decreasePoint);
        if (l3 > (long)this.freezeTime) {
            if (n2 == n3 && this.drop < 1.0) {
                this.drop = Math.min(this.drop + this.dropIncrease, 1.0);
            } else if ((long)n2 <= l4 && this.drop > 0.0) {
                this.drop = Math.max(this.drop - this.dropDecrease, 0.0);
            }
            this.lastFreeze = l2;
        }
        return !(this.rng.nextDouble() < this.drop);
    }

    static {
        int n2 = Integer.getInteger(CONNECTION_THROTTLE_TOKENS, 0);
        int n3 = Integer.getInteger(CONNECTION_THROTTLE_FILL_COUNT, 1);
        connectionWeightEnabled = Boolean.getBoolean(WEIGHED_CONNECTION_THROTTLE);
        int n4 = Integer.getInteger(GLOBAL_SESSION_WEIGHT, 3);
        int n5 = Integer.getInteger(LOCAL_SESSION_WEIGHT, 1);
        int n6 = Integer.getInteger(RENEW_SESSION_WEIGHT, 2);
        if (n4 <= 0) {
            LOG.d("Invalid global session weight {}. It should be larger than 0", (Object)n4);
            DEFAULT_GLOBAL_SESSION_WEIGHT = 3;
        } else if (n4 < n5) {
            LOG.d("The global session weight {} is less than the local session weight {}. Use the local session weight.", (Object)n4, (Object)n5);
            DEFAULT_GLOBAL_SESSION_WEIGHT = n5;
        } else {
            DEFAULT_GLOBAL_SESSION_WEIGHT = n4;
        }
        if (n5 <= 0) {
            LOG.d("Invalid local session weight {}. It should be larger than 0", (Object)n5);
            DEFAULT_LOCAL_SESSION_WEIGHT = 1;
        } else {
            DEFAULT_LOCAL_SESSION_WEIGHT = n5;
        }
        if (n6 <= 0) {
            LOG.d("Invalid renew session weight {}. It should be larger than 0", (Object)n6);
            DEFAULT_RENEW_SESSION_WEIGHT = 2;
        } else if (n6 < n5) {
            LOG.d("The renew session weight {} is less than the local session weight {}. Use the local session weight.", (Object)n6, (Object)n5);
            DEFAULT_RENEW_SESSION_WEIGHT = n5;
        } else {
            DEFAULT_RENEW_SESSION_WEIGHT = n6;
        }
        DEFAULT_CONNECTION_THROTTLE_TOKENS = connectionWeightEnabled ? DEFAULT_GLOBAL_SESSION_WEIGHT * n2 : n2;
        DEFAULT_CONNECTION_THROTTLE_FILL_TIME = Integer.getInteger(CONNECTION_THROTTLE_FILL_TIME, 1);
        DEFAULT_CONNECTION_THROTTLE_FILL_COUNT = connectionWeightEnabled ? DEFAULT_GLOBAL_SESSION_WEIGHT * n3 : n3;
        DEFAULT_CONNECTION_THROTTLE_FREEZE_TIME = Integer.getInteger(CONNECTION_THROTTLE_FREEZE_TIME, -1);
        DEFAULT_CONNECTION_THROTTLE_DROP_INCREASE = BlueThrottle.getDoubleProp(CONNECTION_THROTTLE_DROP_INCREASE, 0.02);
        DEFAULT_CONNECTION_THROTTLE_DROP_DECREASE = BlueThrottle.getDoubleProp(CONNECTION_THROTTLE_DROP_DECREASE, 0.002);
        DEFAULT_CONNECTION_THROTTLE_DECREASE_RATIO = BlueThrottle.getDoubleProp(CONNECTION_THROTTLE_DECREASE_RATIO, 0.0);
        BlueThrottle.logWeighedThrottlingSetting();
    }
}

