/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.impl;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.Counter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.CounterSet;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.Gauge;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.GaugeSet;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsContext;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.MetricsProviderLifeCycleException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.Summary;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.SummarySet;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric.AvgMinMaxCounter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric.AvgMinMaxCounterSet;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounterSet;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric.SimpleCounter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.metric.SimpleCounterSet;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;

public class DefaultMetricsProvider
implements MetricsProvider {
    private final DefaultMetricsContext rootMetricsContext = new DefaultMetricsContext();

    @Override
    public void configure(Properties properties) throws MetricsProviderLifeCycleException {
    }

    @Override
    public void start() throws MetricsProviderLifeCycleException {
    }

    @Override
    public MetricsContext getRootContext() {
        return this.rootMetricsContext;
    }

    @Override
    public void stop() {
        this.rootMetricsContext.gauges.clear();
        this.rootMetricsContext.gaugeSets.clear();
    }

    @Override
    public void dump(BiConsumer<String, Object> biConsumer) {
        this.rootMetricsContext.dump(biConsumer);
    }

    @Override
    public void resetAllValues() {
        this.rootMetricsContext.reset();
    }

    static final class DefaultMetricsContext
    implements MetricsContext {
        private final ConcurrentMap<String, Gauge> gauges = new ConcurrentHashMap<String, Gauge>();
        private final ConcurrentMap<String, GaugeSet> gaugeSets = new ConcurrentHashMap<String, GaugeSet>();
        private final ConcurrentMap<String, SimpleCounter> counters = new ConcurrentHashMap<String, SimpleCounter>();
        private final ConcurrentMap<String, SimpleCounterSet> counterSets = new ConcurrentHashMap<String, SimpleCounterSet>();
        private final ConcurrentMap<String, AvgMinMaxCounter> basicSummaries = new ConcurrentHashMap<String, AvgMinMaxCounter>();
        private final ConcurrentMap<String, AvgMinMaxPercentileCounter> summaries = new ConcurrentHashMap<String, AvgMinMaxPercentileCounter>();
        private final ConcurrentMap<String, AvgMinMaxCounterSet> basicSummarySets = new ConcurrentHashMap<String, AvgMinMaxCounterSet>();
        private final ConcurrentMap<String, AvgMinMaxPercentileCounterSet> summarySets = new ConcurrentHashMap<String, AvgMinMaxPercentileCounterSet>();

        private DefaultMetricsContext() {
        }

        @Override
        public MetricsContext getContext(String string) {
            return this;
        }

        @Override
        public Counter getCounter(String string2) {
            return this.counters.computeIfAbsent(string2, string -> new SimpleCounter((String)string));
        }

        @Override
        public CounterSet getCounterSet(String string) {
            Objects.requireNonNull(string, "Cannot register a CounterSet with null name");
            return this.counterSets.computeIfAbsent(string, SimpleCounterSet::new);
        }

        @Override
        public void registerGauge(String string, Gauge gauge) {
            Objects.requireNonNull(gauge, "Cannot register a null Gauge for " + string);
            this.gauges.put(string, gauge);
        }

        @Override
        public void unregisterGauge(String string) {
            this.gauges.remove(string);
        }

        @Override
        public void registerGaugeSet(String string, GaugeSet gaugeSet) {
            Objects.requireNonNull(string, "Cannot register a GaugeSet with null name");
            Objects.requireNonNull(gaugeSet, "Cannot register a null GaugeSet for " + string);
            this.gaugeSets.put(string, gaugeSet);
        }

        @Override
        public void unregisterGaugeSet(String string) {
            Objects.requireNonNull(string, "Cannot unregister GaugeSet with null name");
            this.gaugeSets.remove(string);
        }

        @Override
        public Summary getSummary(String string, MetricsContext.DetailLevel detailLevel) {
            if (detailLevel == MetricsContext.DetailLevel.BASIC) {
                return this.basicSummaries.computeIfAbsent(string, string2 -> {
                    if (this.summaries.containsKey(string2)) {
                        throw new IllegalArgumentException("Already registered a non basic summary as " + string2);
                    }
                    return new AvgMinMaxCounter(string);
                });
            }
            return this.summaries.computeIfAbsent(string, string2 -> {
                if (this.basicSummaries.containsKey(string2)) {
                    throw new IllegalArgumentException("Already registered a basic summary as " + string2);
                }
                return new AvgMinMaxPercentileCounter(string);
            });
        }

        @Override
        public SummarySet getSummarySet(String string, MetricsContext.DetailLevel detailLevel) {
            if (detailLevel == MetricsContext.DetailLevel.BASIC) {
                return this.basicSummarySets.computeIfAbsent(string, string2 -> {
                    if (this.summarySets.containsKey(string2)) {
                        throw new IllegalArgumentException("Already registered a non basic summary set as " + string2);
                    }
                    return new AvgMinMaxCounterSet(string);
                });
            }
            return this.summarySets.computeIfAbsent(string, string2 -> {
                if (this.basicSummarySets.containsKey(string2)) {
                    throw new IllegalArgumentException("Already registered a basic summary set as " + string2);
                }
                return new AvgMinMaxPercentileCounterSet(string);
            });
        }

        void dump(BiConsumer<String, Object> biConsumer) {
            this.gauges.forEach((string, gauge) -> {
                Number number = gauge.get();
                if (number != null) {
                    biConsumer.accept((String)string, number);
                }
            });
            this.gaugeSets.forEach((string, gaugeSet) -> gaugeSet.values().forEach((string2, number) -> {
                if (string2 != null) {
                    biConsumer.accept(string2 + "_" + string, number != null ? (Number)((Number)number) : (Number)0);
                }
            }));
            this.counters.values().forEach(simpleCounter -> simpleCounter.values().forEach(biConsumer));
            this.counterSets.values().forEach(simpleCounterSet -> simpleCounterSet.values().forEach(biConsumer));
            this.basicSummaries.values().forEach(avgMinMaxCounter -> avgMinMaxCounter.values().forEach(biConsumer));
            this.summaries.values().forEach(avgMinMaxPercentileCounter -> avgMinMaxPercentileCounter.values().forEach(biConsumer));
            this.basicSummarySets.values().forEach(avgMinMaxCounterSet -> avgMinMaxCounterSet.values().forEach(biConsumer));
            this.summarySets.values().forEach(avgMinMaxPercentileCounterSet -> avgMinMaxPercentileCounterSet.values().forEach(biConsumer));
        }

        void reset() {
            this.counters.values().forEach(simpleCounter -> simpleCounter.reset());
            this.counterSets.values().forEach(simpleCounterSet -> simpleCounterSet.reset());
            this.basicSummaries.values().forEach(avgMinMaxCounter -> avgMinMaxCounter.reset());
            this.summaries.values().forEach(avgMinMaxPercentileCounter -> avgMinMaxPercentileCounter.reset());
            this.basicSummarySets.values().forEach(avgMinMaxCounterSet -> avgMinMaxCounterSet.reset());
            this.summarySets.values().forEach(avgMinMaxPercentileCounterSet -> avgMinMaxPercentileCounterSet.reset());
        }
    }
}

