/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ClientX509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.QuorumX509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.VerifyingFileFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ZKConfig {
    private static final foe LOG = goe.a(ZKConfig.class);
    public static final String JUTE_MAXBUFFER = "jute.maxbuffer";
    public static final String KINIT_COMMAND = "zookeeper.kinit";
    public static final String JGSS_NATIVE = "sun.security.jgss.native";
    private final Map<String, String> properties = new HashMap<String, String>();

    public ZKConfig() {
        this.init();
    }

    public ZKConfig(String string) throws QuorumPeerConfig.ConfigException {
        this(new File(string));
    }

    public ZKConfig(File file) throws QuorumPeerConfig.ConfigException {
        this();
        this.addConfiguration(file);
        LOG.c("ZK Config {}", (Object)this.properties);
    }

    private void init() {
        this.handleBackwardCompatibility();
    }

    public void handleBackwardCompatibility() {
        this.properties.put(JUTE_MAXBUFFER, System.getProperty(JUTE_MAXBUFFER));
        this.properties.put(KINIT_COMMAND, System.getProperty(KINIT_COMMAND));
        this.properties.put(JGSS_NATIVE, System.getProperty(JGSS_NATIVE));
        try (X509Util x509Util = new ClientX509Util();){
            this.putSSLProperties(x509Util);
            this.properties.put(((ClientX509Util)x509Util).getSslAuthProviderProperty(), System.getProperty(((ClientX509Util)x509Util).getSslAuthProviderProperty()));
            this.properties.put(((ClientX509Util)x509Util).getSslProviderProperty(), System.getProperty(((ClientX509Util)x509Util).getSslProviderProperty()));
        }
        x509Util = new QuorumX509Util();
        try {
            this.putSSLProperties(x509Util);
        }
        finally {
            x509Util.close();
        }
    }

    private void putSSLProperties(X509Util x509Util) {
        this.properties.put(x509Util.getSslProtocolProperty(), System.getProperty(x509Util.getSslProtocolProperty()));
        this.properties.put(x509Util.getSslEnabledProtocolsProperty(), System.getProperty(x509Util.getSslEnabledProtocolsProperty()));
        this.properties.put(x509Util.getSslCipherSuitesProperty(), System.getProperty(x509Util.getSslCipherSuitesProperty()));
        this.properties.put(x509Util.getSslKeystoreLocationProperty(), System.getProperty(x509Util.getSslKeystoreLocationProperty()));
        this.properties.put(x509Util.getSslKeystorePasswdProperty(), System.getProperty(x509Util.getSslKeystorePasswdProperty()));
        this.properties.put(x509Util.getSslKeystorePasswdPathProperty(), System.getProperty(x509Util.getSslKeystorePasswdPathProperty()));
        this.properties.put(x509Util.getSslKeystoreTypeProperty(), System.getProperty(x509Util.getSslKeystoreTypeProperty()));
        this.properties.put(x509Util.getSslTruststoreLocationProperty(), System.getProperty(x509Util.getSslTruststoreLocationProperty()));
        this.properties.put(x509Util.getSslTruststorePasswdProperty(), System.getProperty(x509Util.getSslTruststorePasswdProperty()));
        this.properties.put(x509Util.getSslTruststorePasswdPathProperty(), System.getProperty(x509Util.getSslTruststorePasswdPathProperty()));
        this.properties.put(x509Util.getSslTruststoreTypeProperty(), System.getProperty(x509Util.getSslTruststoreTypeProperty()));
        this.properties.put(x509Util.getSslContextSupplierClassProperty(), System.getProperty(x509Util.getSslContextSupplierClassProperty()));
        this.properties.put(x509Util.getSslHostnameVerificationEnabledProperty(), System.getProperty(x509Util.getSslHostnameVerificationEnabledProperty()));
        this.properties.put(x509Util.getSslCrlEnabledProperty(), System.getProperty(x509Util.getSslCrlEnabledProperty()));
        this.properties.put(x509Util.getSslOcspEnabledProperty(), System.getProperty(x509Util.getSslOcspEnabledProperty()));
        this.properties.put(x509Util.getSslClientAuthProperty(), System.getProperty(x509Util.getSslClientAuthProperty()));
        this.properties.put(x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), System.getProperty(x509Util.getSslHandshakeDetectionTimeoutMillisProperty()));
        this.properties.put(x509Util.getFipsModeProperty(), System.getProperty(x509Util.getFipsModeProperty()));
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.properties.get(string);
        return string3 == null ? string2 : string3;
    }

    public String getJaasConfKey() {
        return System.getProperty("java.security.auth.login.config");
    }

    public void setProperty(String string, String string2) {
        if (null == string) {
            throw new IllegalArgumentException("property key is null.");
        }
        String string3 = this.properties.put(string, string2);
        if (null != string3 && !string3.equals(string2)) {
            LOG.b("key {}'s value {} is replaced with new value {}", string, string3, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguration(File file) throws QuorumPeerConfig.ConfigException {
        LOG.c("Reading configuration from: {}", (Object)file.getAbsolutePath());
        try {
            file = new VerifyingFileFactory.Builder(LOG).warnForRelativePath().failForNonExistingPath().build().validate(file);
            Properties properties = new Properties();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
            }
            this.parseProperties(properties);
        }
        catch (IOException | IllegalArgumentException exception) {
            LOG.e("Error while configuration from: {}", (Object)file.getAbsolutePath(), (Object)exception);
            throw new QuorumPeerConfig.ConfigException("Error while processing " + file.getAbsolutePath(), exception);
        }
    }

    public void addConfiguration(String string) throws QuorumPeerConfig.ConfigException {
        this.addConfiguration(new File(string));
    }

    private void parseProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = entry.getKey().toString().trim();
            String string2 = entry.getValue().toString().trim();
            this.setProperty(string, string2);
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl2) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return bl2;
        }
        return Boolean.parseBoolean(string2.trim());
    }

    public int getInt(String string, int n2) {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            return Integer.decode(string2.trim());
        }
        return n2;
    }
}

