/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.FileChangeWatcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.FileKeyStoreLoaderBuilderProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.KeyStoreFileType;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.SSLContextAndOptions;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.SecretUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Exception;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKTrustManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ProviderRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class X509Util
implements Closeable,
AutoCloseable {
    private static final foe LOG = goe.a(X509Util.class);
    private static final String REJECT_CLIENT_RENEGOTIATION_PROPERTY = "jdk.tls.rejectClientInitiatedRenegotiation";
    private static final String FIPS_MODE_PROPERTY = "zookeeper.fips-mode";
    public static final String TLS_1_1 = "TLSv1.1";
    public static final String TLS_1_2 = "TLSv1.2";
    public static final String TLS_1_3 = "TLSv1.3";
    public static final String DEFAULT_PROTOCOL;
    private static final String[] DEFAULT_CIPHERS_JAVA8;
    private static final String[] DEFAULT_CIPHERS_JAVA9;
    public static final int DEFAULT_HANDSHAKE_DETECTION_TIMEOUT_MILLIS = 5000;
    private final String sslProtocolProperty = this.getConfigPrefix() + "protocol";
    private final String sslEnabledProtocolsProperty = this.getConfigPrefix() + "enabledProtocols";
    private final String cipherSuitesProperty = this.getConfigPrefix() + "ciphersuites";
    private final String sslKeystoreLocationProperty = this.getConfigPrefix() + "keyStore.location";
    private final String sslKeystorePasswdProperty = this.getConfigPrefix() + "keyStore.password";
    private final String sslKeystorePasswdPathProperty = this.getConfigPrefix() + "keyStore.passwordPath";
    private final String sslKeystoreTypeProperty = this.getConfigPrefix() + "keyStore.type";
    private final String sslTruststoreLocationProperty = this.getConfigPrefix() + "trustStore.location";
    private final String sslTruststorePasswdProperty = this.getConfigPrefix() + "trustStore.password";
    private final String sslTruststorePasswdPathProperty = this.getConfigPrefix() + "trustStore.passwordPath";
    private final String sslTruststoreTypeProperty = this.getConfigPrefix() + "trustStore.type";
    private final String sslContextSupplierClassProperty = this.getConfigPrefix() + "context.supplier.class";
    private final String sslHostnameVerificationEnabledProperty = this.getConfigPrefix() + "hostnameVerification";
    private final String sslCrlEnabledProperty = this.getConfigPrefix() + "crl";
    private final String sslOcspEnabledProperty = this.getConfigPrefix() + "ocsp";
    private final String sslClientAuthProperty = this.getConfigPrefix() + "clientAuth";
    private final String sslHandshakeDetectionTimeoutMillisProperty = this.getConfigPrefix() + "handshakeDetectionTimeoutMillis";
    private final AtomicReference<SSLContextAndOptions> defaultSSLContextAndOptions = new AtomicReference<Object>(null);
    private FileChangeWatcher keyStoreFileWatcher = null;
    private FileChangeWatcher trustStoreFileWatcher = null;

    private static String defaultTlsProtocol() {
        String string = TLS_1_2;
        List<Object> list = new ArrayList();
        try {
            list = Arrays.asList(SSLContext.getDefault().getSupportedSSLParameters().getProtocols());
            if (list.contains(TLS_1_3)) {
                string = TLS_1_3;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        LOG.c("Default TLS protocol is {}, supported TLS protocols are {}", (Object)string, (Object)list);
        return string;
    }

    private static String[] getTLSv13Ciphers() {
        return new String[]{"TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_CHACHA20_POLY1305_SHA256"};
    }

    private static String[] getGCMCiphers() {
        return new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};
    }

    private static String[] getCBCCiphers() {
        return new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"};
    }

    private static String[] getSupportedCiphers(String[] ... stringArray) {
        List<String> list = Arrays.asList(((SSLServerSocketFactory)SSLServerSocketFactory.getDefault()).getSupportedCipherSuites());
        return Arrays.stream(stringArray).flatMap(Arrays::stream).filter(list::contains).collect(Collectors.toList()).toArray(new String[0]);
    }

    protected abstract String getConfigPrefix();

    protected abstract boolean shouldVerifyClientHostname();

    public String getSslProtocolProperty() {
        return this.sslProtocolProperty;
    }

    public String getSslEnabledProtocolsProperty() {
        return this.sslEnabledProtocolsProperty;
    }

    public String getCipherSuitesProperty() {
        return this.cipherSuitesProperty;
    }

    public String getSslKeystoreLocationProperty() {
        return this.sslKeystoreLocationProperty;
    }

    public String getSslCipherSuitesProperty() {
        return this.cipherSuitesProperty;
    }

    public String getSslKeystorePasswdProperty() {
        return this.sslKeystorePasswdProperty;
    }

    public String getSslKeystorePasswdPathProperty() {
        return this.sslKeystorePasswdPathProperty;
    }

    public String getSslKeystoreTypeProperty() {
        return this.sslKeystoreTypeProperty;
    }

    public String getSslTruststoreLocationProperty() {
        return this.sslTruststoreLocationProperty;
    }

    public String getSslTruststorePasswdProperty() {
        return this.sslTruststorePasswdProperty;
    }

    public String getSslTruststorePasswdPathProperty() {
        return this.sslTruststorePasswdPathProperty;
    }

    public String getSslTruststoreTypeProperty() {
        return this.sslTruststoreTypeProperty;
    }

    public String getSslContextSupplierClassProperty() {
        return this.sslContextSupplierClassProperty;
    }

    public String getSslHostnameVerificationEnabledProperty() {
        return this.sslHostnameVerificationEnabledProperty;
    }

    public String getSslCrlEnabledProperty() {
        return this.sslCrlEnabledProperty;
    }

    public String getSslOcspEnabledProperty() {
        return this.sslOcspEnabledProperty;
    }

    public String getSslClientAuthProperty() {
        return this.sslClientAuthProperty;
    }

    public String getSslHandshakeDetectionTimeoutMillisProperty() {
        return this.sslHandshakeDetectionTimeoutMillisProperty;
    }

    public String getFipsModeProperty() {
        return FIPS_MODE_PROPERTY;
    }

    public boolean getFipsMode(ZKConfig zKConfig) {
        return zKConfig.getBoolean(FIPS_MODE_PROPERTY, true);
    }

    public boolean isServerHostnameVerificationEnabled(ZKConfig zKConfig) {
        return zKConfig.getBoolean(this.getSslHostnameVerificationEnabledProperty(), true);
    }

    public boolean isClientHostnameVerificationEnabled(ZKConfig zKConfig) {
        return this.isServerHostnameVerificationEnabled(zKConfig) && this.shouldVerifyClientHostname();
    }

    public SSLContext getDefaultSSLContext() throws X509Exception.SSLContextException {
        return this.getDefaultSSLContextAndOptions().getSSLContext();
    }

    public SSLContext createSSLContext(ZKConfig zKConfig) throws X509Exception.SSLContextException {
        return this.createSSLContextAndOptions(zKConfig).getSSLContext();
    }

    public SSLContextAndOptions getDefaultSSLContextAndOptions() throws X509Exception.SSLContextException {
        SSLContextAndOptions sSLContextAndOptions = this.defaultSSLContextAndOptions.get();
        if (sSLContextAndOptions == null && !this.defaultSSLContextAndOptions.compareAndSet(null, sSLContextAndOptions = this.createSSLContextAndOptions())) {
            sSLContextAndOptions = this.defaultSSLContextAndOptions.get();
        }
        return sSLContextAndOptions;
    }

    private void resetDefaultSSLContextAndOptions() throws X509Exception.SSLContextException {
        SSLContextAndOptions sSLContextAndOptions = this.createSSLContextAndOptions();
        this.defaultSSLContextAndOptions.set(sSLContextAndOptions);
        if (Boolean.getBoolean("zookeeper.client.certReload")) {
            ProviderRegistry.addOrUpdateProvider("zookeeper.authProvider.x509");
        }
    }

    private SSLContextAndOptions createSSLContextAndOptions() throws X509Exception.SSLContextException {
        return this.createSSLContextAndOptions(new ZKConfig());
    }

    public int getSslHandshakeTimeoutMillis() {
        try {
            SSLContextAndOptions sSLContextAndOptions = this.getDefaultSSLContextAndOptions();
            return sSLContextAndOptions.getHandshakeDetectionTimeoutMillis();
        }
        catch (X509Exception.SSLContextException sSLContextException) {
            LOG.d("Error creating SSL context and options", sSLContextException);
            return 5000;
        }
        catch (Exception exception) {
            LOG.e("Error parsing config property {}", (Object)this.getSslHandshakeDetectionTimeoutMillisProperty(), (Object)exception);
            return 5000;
        }
    }

    public SSLContextAndOptions createSSLContextAndOptions(ZKConfig zKConfig) throws X509Exception.SSLContextException {
        String string = zKConfig.getProperty(this.sslContextSupplierClassProperty);
        if (string != null) {
            LOG.b("Loading SSLContext supplier from property '{}'", (Object)this.sslContextSupplierClassProperty);
            try {
                Class<?> clazz = Class.forName(string);
                Supplier supplier = (Supplier)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                return new SSLContextAndOptions(this, zKConfig, (SSLContext)supplier.get());
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                throw new X509Exception.SSLContextException("Could not retrieve the SSLContext from supplier source '" + string + "' provided in the property '" + this.sslContextSupplierClassProperty + "'", exception);
            }
        }
        return this.createSSLContextAndOptionsFromConfig(zKConfig);
    }

    public SSLContextAndOptions createSSLContextAndOptionsFromConfig(ZKConfig zKConfig) throws X509Exception.SSLContextException {
        KeyManager[] keyManagerArray = null;
        TrustManager[] trustManagerArray = null;
        String string = zKConfig.getProperty(this.sslKeystoreLocationProperty, "");
        String string2 = this.getPasswordFromConfigPropertyOrFile(zKConfig, this.sslKeystorePasswdProperty, this.sslKeystorePasswdPathProperty);
        String string3 = zKConfig.getProperty(this.sslKeystoreTypeProperty);
        if (string.isEmpty()) {
            LOG.d("{} not specified", (Object)this.getSslKeystoreLocationProperty());
        } else {
            try {
                keyManagerArray = new KeyManager[]{X509Util.createKeyManager(string, string2, string3)};
            }
            catch (X509Exception.KeyManagerException keyManagerException) {
                throw new X509Exception.SSLContextException("Failed to create KeyManager", keyManagerException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new X509Exception.SSLContextException("Bad value for " + this.sslKeystoreTypeProperty + ": " + string3, illegalArgumentException);
            }
        }
        String string4 = zKConfig.getProperty(this.sslTruststoreLocationProperty, "");
        String string5 = this.getPasswordFromConfigPropertyOrFile(zKConfig, this.sslTruststorePasswdProperty, this.sslTruststorePasswdPathProperty);
        String string6 = zKConfig.getProperty(this.sslTruststoreTypeProperty);
        boolean bl2 = zKConfig.getBoolean(this.sslCrlEnabledProperty);
        boolean bl3 = zKConfig.getBoolean(this.sslOcspEnabledProperty);
        boolean bl4 = this.isServerHostnameVerificationEnabled(zKConfig);
        boolean bl5 = this.isClientHostnameVerificationEnabled(zKConfig);
        boolean bl6 = this.getFipsMode(zKConfig);
        if (string4.isEmpty()) {
            LOG.d("{} not specified", (Object)this.getSslTruststoreLocationProperty());
        } else {
            try {
                trustManagerArray = new TrustManager[]{X509Util.createTrustManager(string4, string5, string6, bl2, bl3, bl4, bl5, bl6)};
            }
            catch (X509Exception.TrustManagerException trustManagerException) {
                throw new X509Exception.SSLContextException("Failed to create TrustManager", trustManagerException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new X509Exception.SSLContextException("Bad value for " + this.sslTruststoreTypeProperty + ": " + string6, illegalArgumentException);
            }
        }
        String string7 = zKConfig.getProperty(this.sslProtocolProperty, DEFAULT_PROTOCOL);
        try {
            SSLContext sSLContext = SSLContext.getInstance(string7);
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            return new SSLContextAndOptions(this, zKConfig, sSLContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            throw new X509Exception.SSLContextException(generalSecurityException);
        }
    }

    public static KeyStore loadKeyStore(String string, String string2, String string3) throws IOException, GeneralSecurityException {
        KeyStoreFileType keyStoreFileType = KeyStoreFileType.fromPropertyValueOrFileName(string3, string);
        return FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(keyStoreFileType).setKeyStorePath(string).setKeyStorePassword(string2).build().loadKeyStore();
    }

    public static KeyStore loadTrustStore(String string, String string2, String string3) throws IOException, GeneralSecurityException {
        KeyStoreFileType keyStoreFileType = KeyStoreFileType.fromPropertyValueOrFileName(string3, string);
        return FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(keyStoreFileType).setTrustStorePath(string).setTrustStorePassword(string2).build().loadTrustStore();
    }

    public String getPasswordFromConfigPropertyOrFile(ZKConfig zKConfig, String string, String string2) {
        String string3 = zKConfig.getProperty(string, "");
        String string4 = zKConfig.getProperty(string2, "");
        if (!string4.isEmpty()) {
            string3 = String.valueOf(SecretUtils.readSecret(string4));
        }
        return string3;
    }

    public static X509KeyManager createKeyManager(String string, String string2, String string3) throws X509Exception.KeyManagerException {
        if (string2 == null) {
            string2 = "";
        }
        try {
            KeyStore keyStore = X509Util.loadKeyStore(string, string2, string3);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX");
            keyManagerFactory.init(keyStore, string2.toCharArray());
            for (KeyManager keyManager : keyManagerFactory.getKeyManagers()) {
                if (!(keyManager instanceof X509KeyManager)) continue;
                return (X509KeyManager)keyManager;
            }
            throw new X509Exception.KeyManagerException("Couldn't find X509KeyManager");
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException exception) {
            throw new X509Exception.KeyManagerException(exception);
        }
    }

    public static X509TrustManager createTrustManager(String string, String string2, String string3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws X509Exception.TrustManagerException {
        if (string2 == null) {
            string2 = "";
        }
        try {
            KeyStore keyStore = X509Util.loadTrustStore(string, string2, string3);
            PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
            if (bl2 || bl3) {
                pKIXBuilderParameters.setRevocationEnabled(true);
                System.setProperty("com.sun.net.ssl.checkRevocation", "true");
                System.setProperty("com.sun.security.enableCRLDP", "true");
                if (bl3) {
                    Security.setProperty("ocsp.enable", "true");
                }
            } else {
                pKIXBuilderParameters.setRevocationEnabled(false);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            trustManagerFactory.init(new CertPathTrustManagerParameters(pKIXBuilderParameters));
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
                if (bl6) {
                    if (LOG.c()) {
                        LOG.b("FIPS mode is ON: selecting standard x509 trust manager {}", (Object)trustManager);
                    }
                    return (X509TrustManager)trustManager;
                }
                if (LOG.c()) {
                    LOG.b("FIPS mode is OFF: creating ZKTrustManager");
                }
                return new ZKTrustManager((X509ExtendedTrustManager)trustManager, bl4, bl5);
            }
            throw new X509Exception.TrustManagerException("Couldn't find X509TrustManager");
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException exception) {
            throw new X509Exception.TrustManagerException(exception);
        }
    }

    public SSLSocket createSSLSocket() throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLSocket();
    }

    public SSLSocket createSSLSocket(Socket socket, byte[] byArray) throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLSocket(socket, byArray);
    }

    public SSLServerSocket createSSLServerSocket() throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLServerSocket();
    }

    public SSLServerSocket createSSLServerSocket(int n2) throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLServerSocket(n2);
    }

    static String[] getDefaultCipherSuites() {
        return X509Util.getDefaultCipherSuitesForJavaVersion(System.getProperty("java.specification.version"));
    }

    static String[] getDefaultCipherSuitesForJavaVersion(String string) {
        Objects.requireNonNull(string);
        if (string.matches("\\d+")) {
            LOG.b("Using Java9+ optimized cipher suites for Java version {}", (Object)string);
            return DEFAULT_CIPHERS_JAVA9;
        }
        if (string.startsWith("1.")) {
            LOG.b("Using Java8 optimized cipher suites for Java version {}", (Object)string);
            return DEFAULT_CIPHERS_JAVA8;
        }
        LOG.b("Could not parse java version {}, using Java8 optimized cipher suites", (Object)string);
        return DEFAULT_CIPHERS_JAVA8;
    }

    private FileChangeWatcher newFileChangeWatcher(String string) throws IOException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        Path path = Paths.get(string, new String[0]).toAbsolutePath();
        Path path2 = path.getParent();
        if (path2 == null) {
            throw new IOException("Key/trust store path does not have a parent: " + path);
        }
        return new FileChangeWatcher(path2, watchEvent -> this.handleWatchEvent(path, (WatchEvent<?>)watchEvent));
    }

    public void enableCertFileReloading() throws IOException {
        FileChangeWatcher fileChangeWatcher;
        LOG.c("enabling cert file reloading");
        ZKConfig zKConfig = new ZKConfig();
        FileChangeWatcher fileChangeWatcher2 = this.newFileChangeWatcher(zKConfig.getProperty(this.sslKeystoreLocationProperty));
        if (fileChangeWatcher2 != null) {
            if (this.keyStoreFileWatcher != null) {
                this.keyStoreFileWatcher.stop();
            }
            this.keyStoreFileWatcher = fileChangeWatcher2;
            this.keyStoreFileWatcher.start();
        }
        if ((fileChangeWatcher = this.newFileChangeWatcher(zKConfig.getProperty(this.sslTruststoreLocationProperty))) != null) {
            if (this.trustStoreFileWatcher != null) {
                this.trustStoreFileWatcher.stop();
            }
            this.trustStoreFileWatcher = fileChangeWatcher;
            this.trustStoreFileWatcher.start();
        }
    }

    @Override
    public void close() {
        this.defaultSSLContextAndOptions.set(null);
        if (this.keyStoreFileWatcher != null) {
            this.keyStoreFileWatcher.stop();
            this.keyStoreFileWatcher = null;
        }
        if (this.trustStoreFileWatcher != null) {
            this.trustStoreFileWatcher.stop();
            this.trustStoreFileWatcher = null;
        }
    }

    private void handleWatchEvent(Path path, WatchEvent<?> watchEvent) {
        Path path2;
        boolean bl2 = false;
        Path path3 = path.getParent();
        if (watchEvent.kind().equals(StandardWatchEventKinds.OVERFLOW)) {
            bl2 = true;
        } else if ((watchEvent.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY) || watchEvent.kind().equals(StandardWatchEventKinds.ENTRY_CREATE)) && path.equals(path2 = path3.resolve((Path)watchEvent.context()))) {
            bl2 = true;
        }
        if (bl2) {
            LOG.b("Attempting to reset default SSL context after receiving watch event: {} with context: {}", (Object)watchEvent.kind(), watchEvent.context());
            try {
                this.resetDefaultSSLContextAndOptions();
            }
            catch (X509Exception.SSLContextException sSLContextException) {
                throw new RuntimeException(sSLContextException);
            }
        } else {
            LOG.b("Ignoring watch event and keeping previous default SSL context. Event kind: {} with context: {}", (Object)watchEvent.kind(), watchEvent.context());
        }
    }

    static {
        if (System.getProperty(REJECT_CLIENT_RENEGOTIATION_PROPERTY) == null) {
            LOG.c("Setting -D {}=true to disable client-initiated TLS renegotiation", (Object)REJECT_CLIENT_RENEGOTIATION_PROPERTY);
            System.setProperty(REJECT_CLIENT_RENEGOTIATION_PROPERTY, Boolean.TRUE.toString());
        }
        DEFAULT_PROTOCOL = X509Util.defaultTlsProtocol();
        DEFAULT_CIPHERS_JAVA8 = X509Util.getSupportedCiphers(X509Util.getCBCCiphers(), X509Util.getGCMCiphers(), X509Util.getTLSv13Ciphers());
        DEFAULT_CIPHERS_JAVA9 = X509Util.getSupportedCiphers(X509Util.getGCMCiphers(), X509Util.getCBCCiphers(), X509Util.getTLSv13Ciphers());
    }

    public static enum ClientAuth {
        NONE(XdepsXdatabricksX240X9088.io.netty.handler.ssl.ClientAuth.NONE),
        WANT(XdepsXdatabricksX240X9088.io.netty.handler.ssl.ClientAuth.OPTIONAL),
        NEED(XdepsXdatabricksX240X9088.io.netty.handler.ssl.ClientAuth.REQUIRE);

        private final XdepsXdatabricksX240X9088.io.netty.handler.ssl.ClientAuth nettyAuth;

        private ClientAuth(XdepsXdatabricksX240X9088.io.netty.handler.ssl.ClientAuth clientAuth) {
            this.nettyAuth = clientAuth;
        }

        public static ClientAuth fromPropertyValue(String string) {
            if (string == null || string.length() == 0) {
                return NEED;
            }
            return ClientAuth.valueOf(string.toUpperCase());
        }

        public XdepsXdatabricksX240X9088.io.netty.handler.ssl.ClientAuth toNettyClientAuth() {
            return this.nettyAuth;
        }
    }
}

