/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;

public class PathTrie {
    private static final foe LOG = goe.a(PathTrie.class);
    private final TrieNode rootNode;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public PathTrie() {
        this.rootNode = new TrieNode(null, "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPath(String string) {
        Objects.requireNonNull(string, "Path cannot be null");
        if (string.length() == 0) {
            throw new IllegalArgumentException("Invalid path: " + string);
        }
        String[] stringArray = PathTrie.split(string);
        this.writeLock.lock();
        try {
            TrieNode trieNode = this.rootNode;
            for (String string2 : stringArray) {
                TrieNode trieNode2 = trieNode.getChild(string2);
                if (trieNode2 == null) {
                    trieNode2 = new TrieNode(trieNode, string2);
                    trieNode.addChild(string2, trieNode2);
                }
                trieNode = trieNode2;
            }
            trieNode.setProperty(true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePath(String string) {
        Objects.requireNonNull(string, "Path cannot be null");
        if (string.length() == 0) {
            throw new IllegalArgumentException("Invalid path: " + string);
        }
        String[] stringArray = PathTrie.split(string);
        this.writeLock.lock();
        try {
            TrieNode trieNode = this.rootNode;
            for (String string2 : stringArray) {
                if (trieNode.getChild(string2) == null) {
                    return;
                }
                trieNode = trieNode.getChild(string2);
                LOG.b("{}", (Object)trieNode);
            }
            TrieNode trieNode2 = trieNode.getParent();
            trieNode2.deleteChild(trieNode.getValue());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsNode(String string) {
        Objects.requireNonNull(string, "Path cannot be null");
        if (string.length() == 0) {
            throw new IllegalArgumentException("Invalid path: " + string);
        }
        String[] stringArray = PathTrie.split(string);
        this.readLock.lock();
        try {
            TrieNode trieNode = this.rootNode;
            for (String string2 : stringArray) {
                if (trieNode.getChild(string2) == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                trieNode = trieNode.getChild(string2);
                LOG.b("{}", (Object)trieNode);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findMaxPrefix(String string) {
        Objects.requireNonNull(string, "Path cannot be null");
        String[] stringArray = PathTrie.split(string);
        this.readLock.lock();
        try {
            Object object;
            TrieNode trieNode = this.rootNode;
            TrieNode trieNode2 = null;
            for (String string2 : stringArray) {
                if ((trieNode = trieNode.getChild(string2)) == null) {
                    LOG.b("{}", (Object)string2);
                    break;
                }
                if (!trieNode.hasProperty()) continue;
                trieNode2 = trieNode;
            }
            if (trieNode2 == null) {
                object = "/";
                return object;
            }
            object = new ArrayDeque();
            TrieNode trieNode3 = trieNode2;
            while (trieNode3 != this.rootNode) {
                object.offerFirst(trieNode3.getValue());
                trieNode3 = trieNode3.parent;
            }
            String string3 = "/" + String.join((CharSequence)"/", (Iterable<? extends CharSequence>)object);
            return string3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.rootNode.getChildren().clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static String[] split(String string2) {
        return (String[])Stream.of(string2.split("/")).filter(string -> !string.trim().isEmpty()).toArray(String[]::new);
    }

    static class TrieNode {
        final String value;
        final Map<String, TrieNode> children;
        boolean property;
        TrieNode parent;

        private TrieNode(TrieNode trieNode, String string) {
            this.value = string;
            this.parent = trieNode;
            this.property = false;
            this.children = new HashMap<String, TrieNode>(4);
        }

        TrieNode getParent() {
            return this.parent;
        }

        void setParent(TrieNode trieNode) {
            this.parent = trieNode;
        }

        void setProperty(boolean bl2) {
            this.property = bl2;
        }

        boolean hasProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        void addChild(String string, TrieNode trieNode) {
            this.children.putIfAbsent(string, trieNode);
        }

        void deleteChild(String string2) {
            this.children.computeIfPresent(string2, (string, trieNode) -> {
                trieNode.setProperty(false);
                if (trieNode.isLeafNode()) {
                    trieNode.setParent(null);
                    return null;
                }
                return trieNode;
            });
        }

        TrieNode getChild(String string) {
            return this.children.get(string);
        }

        Collection<String> getChildren() {
            return this.children.keySet();
        }

        boolean isLeafNode() {
            return this.children.isEmpty();
        }

        public String toString() {
            return "TrieNode [name=" + this.value + ", property=" + this.property + ", children=" + this.children.keySet() + "]";
        }
    }
}

