/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;

public class NettyUtils {
    private static final foe LOG = goe.a(NettyUtils.class);
    private static final int DEFAULT_INET_ADDRESS_COUNT = 1;

    public static EventLoopGroup newNioOrEpollEventLoopGroup() {
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup();
        }
        return new NioEventLoopGroup();
    }

    public static EventLoopGroup newNioOrEpollEventLoopGroup(int n2) {
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(n2);
        }
        return new NioEventLoopGroup(n2);
    }

    public static Class<? extends SocketChannel> nioOrEpollSocketChannel() {
        if (Epoll.isAvailable()) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> nioOrEpollServerSocketChannel() {
        if (Epoll.isAvailable()) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static int getClientReachableLocalInetAddressCount() {
        try {
            HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface networkInterface : Collections.list(enumeration)) {
                for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                    if (inetAddress.isLinkLocalAddress()) {
                        LOG.b("Ignoring link-local InetAddress {}", (Object)inetAddress);
                        continue;
                    }
                    if (inetAddress.isMulticastAddress()) {
                        LOG.b("Ignoring multicast InetAddress {}", (Object)inetAddress);
                        continue;
                    }
                    if (inetAddress.isLoopbackAddress()) {
                        LOG.b("Ignoring loopback InetAddress {}", (Object)inetAddress);
                        continue;
                    }
                    hashSet.add(inetAddress);
                }
            }
            LOG.b("Detected {} local network addresses: {}", (Object)hashSet.size(), (Object)hashSet);
            return hashSet.size() > 0 ? hashSet.size() : 1;
        }
        catch (SocketException socketException) {
            LOG.c("Failed to list all network interfaces, assuming 1", socketException);
            return 1;
        }
    }
}

