/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperThread;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Consumer;

public final class FileChangeWatcher {
    private static final foe LOG = goe.a(FileChangeWatcher.class);
    private final WatcherThread watcherThread;
    private State state;

    public FileChangeWatcher(Path path, Consumer<WatchEvent<?>> consumer) throws IOException {
        FileSystem fileSystem = path.getFileSystem();
        WatchService watchService = fileSystem.newWatchService();
        LOG.b("Registering with watch service: {}", (Object)path);
        path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
        this.state = State.NEW;
        this.watcherThread = new WatcherThread(watchService, consumer);
        this.watcherThread.setDaemon(true);
    }

    public synchronized State getState() {
        return this.state;
    }

    synchronized void waitForState(State state) throws InterruptedException {
        while (this.state != state) {
            this.wait();
        }
    }

    private synchronized void setState(State state) {
        this.state = state;
        this.notifyAll();
    }

    private synchronized boolean compareAndSetState(State state, State state2) {
        if (this.state == state) {
            this.setState(state2);
            return true;
        }
        return false;
    }

    private synchronized boolean compareAndSetState(State[] stateArray, State state) {
        for (State state2 : stateArray) {
            if (this.state != state2) continue;
            this.setState(state);
            return true;
        }
        return false;
    }

    public void start() {
        if (!this.compareAndSetState(State.NEW, State.STARTING)) {
            return;
        }
        this.watcherThread.start();
    }

    public void stop() {
        if (this.compareAndSetState(new State[]{State.RUNNING, State.STARTING}, State.STOPPING)) {
            this.watcherThread.interrupt();
        }
    }

    class WatcherThread
    extends ZooKeeperThread {
        private static final String THREAD_NAME = "FileChangeWatcher";
        final WatchService watchService;
        final Consumer<WatchEvent<?>> callback;

        WatcherThread(WatchService watchService, Consumer<WatchEvent<?>> consumer) {
            super(THREAD_NAME);
            this.watchService = watchService;
            this.callback = consumer;
        }

        @Override
        public void run() {
            try {
                LOG.c("{} thread started", (Object)this.getName());
                if (!FileChangeWatcher.this.compareAndSetState(State.STARTING, State.RUNNING)) {
                    State state = FileChangeWatcher.this.getState();
                    if (state != State.STOPPING) {
                        throw new IllegalStateException("Unexpected state: " + (Object)((Object)state));
                    }
                    return;
                }
                this.runLoop();
            }
            catch (Exception exception) {
                LOG.c("Error in runLoop()", exception);
                throw exception;
            }
            finally {
                try {
                    this.watchService.close();
                }
                catch (IOException iOException) {
                    LOG.c("Error closing watch service", iOException);
                }
                LOG.c("{} thread finished", (Object)this.getName());
                FileChangeWatcher.this.setState(State.STOPPED);
            }
        }

        private void runLoop() {
            while (FileChangeWatcher.this.getState() == State.RUNNING) {
                WatchKey watchKey;
                try {
                    watchKey = this.watchService.take();
                }
                catch (InterruptedException | ClosedWatchServiceException exception) {
                    LOG.b("{} was interrupted and is shutting down...", (Object)this.getName());
                    break;
                }
                for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                    LOG.b("Got file changed event: {} with context: {}", (Object)watchEvent.kind(), watchEvent.context());
                    try {
                        this.callback.accept(watchEvent);
                    }
                    catch (Throwable throwable) {
                        LOG.d("Error from callback", throwable);
                    }
                }
                boolean bl2 = watchKey.reset();
                if (bl2) continue;
                LOG.e("Watch key no longer valid, maybe the directory is inaccessible?");
                break;
            }
        }
    }

    public static enum State {
        NEW,
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

