/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.DelegatingSslContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslContextBuilder;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Exception;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKConfig;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;

public class ClientX509Util
extends X509Util {
    private static final foe LOG = goe.a(ClientX509Util.class);
    private final String sslAuthProviderProperty = this.getConfigPrefix() + "authProvider";
    private final String sslProviderProperty = this.getConfigPrefix() + "sslProvider";

    @Override
    protected String getConfigPrefix() {
        return "zookeeper.ssl.";
    }

    @Override
    protected boolean shouldVerifyClientHostname() {
        return false;
    }

    public String getSslAuthProviderProperty() {
        return this.sslAuthProviderProperty;
    }

    public String getSslProviderProperty() {
        return this.sslProviderProperty;
    }

    public SslContext createNettySslContextForClient(ZKConfig zKConfig) throws X509Exception.KeyManagerException, X509Exception.TrustManagerException, SSLException {
        String string = zKConfig.getProperty(this.getSslKeystoreLocationProperty(), "");
        String string2 = this.getPasswordFromConfigPropertyOrFile(zKConfig, this.getSslKeystorePasswdProperty(), this.getSslKeystorePasswdPathProperty());
        String string3 = zKConfig.getProperty(this.getSslKeystoreTypeProperty());
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
        if (string.isEmpty()) {
            LOG.d("{} not specified", (Object)this.getSslKeystoreLocationProperty());
        } else {
            sslContextBuilder.keyManager(ClientX509Util.createKeyManager(string, string2, string3));
        }
        TrustManager trustManager = this.getTrustManager(zKConfig);
        if (trustManager != null) {
            sslContextBuilder.trustManager(trustManager);
        }
        sslContextBuilder.enableOcsp(zKConfig.getBoolean(this.getSslOcspEnabledProperty()));
        sslContextBuilder.protocols(this.getEnabledProtocols(zKConfig));
        Iterable<String> iterable = this.getCipherSuites(zKConfig);
        if (iterable != null) {
            sslContextBuilder.ciphers(iterable);
        }
        sslContextBuilder.sslProvider(this.getSslProvider(zKConfig));
        SslContext sslContext = sslContextBuilder.build();
        if (this.getFipsMode(zKConfig) && this.isServerHostnameVerificationEnabled(zKConfig)) {
            return this.addHostnameVerification(sslContext, "Server");
        }
        return sslContext;
    }

    public SslContext createNettySslContextForServer(ZKConfig zKConfig) throws X509Exception.SSLContextException, X509Exception.KeyManagerException, X509Exception.TrustManagerException, SSLException {
        String string = zKConfig.getProperty(this.getSslKeystoreLocationProperty(), "");
        String string2 = this.getPasswordFromConfigPropertyOrFile(zKConfig, this.getSslKeystorePasswdProperty(), this.getSslKeystorePasswdPathProperty());
        String string3 = zKConfig.getProperty(this.getSslKeystoreTypeProperty());
        if (string.isEmpty()) {
            throw new X509Exception.SSLContextException("Keystore is required for SSL server: " + this.getSslKeystoreLocationProperty());
        }
        X509KeyManager x509KeyManager = ClientX509Util.createKeyManager(string, string2, string3);
        return this.createNettySslContextForServer(zKConfig, x509KeyManager, this.getTrustManager(zKConfig));
    }

    public SslContext createNettySslContextForServer(ZKConfig zKConfig, KeyManager keyManager, TrustManager trustManager) throws SSLException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer(keyManager);
        if (trustManager != null) {
            sslContextBuilder.trustManager(trustManager);
        }
        sslContextBuilder.enableOcsp(zKConfig.getBoolean(this.getSslOcspEnabledProperty()));
        sslContextBuilder.protocols(this.getEnabledProtocols(zKConfig));
        sslContextBuilder.clientAuth(this.getClientAuth(zKConfig).toNettyClientAuth());
        Iterable<String> iterable = this.getCipherSuites(zKConfig);
        if (iterable != null) {
            sslContextBuilder.ciphers(iterable);
        }
        sslContextBuilder.sslProvider(this.getSslProvider(zKConfig));
        SslContext sslContext = sslContextBuilder.build();
        if (this.getFipsMode(zKConfig) && this.isClientHostnameVerificationEnabled(zKConfig)) {
            return this.addHostnameVerification(sslContext, "Client");
        }
        return sslContext;
    }

    private SslContext addHostnameVerification(SslContext sslContext, final String string) {
        return new DelegatingSslContext(sslContext){

            @Override
            protected void initEngine(SSLEngine sSLEngine) {
                SSLParameters sSLParameters = sSLEngine.getSSLParameters();
                sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
                sSLEngine.setSSLParameters(sSLParameters);
                if (LOG.c()) {
                    LOG.b("{} hostname verification: enabled HTTPS style endpoint identification algorithm", (Object)string);
                }
            }
        };
    }

    private String[] getEnabledProtocols(ZKConfig zKConfig) {
        String string = zKConfig.getProperty(this.getSslEnabledProtocolsProperty());
        if (string == null) {
            return new String[]{zKConfig.getProperty(this.getSslProtocolProperty(), DEFAULT_PROTOCOL)};
        }
        return string.split(",");
    }

    private X509Util.ClientAuth getClientAuth(ZKConfig zKConfig) {
        return X509Util.ClientAuth.fromPropertyValue(zKConfig.getProperty(this.getSslClientAuthProperty()));
    }

    private Iterable<String> getCipherSuites(ZKConfig zKConfig) {
        String string = zKConfig.getProperty(this.getSslCipherSuitesProperty());
        if (string == null) {
            if (this.getSslProvider(zKConfig) != SslProvider.JDK) {
                return null;
            }
            return Arrays.asList(X509Util.getDefaultCipherSuites());
        }
        return Arrays.asList(string.split(","));
    }

    public SslProvider getSslProvider(ZKConfig zKConfig) {
        return SslProvider.valueOf(zKConfig.getProperty(this.getSslProviderProperty(), "JDK"));
    }

    private TrustManager getTrustManager(ZKConfig zKConfig) throws X509Exception.TrustManagerException {
        String string = zKConfig.getProperty(this.getSslTruststoreLocationProperty(), "");
        String string2 = this.getPasswordFromConfigPropertyOrFile(zKConfig, this.getSslTruststorePasswdProperty(), this.getSslTruststorePasswdPathProperty());
        String string3 = zKConfig.getProperty(this.getSslTruststoreTypeProperty());
        boolean bl2 = zKConfig.getBoolean(this.getSslCrlEnabledProperty());
        boolean bl3 = zKConfig.getBoolean(this.getSslOcspEnabledProperty());
        boolean bl4 = this.isServerHostnameVerificationEnabled(zKConfig);
        boolean bl5 = this.isClientHostnameVerificationEnabled(zKConfig);
        if (string.isEmpty()) {
            LOG.d("{} not specified", (Object)this.getSslTruststoreLocationProperty());
            return null;
        }
        return ClientX509Util.createTrustManager(string, string2, string3, bl2, bl3, bl4, bl5, this.getFipsMode(zKConfig));
    }
}

