/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Quotas;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.StatsTrack;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZKUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooDefs;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooKeeper;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SetQuotaCommand
extends CliCommand {
    private static final foe LOG = goe.a(SetQuotaCommand.class);
    private Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetQuotaCommand() {
        super("setquota", "-n|-b|-N|-B val path");
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(new Option("n", true, "num soft quota"));
        optionGroup.addOption(new Option("b", true, "bytes soft quota"));
        optionGroup.addOption(new Option("N", true, "num hard quota"));
        optionGroup.addOption(new Option("B", true, "bytes hard quota"));
        optionGroup.setRequired(true);
        this.options.addOptionGroup(optionGroup);
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        DefaultParser defaultParser = new DefaultParser();
        try {
            this.cl = defaultParser.parse(this.options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        boolean bl2;
        String string = this.args[1];
        if (string.startsWith("/zookeeper/quota")) {
            this.err.println("cannot set a quota under the path: /zookeeper/quota");
            return false;
        }
        StatsTrack statsTrack = new StatsTrack();
        statsTrack.setCount(-1L);
        statsTrack.setBytes(-1L);
        statsTrack.setCountHardLimit(-1L);
        statsTrack.setByteHardLimit(-1L);
        if (!this.checkOptionValue(statsTrack)) {
            return false;
        }
        boolean bl3 = bl2 = this.cl.hasOption("n") || this.cl.hasOption("N") || this.cl.hasOption("b") || this.cl.hasOption("B");
        if (bl2) {
            try {
                SetQuotaCommand.createQuota(this.zk, string, statsTrack);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedPathException(illegalArgumentException.getMessage());
            }
            catch (KeeperException | InterruptedException exception) {
                throw new CliWrapperException(exception);
            }
        } else {
            this.err.println(this.getUsageStr());
        }
        return false;
    }

    private boolean checkOptionValue(StatsTrack statsTrack) {
        block12: {
            try {
                int n2;
                if (this.cl.hasOption("n")) {
                    n2 = Integer.parseInt(this.cl.getOptionValue("n"));
                    if (n2 > 0) {
                        statsTrack.setCount(n2);
                    } else {
                        this.err.println("the num quota must be greater than zero");
                        return false;
                    }
                }
                if (this.cl.hasOption("b")) {
                    long l2 = Long.parseLong(this.cl.getOptionValue("b"));
                    if (l2 >= 0L) {
                        statsTrack.setBytes(l2);
                    } else {
                        this.err.println("the bytes quota must be greater than or equal to zero");
                        return false;
                    }
                }
                if (this.cl.hasOption("N")) {
                    n2 = Integer.parseInt(this.cl.getOptionValue("N"));
                    if (n2 > 0) {
                        statsTrack.setCountHardLimit(n2);
                    } else {
                        this.err.println("the num quota must be greater than zero");
                        return false;
                    }
                }
                if (!this.cl.hasOption("B")) break block12;
                long l3 = Long.parseLong(this.cl.getOptionValue("B"));
                if (l3 >= 0L) {
                    statsTrack.setByteHardLimit(l3);
                    break block12;
                }
                this.err.println("the bytes quota must be greater than or equal to zero");
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                this.err.println("NumberFormatException happens when parsing the option value");
                return false;
            }
        }
        return true;
    }

    public static boolean createQuota(ZooKeeper zooKeeper, String string, StatsTrack statsTrack) throws KeeperException, InterruptedException, MalformedPathException {
        Stat stat;
        try {
            stat = zooKeeper.exists(string, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        if (stat == null) {
            throw new IllegalArgumentException(string + " does not exist.");
        }
        String string2 = "/zookeeper/quota";
        SetQuotaCommand.checkIfChildQuota(zooKeeper, string);
        SetQuotaCommand.checkIfParentQuota(zooKeeper, string);
        if (zooKeeper.exists(string2, false) == null) {
            try {
                zooKeeper.create("/zookeeper", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zooKeeper.create("/zookeeper/quota", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        String[] stringArray = string.split("/");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            stringBuilder.append("/").append(stringArray[i2]);
            string2 = stringBuilder.toString();
            if (zooKeeper.exists(string2, false) != null) continue;
            try {
                zooKeeper.create(string2, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                continue;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        String string3 = string2 + "/" + "zookeeper_stats";
        if (zooKeeper.exists(string2 = string2 + "/" + "zookeeper_limits", false) == null) {
            zooKeeper.create(string2, statsTrack.getStatsBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            StatsTrack statsTrack2 = new StatsTrack();
            statsTrack2.setCount(0L);
            statsTrack2.setBytes(0L);
            zooKeeper.create(string3, statsTrack2.getStatsBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            byte[] byArray = zooKeeper.getData(string2, false, new Stat());
            StatsTrack statsTrack3 = new StatsTrack(byArray);
            byArray = zooKeeper.getData(string3, false, new Stat());
            StatsTrack statsTrack4 = new StatsTrack(byArray);
            SetQuotaCommand.checkQuota(statsTrack3, statsTrack4);
        } else {
            byte[] byArray = zooKeeper.getData(string2, false, new Stat());
            StatsTrack statsTrack5 = new StatsTrack(byArray);
            if (statsTrack.getCount() > -1L) {
                statsTrack5.setCount(statsTrack.getCount());
            }
            if (statsTrack.getBytes() > -1L) {
                statsTrack5.setBytes(statsTrack.getBytes());
            }
            if (statsTrack.getCountHardLimit() > -1L) {
                statsTrack5.setCountHardLimit(statsTrack.getCountHardLimit());
            }
            if (statsTrack.getByteHardLimit() > -1L) {
                statsTrack5.setByteHardLimit(statsTrack.getByteHardLimit());
            }
            byArray = zooKeeper.getData(string3, false, new Stat());
            StatsTrack statsTrack6 = new StatsTrack(byArray);
            SetQuotaCommand.checkQuota(statsTrack5, statsTrack6);
            zooKeeper.setData(string2, statsTrack5.getStatsBytes(), -1);
        }
        return true;
    }

    private static void checkQuota(StatsTrack statsTrack, StatsTrack statsTrack2) {
        if (statsTrack.getCount() > -1L && statsTrack.getCount() < statsTrack2.getCount() || statsTrack.getCountHardLimit() > -1L && statsTrack.getCountHardLimit() < statsTrack2.getCount()) {
            System.out.println("[Warning]: the count quota you create is less than the existing count:" + statsTrack2.getCount());
        }
        if (statsTrack.getBytes() > -1L && statsTrack.getBytes() < statsTrack2.getBytes() || statsTrack.getByteHardLimit() > -1L && statsTrack.getByteHardLimit() < statsTrack2.getBytes()) {
            System.out.println("[Warning]: the bytes quota you create is less than the existing bytes:" + statsTrack2.getBytes());
        }
    }

    private static void checkIfChildQuota(ZooKeeper zooKeeper, String string) throws KeeperException, InterruptedException {
        String string4 = Quotas.quotaPath(string);
        try {
            ZKUtil.visitSubTreeDFS(zooKeeper, string4, false, (n2, string2, object, string3) -> {
                List<Object> list = new ArrayList();
                try {
                    list = zooKeeper.getChildren(string2, false);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    LOG.a("child removed during quota check", noNodeException);
                    return;
                }
                catch (KeeperException | InterruptedException exception) {
                    exception.printStackTrace();
                }
                if (list.size() == 0) {
                    return;
                }
                for (String string4 : list) {
                    if (string2.equals("/zookeeper/quota" + string) || !"zookeeper_limits".equals(string4)) continue;
                    throw new IllegalArgumentException(string + " has a child " + Quotas.trimQuotaPath(string2) + " which has a quota");
                }
            });
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    private static void checkIfParentQuota(ZooKeeper zooKeeper, String string) throws InterruptedException, KeeperException {
        String[] stringArray = string.split("/");
        String string2 = "/zookeeper/quota";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        for (int i2 = 1; i2 < stringArray.length - 1; ++i2) {
            stringBuilder.append("/");
            stringBuilder.append(stringArray[i2]);
            string2 = stringBuilder.toString();
            List<String> list = null;
            try {
                list = zooKeeper.getChildren(string2, false);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                LOG.a("child removed during quota check", noNodeException);
                return;
            }
            if (list.size() == 0) {
                return;
            }
            for (String string3 : list) {
                if (string2.equals(Quotas.quotaPath(string)) || !"zookeeper_limits".equals(string3)) continue;
                throw new IllegalArgumentException(string + " has a parent " + Quotas.trimQuotaPath(string2) + " which has a quota");
            }
        }
    }
}

