/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZKUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedCommandException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.StatPrinter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class LsCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public LsCommand() {
        super("ls", "[-s] [-w] [-R] path");
    }

    private void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("ls [options] path", options);
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        DefaultParser defaultParser = new DefaultParser();
        try {
            this.cl = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = this.cl.getArgs();
        if (this.cl.hasOption("?")) {
            this.printHelp();
        }
        this.retainCompatibility(stringArray);
        return this;
    }

    private void retainCompatibility(String[] stringArray) throws CliParseException {
        if (this.args.length > 2) {
            stringArray[2] = "-w";
            this.err.println("'ls path [watch]' has been deprecated. Please use 'ls [-w] path' instead.");
            DefaultParser defaultParser = new DefaultParser();
            try {
                this.cl = defaultParser.parse(options, stringArray);
            }
            catch (ParseException parseException) {
                throw new CliParseException(parseException);
            }
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws CliException {
        if (this.args.length < 2) {
            throw new MalformedCommandException(this.getUsageStr());
        }
        String string3 = this.args[1];
        boolean bl2 = this.cl.hasOption("w");
        boolean bl3 = this.cl.hasOption("s");
        boolean bl4 = this.cl.hasOption("R");
        try {
            if (bl4) {
                ZKUtil.visitSubTreeDFS(this.zk, string3, bl2, (n2, string, object, string2) -> this.out.println(string));
            } else {
                Stat stat = bl3 ? new Stat() : null;
                List<String> list = this.zk.getChildren(string3, bl2, stat);
                this.printChildren(list, stat);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException | InterruptedException exception) {
            throw new CliWrapperException(exception);
        }
        return bl2;
    }

    private void printChildren(List<String> list, Stat stat) {
        Collections.sort(list);
        this.out.append("[");
        boolean bl2 = true;
        for (String string : list) {
            if (!bl2) {
                this.out.append(", ");
            } else {
                bl2 = false;
            }
            this.out.append(string);
        }
        this.out.append("]\n");
        if (stat != null) {
            new StatPrinter(this.out).print(stat);
        }
    }

    static {
        options.addOption("?", false, "help");
        options.addOption("s", false, "stat");
        options.addOption("w", false, "watch");
        options.addOption("R", false, "recurse");
    }
}

