/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZKUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedCommandException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class DeleteAllCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public DeleteAllCommand() {
        this("deleteall");
    }

    public DeleteAllCommand(String string) {
        super(string, "path [-b batch size]");
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        DefaultParser defaultParser = new DefaultParser();
        try {
            this.cl = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        int n2;
        try {
            n2 = this.cl.hasOption("b") ? Integer.parseInt(this.cl.getOptionValue("b")) : 1000;
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCommandException("-b argument must be an int value");
        }
        String string = this.args[1];
        try {
            boolean bl2 = ZKUtil.deleteRecursive(this.zk, string, n2);
            if (!bl2) {
                this.err.println("Failed to delete some node(s) in the subtree!");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException | InterruptedException exception) {
            throw new CliWrapperException(exception);
        }
        return false;
    }

    static {
        options.addOption(new Option("b", true, "batch size"));
    }
}

