/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Quotas;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.StatsTrack;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooKeeper;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class DelQuotaCommand
extends CliCommand {
    private Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public DelQuotaCommand() {
        super("delquota", "[-n|-b|-N|-B] path");
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(new Option("n", false, "num soft quota"));
        optionGroup.addOption(new Option("b", false, "bytes soft quota"));
        optionGroup.addOption(new Option("N", false, "num hard quota"));
        optionGroup.addOption(new Option("B", false, "bytes hard quota"));
        this.options.addOptionGroup(optionGroup);
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        DefaultParser defaultParser = new DefaultParser();
        try {
            this.cl = defaultParser.parse(this.options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String string = this.args[1];
        StatsTrack statsTrack = new StatsTrack();
        if (this.cl.hasOption("n")) {
            statsTrack.setCount(1L);
        }
        if (this.cl.hasOption("b")) {
            statsTrack.setBytes(1L);
        }
        if (this.cl.hasOption("N")) {
            statsTrack.setCountHardLimit(1L);
        }
        if (this.cl.hasOption("B")) {
            statsTrack.setByteHardLimit(1L);
        }
        boolean bl2 = this.cl.hasOption("n") || this.cl.hasOption("N") || this.cl.hasOption("b") || this.cl.hasOption("B");
        try {
            DelQuotaCommand.delQuota(this.zk, string, bl2 ? statsTrack : null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException.NoNodeException noNodeException) {
            this.err.println("quota for " + string + " does not exist.");
        }
        catch (KeeperException | InterruptedException exception) {
            throw new CliWrapperException(exception);
        }
        return false;
    }

    public static boolean delQuota(ZooKeeper zooKeeper, String string, StatsTrack statsTrack) throws KeeperException, InterruptedException, MalformedPathException {
        String string2 = Quotas.quotaPath(string);
        String string3 = Quotas.limitPath(string);
        if (zooKeeper.exists(string3, false) == null) {
            System.out.println("Quota does not exist for " + string);
            return true;
        }
        byte[] byArray = null;
        try {
            byArray = zooKeeper.getData(string3, false, new Stat());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException.NoNodeException noNodeException) {
            throw new KeeperException.NoNodeException(noNodeException.getMessage());
        }
        StatsTrack statsTrack2 = new StatsTrack(byArray);
        if (statsTrack == null) {
            List<String> list = zooKeeper.getChildren(string2, false);
            for (String string4 : list) {
                zooKeeper.delete(string2 + "/" + string4, -1);
            }
            DelQuotaCommand.trimProcQuotas(zooKeeper, string2);
        } else {
            if (statsTrack.getCount() > 0L) {
                statsTrack2.setCount(-1L);
            }
            if (statsTrack.getBytes() > 0L) {
                statsTrack2.setBytes(-1L);
            }
            if (statsTrack.getCountHardLimit() > 0L) {
                statsTrack2.setCountHardLimit(-1L);
            }
            if (statsTrack.getByteHardLimit() > 0L) {
                statsTrack2.setByteHardLimit(-1L);
            }
            zooKeeper.setData(string3, statsTrack2.getStatsBytes(), -1);
        }
        return true;
    }

    private static boolean trimProcQuotas(ZooKeeper zooKeeper, String string) throws KeeperException, InterruptedException {
        if ("/zookeeper/quota".equals(string)) {
            return true;
        }
        List<String> list = zooKeeper.getChildren(string, false);
        if (list.size() == 0) {
            zooKeeper.delete(string, -1);
            String string2 = string.substring(0, string.lastIndexOf(47));
            return DelQuotaCommand.trimProcQuotas(zooKeeper, string2);
        }
        return true;
    }
}

