/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooDefs;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.AclParser;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedCommandException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.EphemeralType;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CreateCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public CreateCommand() {
        super("create", "[-s] [-e] [-c] [-t ttl] path [data] [acl]");
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        DefaultParser defaultParser = new DefaultParser();
        try {
            this.cl = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        CreateMode createMode;
        long l2;
        boolean bl2 = this.cl.hasOption("e");
        boolean bl3 = this.cl.hasOption("s");
        boolean bl4 = this.cl.hasOption("c");
        boolean bl5 = this.cl.hasOption("t");
        if (bl4 && (bl2 || bl3)) {
            throw new MalformedCommandException("-c cannot be combined with -s or -e. Containers cannot be ephemeral or sequential.");
        }
        try {
            l2 = bl5 ? Long.parseLong(this.cl.getOptionValue("t")) : 0L;
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCommandException("-t argument must be a long value");
        }
        if (bl5 && bl2) {
            throw new MalformedCommandException("TTLs cannot be used with Ephemeral znodes");
        }
        if (bl5 && bl4) {
            throw new MalformedCommandException("TTLs cannot be used with Container znodes");
        }
        if (bl2 && bl3) {
            createMode = CreateMode.EPHEMERAL_SEQUENTIAL;
        } else if (bl2) {
            createMode = CreateMode.EPHEMERAL;
        } else if (bl3) {
            createMode = bl5 ? CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL : CreateMode.PERSISTENT_SEQUENTIAL;
        } else if (bl4) {
            createMode = CreateMode.CONTAINER;
        } else {
            CreateMode createMode2 = createMode = bl5 ? CreateMode.PERSISTENT_WITH_TTL : CreateMode.PERSISTENT;
        }
        if (bl5) {
            try {
                EphemeralType.TTL.toEphemeralOwner(l2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedCommandException(illegalArgumentException.getMessage());
            }
        }
        String string = this.args[1];
        byte[] byArray = null;
        if (this.args.length > 2) {
            byArray = this.args[2].getBytes(StandardCharsets.UTF_8);
        }
        List<ACL> list = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        if (this.args.length > 3) {
            list = AclParser.parse(this.args[3]);
        }
        try {
            String string2 = bl5 ? this.zk.create(string, byArray, list, createMode, new Stat(), l2) : this.zk.create(string, byArray, list, createMode);
            this.err.println("Created " + string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException.EphemeralOnLocalSessionException ephemeralOnLocalSessionException) {
            this.err.println("Unable to create ephemeral node on a local session");
            throw new CliWrapperException(ephemeralOnLocalSessionException);
        }
        catch (KeeperException.InvalidACLException invalidACLException) {
            this.err.println(invalidACLException.getMessage());
            throw new CliWrapperException(invalidACLException);
        }
        catch (KeeperException | InterruptedException exception) {
            throw new CliWrapperException(exception);
        }
        return true;
    }

    static {
        options.addOption(new Option("e", false, "ephemeral"));
        options.addOption(new Option("s", false, "sequential"));
        options.addOption(new Option("c", false, "container"));
        options.addOption(new Option("t", true, "ttl"));
    }
}

