/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.AddWatchMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.AsyncCallback;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ClientCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ClientCnxnSocket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ClientCnxnSocketNIO;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ClientCnxnSocketNetty;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Environment;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.MultiOperationRecord;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.MultiResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Op;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.OpResult;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Testable;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Transaction;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.WatchDeregistration;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZKWatchManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooKeeperTestable;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.ConnectStringParser;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.HostProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.StaticHostProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.ZKClientConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.ZooKeeperSaslClient;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.PathUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ClientInfo;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.AddWatchRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CheckWatchesRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.Create2Response;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateTTLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.DeleteRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ErrorResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ExistsRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetACLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetACLResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetAllChildrenNumberRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetAllChildrenNumberResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildren2Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildren2Response;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildrenRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildrenResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetDataRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetDataResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetEphemeralsRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetEphemeralsResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.RemoveWatchesRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ReplyHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.RequestHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetACLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetACLResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetDataRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetDataResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SyncRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SyncResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.WhoAmIResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.EphemeralType;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ZooKeeper
implements AutoCloseable {
    public static final String ZOOKEEPER_CLIENT_CNXN_SOCKET = "zookeeper.clientCnxnSocket";
    public static final String SECURE_CLIENT = "zookeeper.client.secure";
    public final ClientCnxn cnxn;
    private static final foe LOG = goe.a(ZooKeeper.class);
    protected final HostProvider hostProvider;
    private final ZKClientConfig clientConfig;

    public void updateServerList(String string) throws IOException {
        ClientCnxnSocket clientCnxnSocket;
        InetSocketAddress inetSocketAddress;
        ConnectStringParser connectStringParser = new ConnectStringParser(string);
        ArrayList<InetSocketAddress> arrayList = connectStringParser.getServerAddresses();
        boolean bl2 = this.hostProvider.updateServerList(arrayList, inetSocketAddress = (InetSocketAddress)(clientCnxnSocket = this.cnxn.sendThread.getClientCnxnSocket()).getRemoteSocketAddress());
        if (bl2) {
            clientCnxnSocket.testableCloseSocket();
        }
    }

    public ZooKeeperSaslClient getSaslClient() {
        return this.cnxn.getZooKeeperSaslClient();
    }

    public ZKClientConfig getClientConfig() {
        return this.clientConfig;
    }

    protected List<String> getDataWatches() {
        return this.getWatchManager().getDataWatchList();
    }

    protected List<String> getExistWatches() {
        return this.getWatchManager().getExistWatchList();
    }

    protected List<String> getChildWatches() {
        return this.getWatchManager().getChildWatchList();
    }

    protected List<String> getPersistentWatches() {
        return this.getWatchManager().getPersistentWatchList();
    }

    protected List<String> getPersistentRecursiveWatches() {
        return this.getWatchManager().getPersistentRecursiveWatchList();
    }

    ZKWatchManager getWatchManager() {
        return this.cnxn.getWatcherManager();
    }

    public ZooKeeper(String string, int n2, Watcher watcher) throws IOException {
        this(string, n2, watcher, false);
    }

    public ZooKeeper(String string, int n2, Watcher watcher, ZKClientConfig zKClientConfig) throws IOException {
        this(string, n2, watcher, false, zKClientConfig);
    }

    public ZooKeeper(String string, int n2, Watcher watcher, boolean bl2, HostProvider hostProvider) throws IOException {
        this(string, n2, watcher, bl2, hostProvider, null);
    }

    public ZooKeeper(String string, int n2, Watcher watcher, boolean bl2, HostProvider hostProvider, ZKClientConfig zKClientConfig) throws IOException {
        LOG.c("Initiating client connection, connectString={} sessionTimeout={} watcher={}", string, n2, watcher);
        this.clientConfig = zKClientConfig != null ? zKClientConfig : new ZKClientConfig();
        this.hostProvider = hostProvider;
        ConnectStringParser connectStringParser = new ConnectStringParser(string);
        this.cnxn = this.createConnection(connectStringParser.getChrootPath(), hostProvider, n2, this.clientConfig, watcher, this.getClientCnxnSocket(), bl2);
        this.cnxn.start();
    }

    ClientCnxn createConnection(String string, HostProvider hostProvider, int n2, ZKClientConfig zKClientConfig, Watcher watcher, ClientCnxnSocket clientCnxnSocket, boolean bl2) throws IOException {
        return new ClientCnxn(string, hostProvider, n2, zKClientConfig, watcher, clientCnxnSocket, bl2);
    }

    public ZooKeeper(String string, int n2, Watcher watcher, boolean bl2) throws IOException {
        this(string, n2, watcher, bl2, ZooKeeper.createDefaultHostProvider(string));
    }

    public ZooKeeper(String string, int n2, Watcher watcher, boolean bl2, ZKClientConfig zKClientConfig) throws IOException {
        this(string, n2, watcher, bl2, ZooKeeper.createDefaultHostProvider(string), zKClientConfig);
    }

    public ZooKeeper(String string, int n2, Watcher watcher, long l2, byte[] byArray) throws IOException {
        this(string, n2, watcher, l2, byArray, false);
    }

    public ZooKeeper(String string, int n2, Watcher watcher, long l2, byte[] byArray, boolean bl2, HostProvider hostProvider) throws IOException {
        this(string, n2, watcher, l2, byArray, bl2, hostProvider, null);
    }

    public ZooKeeper(String string, int n2, Watcher watcher, long l2, byte[] byArray, boolean bl2, HostProvider hostProvider, ZKClientConfig zKClientConfig) throws IOException {
        LOG.c("Initiating client connection, connectString={} sessionTimeout={} watcher={} sessionId=0x{} sessionPasswd={}", string, n2, watcher, Long.toHexString(l2), byArray == null ? "<null>" : "<hidden>");
        this.clientConfig = zKClientConfig != null ? zKClientConfig : new ZKClientConfig();
        ConnectStringParser connectStringParser = new ConnectStringParser(string);
        this.hostProvider = hostProvider;
        this.cnxn = new ClientCnxn(connectStringParser.getChrootPath(), hostProvider, n2, this.clientConfig, watcher, this.getClientCnxnSocket(), l2, byArray, bl2);
        this.cnxn.seenRwServerBefore = true;
        this.cnxn.start();
    }

    public ZooKeeper(String string, int n2, Watcher watcher, long l2, byte[] byArray, boolean bl2) throws IOException {
        this(string, n2, watcher, l2, byArray, bl2, ZooKeeper.createDefaultHostProvider(string));
    }

    private static HostProvider createDefaultHostProvider(String string) {
        return new StaticHostProvider(new ConnectStringParser(string).getServerAddresses());
    }

    public Testable getTestable() {
        return new ZooKeeperTestable(this.cnxn);
    }

    public long getSessionId() {
        return this.cnxn.getSessionId();
    }

    public byte[] getSessionPasswd() {
        return this.cnxn.getSessionPasswd();
    }

    public int getSessionTimeout() {
        return this.cnxn.getSessionTimeout();
    }

    public void addAuthInfo(String string, byte[] byArray) {
        this.cnxn.addAuthInfo(string, byArray);
    }

    public synchronized void register(Watcher watcher) {
        this.getWatchManager().setDefaultWatcher(watcher);
    }

    @Override
    public synchronized void close() throws InterruptedException {
        if (!this.cnxn.getState().isAlive()) {
            LOG.b("Close called on already closed client");
            return;
        }
        LOG.b("Closing session: 0x" + Long.toHexString(this.getSessionId()));
        try {
            this.cnxn.close();
        }
        catch (IOException iOException) {
            LOG.a("Ignoring unexpected exception during close", iOException);
        }
        LOG.c("Session: 0x{} closed", (Object)Long.toHexString(this.getSessionId()));
    }

    public boolean close(int n2) throws InterruptedException {
        this.close();
        return this.testableWaitForShutdown(n2);
    }

    private String prependChroot(String string) {
        if (this.cnxn.chrootPath != null) {
            if (string.length() == 1) {
                return this.cnxn.chrootPath;
            }
            return this.cnxn.chrootPath + string;
        }
        return string;
    }

    public String create(String string, byte[] byArray, List<ACL> list, CreateMode createMode) throws KeeperException, InterruptedException {
        String string2 = string;
        PathUtils.validatePath(string2, createMode.isSequential());
        EphemeralType.validateTTL(createMode, -1L);
        this.validateACL(list);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(createMode.isContainer() ? 19 : 1);
        CreateRequest createRequest = new CreateRequest();
        CreateResponse createResponse = new CreateResponse();
        createRequest.setData(byArray);
        createRequest.setFlags(createMode.toFlag());
        createRequest.setPath(string3);
        createRequest.setAcl(list);
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, createRequest, createResponse, null);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
        if (this.cnxn.chrootPath == null) {
            return createResponse.getPath();
        }
        return createResponse.getPath().substring(this.cnxn.chrootPath.length());
    }

    public String create(String string, byte[] byArray, List<ACL> list, CreateMode createMode, Stat stat) throws KeeperException, InterruptedException {
        return this.create(string, byArray, list, createMode, stat, -1L);
    }

    public String create(String string, byte[] byArray, List<ACL> list, CreateMode createMode, Stat stat, long l2) throws KeeperException, InterruptedException {
        String string2 = string;
        PathUtils.validatePath(string2, createMode.isSequential());
        EphemeralType.validateTTL(createMode, l2);
        this.validateACL(list);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        this.setCreateHeader(createMode, requestHeader);
        Create2Response create2Response = new Create2Response();
        mme mme2 = this.makeCreateRecord(createMode, string3, byArray, list, l2);
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, mme2, create2Response, null);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
        if (stat != null) {
            DataTree.copyStat(create2Response.getStat(), stat);
        }
        if (this.cnxn.chrootPath == null) {
            return create2Response.getPath();
        }
        return create2Response.getPath().substring(this.cnxn.chrootPath.length());
    }

    private void setCreateHeader(CreateMode createMode, RequestHeader requestHeader) {
        if (createMode.isTTL()) {
            requestHeader.setType(21);
        } else {
            requestHeader.setType(createMode.isContainer() ? 19 : 15);
        }
    }

    private mme makeCreateRecord(CreateMode createMode, String string, byte[] byArray, List<ACL> list, long l2) {
        mme mme2;
        if (createMode.isTTL()) {
            CreateTTLRequest createTTLRequest = new CreateTTLRequest();
            createTTLRequest.setData(byArray);
            createTTLRequest.setFlags(createMode.toFlag());
            createTTLRequest.setPath(string);
            createTTLRequest.setAcl(list);
            createTTLRequest.setTtl(l2);
            mme2 = createTTLRequest;
        } else {
            CreateRequest createRequest = new CreateRequest();
            createRequest.setData(byArray);
            createRequest.setFlags(createMode.toFlag());
            createRequest.setPath(string);
            createRequest.setAcl(list);
            mme2 = createRequest;
        }
        return mme2;
    }

    public void create(String string, byte[] byArray, List<ACL> list, CreateMode createMode, AsyncCallback.StringCallback stringCallback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2, createMode.isSequential());
        EphemeralType.validateTTL(createMode, -1L);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(createMode.isContainer() ? 19 : 1);
        CreateRequest createRequest = new CreateRequest();
        CreateResponse createResponse = new CreateResponse();
        ReplyHeader replyHeader = new ReplyHeader();
        createRequest.setData(byArray);
        createRequest.setFlags(createMode.toFlag());
        createRequest.setPath(string3);
        createRequest.setAcl(list);
        this.cnxn.queuePacket(requestHeader, replyHeader, createRequest, createResponse, stringCallback, string2, string3, object, null);
    }

    public void create(String string, byte[] byArray, List<ACL> list, CreateMode createMode, AsyncCallback.Create2Callback create2Callback, Object object) {
        this.create(string, byArray, list, createMode, create2Callback, object, -1L);
    }

    public void create(String string, byte[] byArray, List<ACL> list, CreateMode createMode, AsyncCallback.Create2Callback create2Callback, Object object, long l2) {
        String string2 = string;
        PathUtils.validatePath(string2, createMode.isSequential());
        EphemeralType.validateTTL(createMode, l2);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        this.setCreateHeader(createMode, requestHeader);
        ReplyHeader replyHeader = new ReplyHeader();
        Create2Response create2Response = new Create2Response();
        mme mme2 = this.makeCreateRecord(createMode, string3, byArray, list, l2);
        this.cnxn.queuePacket(requestHeader, replyHeader, mme2, create2Response, create2Callback, string2, string3, object, null);
    }

    public void delete(String string, int n2) throws InterruptedException, KeeperException {
        String string2 = string;
        PathUtils.validatePath(string2);
        String string3 = string2.equals("/") ? string2 : this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(2);
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.setPath(string3);
        deleteRequest.setVersion(n2);
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, deleteRequest, null, null);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
    }

    public List<OpResult> multi(Iterable<Op> iterable) throws InterruptedException, KeeperException {
        for (Op op2 : iterable) {
            op2.validate();
        }
        return this.multiInternal(this.generateMultiTransaction(iterable));
    }

    public void multi(Iterable<Op> iterable, AsyncCallback.MultiCallback multiCallback, Object object) {
        List<OpResult> list = this.validatePath(iterable);
        if (list.size() > 0) {
            multiCallback.processResult(KeeperException.Code.BADARGUMENTS.intValue(), null, object, list);
            return;
        }
        this.multiInternal(this.generateMultiTransaction(iterable), multiCallback, object);
    }

    private List<OpResult> validatePath(Iterable<Op> iterable) {
        ArrayList<OpResult> arrayList = new ArrayList<OpResult>();
        boolean bl2 = false;
        for (Op op2 : iterable) {
            OpResult.ErrorResult errorResult;
            try {
                op2.validate();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.d("Unexpected exception", illegalArgumentException);
                errorResult = new OpResult.ErrorResult(KeeperException.Code.BADARGUMENTS.intValue());
                arrayList.add(errorResult);
                bl2 = true;
                continue;
            }
            catch (KeeperException keeperException) {
                LOG.d("Unexpected exception", keeperException);
                errorResult = new OpResult.ErrorResult(keeperException.code().intValue());
                arrayList.add(errorResult);
                bl2 = true;
                continue;
            }
            OpResult.ErrorResult errorResult2 = new OpResult.ErrorResult(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
            arrayList.add(errorResult2);
        }
        if (!bl2) {
            arrayList.clear();
        }
        return arrayList;
    }

    private MultiOperationRecord generateMultiTransaction(Iterable<Op> iterable) {
        ArrayList<Op> arrayList = new ArrayList<Op>();
        for (Op op2 : iterable) {
            arrayList.add(this.withRootPrefix(op2));
        }
        return new MultiOperationRecord(arrayList);
    }

    private Op withRootPrefix(Op op2) {
        if (null != op2.getPath()) {
            String string = this.prependChroot(op2.getPath());
            if (!op2.getPath().equals(string)) {
                return op2.withChroot(string);
            }
        }
        return op2;
    }

    protected void multiInternal(MultiOperationRecord multiOperationRecord, AsyncCallback.MultiCallback multiCallback, Object object) throws IllegalArgumentException {
        if (multiOperationRecord.size() == 0) {
            this.cnxn.queueCallback(multiCallback, KeeperException.Code.OK.intValue(), null, object);
            return;
        }
        RequestHeader requestHeader = new RequestHeader();
        switch (multiOperationRecord.getOpKind()) {
            case TRANSACTION: {
                requestHeader.setType(14);
                break;
            }
            case READ: {
                requestHeader.setType(22);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported OpKind: " + (Object)((Object)multiOperationRecord.getOpKind()));
            }
        }
        MultiResponse multiResponse = new MultiResponse();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), multiOperationRecord, multiResponse, multiCallback, null, null, object, null);
    }

    protected List<OpResult> multiInternal(MultiOperationRecord multiOperationRecord) throws InterruptedException, KeeperException, IllegalArgumentException {
        RequestHeader requestHeader = new RequestHeader();
        if (multiOperationRecord.size() == 0) {
            return Collections.emptyList();
        }
        switch (multiOperationRecord.getOpKind()) {
            case TRANSACTION: {
                requestHeader.setType(14);
                break;
            }
            case READ: {
                requestHeader.setType(22);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported OpKind: " + (Object)((Object)multiOperationRecord.getOpKind()));
            }
        }
        MultiResponse multiResponse = new MultiResponse();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, multiOperationRecord, multiResponse, null);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()));
        }
        List<OpResult> list = multiResponse.getResultList();
        if (multiOperationRecord.getOpKind() == Op.OpKind.READ) {
            return list;
        }
        OpResult.ErrorResult errorResult = null;
        for (OpResult opResult : list) {
            if (!(opResult instanceof OpResult.ErrorResult) || ((OpResult.ErrorResult)opResult).getErr() == KeeperException.Code.OK.intValue()) continue;
            errorResult = (OpResult.ErrorResult)opResult;
            break;
        }
        if (errorResult != null) {
            KeeperException keeperException = KeeperException.create(KeeperException.Code.get(errorResult.getErr()));
            keeperException.setMultiResults(list);
            throw keeperException;
        }
        return list;
    }

    public Transaction transaction() {
        return new Transaction(this);
    }

    public void delete(String string, int n2, AsyncCallback.VoidCallback voidCallback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2);
        String string3 = string2.equals("/") ? string2 : this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(2);
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.setPath(string3);
        deleteRequest.setVersion(n2);
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), deleteRequest, null, voidCallback, string2, string3, object, null);
    }

    public Stat exists(String string, Watcher watcher) throws KeeperException, InterruptedException {
        String string2 = string;
        PathUtils.validatePath(string2);
        ExistsWatchRegistration existsWatchRegistration = null;
        if (watcher != null) {
            existsWatchRegistration = new ExistsWatchRegistration(watcher, string2);
        }
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(3);
        ExistsRequest existsRequest = new ExistsRequest();
        existsRequest.setPath(string3);
        existsRequest.setWatch(watcher != null);
        SetDataResponse setDataResponse = new SetDataResponse();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, existsRequest, setDataResponse, existsWatchRegistration);
        if (replyHeader.getErr() != 0) {
            if (replyHeader.getErr() == KeeperException.Code.NONODE.intValue()) {
                return null;
            }
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
        return setDataResponse.getStat().getCzxid() == -1L ? null : setDataResponse.getStat();
    }

    public Stat exists(String string, boolean bl2) throws KeeperException, InterruptedException {
        return this.exists(string, this.getDefaultWatcher(bl2));
    }

    public void exists(String string, Watcher watcher, AsyncCallback.StatCallback statCallback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2);
        ExistsWatchRegistration existsWatchRegistration = null;
        if (watcher != null) {
            existsWatchRegistration = new ExistsWatchRegistration(watcher, string2);
        }
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(3);
        ExistsRequest existsRequest = new ExistsRequest();
        existsRequest.setPath(string3);
        existsRequest.setWatch(watcher != null);
        SetDataResponse setDataResponse = new SetDataResponse();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), existsRequest, setDataResponse, statCallback, string2, string3, object, existsWatchRegistration);
    }

    public void exists(String string, boolean bl2, AsyncCallback.StatCallback statCallback, Object object) {
        this.exists(string, this.getDefaultWatcher(bl2), statCallback, object);
    }

    public byte[] getData(String string, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        String string2 = string;
        PathUtils.validatePath(string2);
        DataWatchRegistration dataWatchRegistration = null;
        if (watcher != null) {
            dataWatchRegistration = new DataWatchRegistration(watcher, string2);
        }
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(4);
        GetDataRequest getDataRequest = new GetDataRequest();
        getDataRequest.setPath(string3);
        getDataRequest.setWatch(watcher != null);
        GetDataResponse getDataResponse = new GetDataResponse();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, getDataRequest, getDataResponse, dataWatchRegistration);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
        if (stat != null) {
            DataTree.copyStat(getDataResponse.getStat(), stat);
        }
        return getDataResponse.getData();
    }

    public byte[] getData(String string, boolean bl2, Stat stat) throws KeeperException, InterruptedException {
        return this.getData(string, this.getDefaultWatcher(bl2), stat);
    }

    public void getData(String string, Watcher watcher, AsyncCallback.DataCallback dataCallback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2);
        DataWatchRegistration dataWatchRegistration = null;
        if (watcher != null) {
            dataWatchRegistration = new DataWatchRegistration(watcher, string2);
        }
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(4);
        GetDataRequest getDataRequest = new GetDataRequest();
        getDataRequest.setPath(string3);
        getDataRequest.setWatch(watcher != null);
        GetDataResponse getDataResponse = new GetDataResponse();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), getDataRequest, getDataResponse, dataCallback, string2, string3, object, dataWatchRegistration);
    }

    public void getData(String string, boolean bl2, AsyncCallback.DataCallback dataCallback, Object object) {
        this.getData(string, this.getDefaultWatcher(bl2), dataCallback, object);
    }

    public byte[] getConfig(Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        String string = "/zookeeper/config";
        DataWatchRegistration dataWatchRegistration = null;
        if (watcher != null) {
            dataWatchRegistration = new DataWatchRegistration(watcher, "/zookeeper/config");
        }
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(4);
        GetDataRequest getDataRequest = new GetDataRequest();
        getDataRequest.setPath("/zookeeper/config");
        getDataRequest.setWatch(watcher != null);
        GetDataResponse getDataResponse = new GetDataResponse();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, getDataRequest, getDataResponse, dataWatchRegistration);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), "/zookeeper/config");
        }
        if (stat != null) {
            DataTree.copyStat(getDataResponse.getStat(), stat);
        }
        return getDataResponse.getData();
    }

    public void getConfig(Watcher watcher, AsyncCallback.DataCallback dataCallback, Object object) {
        String string = "/zookeeper/config";
        DataWatchRegistration dataWatchRegistration = null;
        if (watcher != null) {
            dataWatchRegistration = new DataWatchRegistration(watcher, "/zookeeper/config");
        }
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(4);
        GetDataRequest getDataRequest = new GetDataRequest();
        getDataRequest.setPath("/zookeeper/config");
        getDataRequest.setWatch(watcher != null);
        GetDataResponse getDataResponse = new GetDataResponse();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), getDataRequest, getDataResponse, dataCallback, "/zookeeper/config", "/zookeeper/config", object, dataWatchRegistration);
    }

    public byte[] getConfig(boolean bl2, Stat stat) throws KeeperException, InterruptedException {
        return this.getConfig(this.getDefaultWatcher(bl2), stat);
    }

    public void getConfig(boolean bl2, AsyncCallback.DataCallback dataCallback, Object object) {
        this.getConfig(this.getDefaultWatcher(bl2), dataCallback, object);
    }

    public Stat setData(String string, byte[] byArray, int n2) throws KeeperException, InterruptedException {
        String string2 = string;
        PathUtils.validatePath(string2);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(5);
        SetDataRequest setDataRequest = new SetDataRequest();
        setDataRequest.setPath(string3);
        setDataRequest.setData(byArray);
        setDataRequest.setVersion(n2);
        SetDataResponse setDataResponse = new SetDataResponse();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, setDataRequest, setDataResponse, null);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
        return setDataResponse.getStat();
    }

    public void setData(String string, byte[] byArray, int n2, AsyncCallback.StatCallback statCallback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(5);
        SetDataRequest setDataRequest = new SetDataRequest();
        setDataRequest.setPath(string3);
        setDataRequest.setData(byArray);
        setDataRequest.setVersion(n2);
        SetDataResponse setDataResponse = new SetDataResponse();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), setDataRequest, setDataResponse, statCallback, string2, string3, object, null);
    }

    public List<ACL> getACL(String string, Stat stat) throws KeeperException, InterruptedException {
        String string2 = string;
        PathUtils.validatePath(string2);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(6);
        GetACLRequest getACLRequest = new GetACLRequest();
        getACLRequest.setPath(string3);
        GetACLResponse getACLResponse = new GetACLResponse();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, getACLRequest, getACLResponse, null);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
        if (stat != null) {
            DataTree.copyStat(getACLResponse.getStat(), stat);
        }
        return getACLResponse.getAcl();
    }

    public void getACL(String string, Stat stat, AsyncCallback.ACLCallback aCLCallback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(6);
        GetACLRequest getACLRequest = new GetACLRequest();
        getACLRequest.setPath(string3);
        GetACLResponse getACLResponse = new GetACLResponse();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), getACLRequest, getACLResponse, aCLCallback, string2, string3, object, null);
    }

    public Stat setACL(String string, List<ACL> list, int n2) throws KeeperException, InterruptedException {
        String string2 = string;
        PathUtils.validatePath(string2);
        this.validateACL(list);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(7);
        SetACLRequest setACLRequest = new SetACLRequest();
        setACLRequest.setPath(string3);
        setACLRequest.setAcl(list);
        setACLRequest.setVersion(n2);
        SetACLResponse setACLResponse = new SetACLResponse();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, setACLRequest, setACLResponse, null);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
        return setACLResponse.getStat();
    }

    public void setACL(String string, List<ACL> list, int n2, AsyncCallback.StatCallback statCallback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(7);
        SetACLRequest setACLRequest = new SetACLRequest();
        setACLRequest.setPath(string3);
        setACLRequest.setAcl(list);
        setACLRequest.setVersion(n2);
        SetACLResponse setACLResponse = new SetACLResponse();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), setACLRequest, setACLResponse, statCallback, string2, string3, object, null);
    }

    public List<String> getChildren(String string, Watcher watcher) throws KeeperException, InterruptedException {
        String string2 = string;
        PathUtils.validatePath(string2);
        ChildWatchRegistration childWatchRegistration = null;
        if (watcher != null) {
            childWatchRegistration = new ChildWatchRegistration(watcher, string2);
        }
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(8);
        GetChildrenRequest getChildrenRequest = new GetChildrenRequest();
        getChildrenRequest.setPath(string3);
        getChildrenRequest.setWatch(watcher != null);
        GetChildrenResponse getChildrenResponse = new GetChildrenResponse();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, getChildrenRequest, getChildrenResponse, childWatchRegistration);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
        return getChildrenResponse.getChildren();
    }

    public List<String> getChildren(String string, boolean bl2) throws KeeperException, InterruptedException {
        return this.getChildren(string, this.getDefaultWatcher(bl2));
    }

    public void getChildren(String string, Watcher watcher, AsyncCallback.ChildrenCallback childrenCallback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2);
        ChildWatchRegistration childWatchRegistration = null;
        if (watcher != null) {
            childWatchRegistration = new ChildWatchRegistration(watcher, string2);
        }
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(8);
        GetChildrenRequest getChildrenRequest = new GetChildrenRequest();
        getChildrenRequest.setPath(string3);
        getChildrenRequest.setWatch(watcher != null);
        GetChildrenResponse getChildrenResponse = new GetChildrenResponse();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), getChildrenRequest, getChildrenResponse, childrenCallback, string2, string3, object, childWatchRegistration);
    }

    public void getChildren(String string, boolean bl2, AsyncCallback.ChildrenCallback childrenCallback, Object object) {
        this.getChildren(string, this.getDefaultWatcher(bl2), childrenCallback, object);
    }

    public List<String> getChildren(String string, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        String string2 = string;
        PathUtils.validatePath(string2);
        ChildWatchRegistration childWatchRegistration = null;
        if (watcher != null) {
            childWatchRegistration = new ChildWatchRegistration(watcher, string2);
        }
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(12);
        GetChildren2Request getChildren2Request = new GetChildren2Request();
        getChildren2Request.setPath(string3);
        getChildren2Request.setWatch(watcher != null);
        GetChildren2Response getChildren2Response = new GetChildren2Response();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, getChildren2Request, getChildren2Response, childWatchRegistration);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
        if (stat != null) {
            DataTree.copyStat(getChildren2Response.getStat(), stat);
        }
        return getChildren2Response.getChildren();
    }

    public List<String> getChildren(String string, boolean bl2, Stat stat) throws KeeperException, InterruptedException {
        return this.getChildren(string, this.getDefaultWatcher(bl2), stat);
    }

    public void getChildren(String string, Watcher watcher, AsyncCallback.Children2Callback children2Callback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2);
        ChildWatchRegistration childWatchRegistration = null;
        if (watcher != null) {
            childWatchRegistration = new ChildWatchRegistration(watcher, string2);
        }
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(12);
        GetChildren2Request getChildren2Request = new GetChildren2Request();
        getChildren2Request.setPath(string3);
        getChildren2Request.setWatch(watcher != null);
        GetChildren2Response getChildren2Response = new GetChildren2Response();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), getChildren2Request, getChildren2Response, children2Callback, string2, string3, object, childWatchRegistration);
    }

    public void getChildren(String string, boolean bl2, AsyncCallback.Children2Callback children2Callback, Object object) {
        this.getChildren(string, this.getDefaultWatcher(bl2), children2Callback, object);
    }

    public int getAllChildrenNumber(String string) throws KeeperException, InterruptedException {
        String string2 = string;
        PathUtils.validatePath(string2);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(104);
        GetAllChildrenNumberRequest getAllChildrenNumberRequest = new GetAllChildrenNumberRequest(string3);
        GetAllChildrenNumberResponse getAllChildrenNumberResponse = new GetAllChildrenNumberResponse();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, getAllChildrenNumberRequest, getAllChildrenNumberResponse, null);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
        return getAllChildrenNumberResponse.getTotalNumber();
    }

    public void getAllChildrenNumber(String string, AsyncCallback.AllChildrenNumberCallback allChildrenNumberCallback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(104);
        GetAllChildrenNumberRequest getAllChildrenNumberRequest = new GetAllChildrenNumberRequest(string3);
        GetAllChildrenNumberResponse getAllChildrenNumberResponse = new GetAllChildrenNumberResponse();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), getAllChildrenNumberRequest, getAllChildrenNumberResponse, allChildrenNumberCallback, string2, string3, object, null);
    }

    public List<String> getEphemerals() throws KeeperException, InterruptedException {
        return this.getEphemerals("/");
    }

    public List<String> getEphemerals(String string) throws KeeperException, InterruptedException {
        PathUtils.validatePath(string);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(103);
        GetEphemeralsRequest getEphemeralsRequest = new GetEphemeralsRequest(string);
        GetEphemeralsResponse getEphemeralsResponse = new GetEphemeralsResponse();
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, getEphemeralsRequest, getEphemeralsResponse, null);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()));
        }
        return getEphemeralsResponse.getEphemerals();
    }

    public void getEphemerals(String string, AsyncCallback.EphemeralsCallback ephemeralsCallback, Object object) {
        PathUtils.validatePath(string);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(103);
        GetEphemeralsRequest getEphemeralsRequest = new GetEphemeralsRequest(string);
        GetEphemeralsResponse getEphemeralsResponse = new GetEphemeralsResponse();
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), getEphemeralsRequest, getEphemeralsResponse, ephemeralsCallback, null, null, object, null);
    }

    public void getEphemerals(AsyncCallback.EphemeralsCallback ephemeralsCallback, Object object) {
        this.getEphemerals("/", ephemeralsCallback, object);
    }

    public void sync(String string, AsyncCallback.VoidCallback voidCallback, Object object) {
        String string2 = string;
        PathUtils.validatePath(string2);
        String string3 = this.prependChroot(string2);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(9);
        SyncRequest syncRequest = new SyncRequest();
        SyncResponse syncResponse = new SyncResponse();
        syncRequest.setPath(string3);
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), syncRequest, syncResponse, voidCallback, string2, string3, object, null);
    }

    public void removeWatches(String string, Watcher watcher, Watcher.WatcherType watcherType, boolean bl2) throws InterruptedException, KeeperException {
        this.validateWatcher(watcher);
        this.removeWatches(17, string, watcher, watcherType, bl2);
    }

    public void removeWatches(String string, Watcher watcher, Watcher.WatcherType watcherType, boolean bl2, AsyncCallback.VoidCallback voidCallback, Object object) {
        this.validateWatcher(watcher);
        this.removeWatches(17, string, watcher, watcherType, bl2, voidCallback, object);
    }

    public void removeAllWatches(String string, Watcher.WatcherType watcherType, boolean bl2) throws InterruptedException, KeeperException {
        this.removeWatches(18, string, null, watcherType, bl2);
    }

    public void removeAllWatches(String string, Watcher.WatcherType watcherType, boolean bl2, AsyncCallback.VoidCallback voidCallback, Object object) {
        this.removeWatches(18, string, null, watcherType, bl2, voidCallback, object);
    }

    public void addWatch(String string, Watcher watcher, AddWatchMode addWatchMode) throws KeeperException, InterruptedException {
        PathUtils.validatePath(string);
        this.validateWatcher(watcher);
        String string2 = this.prependChroot(string);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(106);
        AddWatchRequest addWatchRequest = new AddWatchRequest(string2, addWatchMode.getMode());
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, addWatchRequest, new ErrorResponse(), new AddWatchRegistration(watcher, string, addWatchMode));
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string);
        }
    }

    public void addWatch(String string, AddWatchMode addWatchMode) throws KeeperException, InterruptedException {
        this.addWatch(string, this.getWatchManager().getDefaultWatcher(), addWatchMode);
    }

    public void addWatch(String string, Watcher watcher, AddWatchMode addWatchMode, AsyncCallback.VoidCallback voidCallback, Object object) {
        PathUtils.validatePath(string);
        this.validateWatcher(watcher);
        String string2 = this.prependChroot(string);
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(106);
        AddWatchRequest addWatchRequest = new AddWatchRequest(string2, addWatchMode.getMode());
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), addWatchRequest, new ErrorResponse(), voidCallback, string, string2, object, new AddWatchRegistration(watcher, string, addWatchMode));
    }

    public void addWatch(String string, AddWatchMode addWatchMode, AsyncCallback.VoidCallback voidCallback, Object object) {
        this.addWatch(string, this.getWatchManager().getDefaultWatcher(), addWatchMode, voidCallback, object);
    }

    private void validateWatcher(Watcher watcher) {
        if (watcher == null) {
            throw new IllegalArgumentException("Invalid Watcher, shouldn't be null!");
        }
    }

    private void removeWatches(int n2, String string, Watcher watcher, Watcher.WatcherType watcherType, boolean bl2) throws InterruptedException, KeeperException {
        PathUtils.validatePath(string);
        String string2 = string;
        String string3 = this.prependChroot(string2);
        WatchDeregistration watchDeregistration = new WatchDeregistration(string2, watcher, watcherType, bl2, this.getWatchManager());
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(n2);
        mme mme2 = this.getRemoveWatchesRequest(n2, watcherType, string3);
        ReplyHeader replyHeader = this.cnxn.submitRequest(requestHeader, mme2, null, null, watchDeregistration);
        if (replyHeader.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(replyHeader.getErr()), string2);
        }
    }

    private void removeWatches(int n2, String string, Watcher watcher, Watcher.WatcherType watcherType, boolean bl2, AsyncCallback.VoidCallback voidCallback, Object object) {
        PathUtils.validatePath(string);
        String string2 = string;
        String string3 = this.prependChroot(string2);
        WatchDeregistration watchDeregistration = new WatchDeregistration(string2, watcher, watcherType, bl2, this.getWatchManager());
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(n2);
        mme mme2 = this.getRemoveWatchesRequest(n2, watcherType, string3);
        this.cnxn.queuePacket(requestHeader, new ReplyHeader(), mme2, null, voidCallback, string2, string3, object, null, watchDeregistration);
    }

    private mme getRemoveWatchesRequest(int n2, Watcher.WatcherType watcherType, String string) {
        mme mme2 = null;
        switch (n2) {
            case 17: {
                CheckWatchesRequest checkWatchesRequest = new CheckWatchesRequest();
                checkWatchesRequest.setPath(string);
                checkWatchesRequest.setType(watcherType.getIntValue());
                mme2 = checkWatchesRequest;
                break;
            }
            case 18: {
                RemoveWatchesRequest removeWatchesRequest = new RemoveWatchesRequest();
                removeWatchesRequest.setPath(string);
                removeWatchesRequest.setType(watcherType.getIntValue());
                mme2 = removeWatchesRequest;
                break;
            }
            default: {
                LOG.d("unknown type " + n2);
            }
        }
        return mme2;
    }

    public States getState() {
        return this.cnxn.getState();
    }

    public String toString() {
        States states = this.getState();
        return "State:" + states.toString() + (states.isConnected() ? " Timeout:" + this.getSessionTimeout() + " " : " ") + this.cnxn;
    }

    protected boolean testableWaitForShutdown(int n2) throws InterruptedException {
        this.cnxn.sendThread.join(n2);
        if (this.cnxn.sendThread.isAlive()) {
            return false;
        }
        this.cnxn.eventThread.join(n2);
        return !this.cnxn.eventThread.isAlive();
    }

    protected SocketAddress testableRemoteSocketAddress() {
        return this.cnxn.sendThread.getClientCnxnSocket().getRemoteSocketAddress();
    }

    protected SocketAddress testableLocalSocketAddress() {
        return this.cnxn.sendThread.getClientCnxnSocket().getLocalSocketAddress();
    }

    private ClientCnxnSocket getClientCnxnSocket() throws IOException {
        String string = this.getClientConfig().getProperty(ZOOKEEPER_CLIENT_CNXN_SOCKET);
        if (string == null || string.equals(ClientCnxnSocketNIO.class.getSimpleName())) {
            string = ClientCnxnSocketNIO.class.getName();
        } else if (string.equals(ClientCnxnSocketNetty.class.getSimpleName())) {
            string = ClientCnxnSocketNetty.class.getName();
        }
        try {
            Constructor<?> constructor = Class.forName(string).getDeclaredConstructor(ZKClientConfig.class);
            ClientCnxnSocket clientCnxnSocket = (ClientCnxnSocket)constructor.newInstance(this.getClientConfig());
            return clientCnxnSocket;
        }
        catch (Exception exception) {
            throw new IOException("Couldn't instantiate " + string, exception);
        }
    }

    private Watcher getDefaultWatcher(boolean bl2) {
        if (bl2) {
            Watcher watcher = this.getWatchManager().getDefaultWatcher();
            if (watcher != null) {
                return watcher;
            }
            throw new IllegalStateException("Default watcher is required, but it is null.");
        }
        return null;
    }

    private void validateACL(List<ACL> list) throws KeeperException.InvalidACLException {
        if (list == null || list.isEmpty() || list.contains(null)) {
            throw new KeeperException.InvalidACLException();
        }
    }

    public synchronized List<ClientInfo> whoAmI() throws InterruptedException {
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setType(107);
        WhoAmIResponse whoAmIResponse = new WhoAmIResponse();
        this.cnxn.submitRequest(requestHeader, null, whoAmIResponse, null);
        return whoAmIResponse.getClientInfo();
    }

    static {
        Environment.logEnv("Client environment:", LOG);
    }

    public static enum States {
        CONNECTING,
        ASSOCIATING,
        CONNECTED,
        CONNECTEDREADONLY,
        CLOSED,
        AUTH_FAILED,
        NOT_CONNECTED;


        public boolean isAlive() {
            return this != CLOSED && this != AUTH_FAILED;
        }

        public boolean isConnected() {
            return this == CONNECTED || this == CONNECTEDREADONLY;
        }
    }

    class AddWatchRegistration
    extends WatchRegistration {
        private final AddWatchMode mode;

        public AddWatchRegistration(Watcher watcher, String string, AddWatchMode addWatchMode) {
            super(watcher, string);
            this.mode = addWatchMode;
        }

        @Override
        protected Map<String, Set<Watcher>> getWatches(int n2) {
            switch (this.mode) {
                case PERSISTENT: {
                    return ZooKeeper.this.getWatchManager().getPersistentWatches();
                }
                case PERSISTENT_RECURSIVE: {
                    return ZooKeeper.this.getWatchManager().getPersistentRecursiveWatches();
                }
            }
            throw new IllegalArgumentException("Mode not supported: " + (Object)((Object)this.mode));
        }

        @Override
        protected boolean shouldAddWatch(int n2) {
            return n2 == KeeperException.Code.OK.intValue() || n2 == KeeperException.Code.NONODE.intValue();
        }
    }

    class ChildWatchRegistration
    extends WatchRegistration {
        public ChildWatchRegistration(Watcher watcher, String string) {
            super(watcher, string);
        }

        @Override
        protected Map<String, Set<Watcher>> getWatches(int n2) {
            return ZooKeeper.this.getWatchManager().getChildWatches();
        }
    }

    class DataWatchRegistration
    extends WatchRegistration {
        public DataWatchRegistration(Watcher watcher, String string) {
            super(watcher, string);
        }

        @Override
        protected Map<String, Set<Watcher>> getWatches(int n2) {
            return ZooKeeper.this.getWatchManager().getDataWatches();
        }
    }

    class ExistsWatchRegistration
    extends WatchRegistration {
        public ExistsWatchRegistration(Watcher watcher, String string) {
            super(watcher, string);
        }

        @Override
        protected Map<String, Set<Watcher>> getWatches(int n2) {
            return n2 == KeeperException.Code.OK.intValue() ? ZooKeeper.this.getWatchManager().getDataWatches() : ZooKeeper.this.getWatchManager().getExistWatches();
        }

        @Override
        protected boolean shouldAddWatch(int n2) {
            return n2 == KeeperException.Code.OK.intValue() || n2 == KeeperException.Code.NONODE.intValue();
        }
    }

    public static abstract class WatchRegistration {
        private Watcher watcher;
        private String clientPath;

        public WatchRegistration(Watcher watcher, String string) {
            this.watcher = watcher;
            this.clientPath = string;
        }

        protected abstract Map<String, Set<Watcher>> getWatches(int var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(int n2) {
            if (this.shouldAddWatch(n2)) {
                Map<String, Set<Watcher>> map;
                Map<String, Set<Watcher>> map2 = map = this.getWatches(n2);
                synchronized (map2) {
                    Set<Watcher> set = map.get(this.clientPath);
                    if (set == null) {
                        set = new HashSet<Watcher>();
                        map.put(this.clientPath, set);
                    }
                    set.add(this.watcher);
                }
            }
        }

        protected boolean shouldAddWatch(int n2) {
            return n2 == KeeperException.Code.OK.intValue();
        }
    }
}

