/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Shell {
    private static final foe LOG = goe.a(Shell.class);
    public static final String USER_NAME_COMMAND = "whoami";
    public static final String SET_PERMISSION_COMMAND = "chmod";
    public static final String SET_OWNER_COMMAND = "chown";
    public static final String SET_GROUP_COMMAND = "chgrp";
    protected long timeOutInterval = 0L;
    private AtomicBoolean timedOut;
    public static final String ULIMIT_COMMAND = "ulimit";
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private long interval;
    private long lastTime;
    private Map<String, String> environment;
    private File dir;
    private Process process;
    private int exitCode;
    private volatile AtomicBoolean completed;

    public static String[] getGroupsCommand() {
        return new String[]{"bash", "-c", "groups"};
    }

    public static String[] getGroupsForUserCommand(String string) {
        return new String[]{"bash", "-c", "id -Gn " + string};
    }

    public static String[] getGET_PERMISSION_COMMAND() {
        return new String[]{WINDOWS ? "ls" : "/bin/ls", "-ld"};
    }

    public static String[] getUlimitMemoryCommand(int n2) {
        if (WINDOWS) {
            return null;
        }
        return new String[]{ULIMIT_COMMAND, "-v", String.valueOf(n2)};
    }

    public Shell() {
        this(0L);
    }

    public Shell(long l2) {
        this.interval = l2;
        this.lastTime = l2 < 0L ? 0L : -l2;
    }

    protected void setEnvironment(Map<String, String> map) {
        this.environment = map;
    }

    protected void setWorkingDirectory(File file) {
        this.dir = file;
    }

    protected void run() throws IOException {
        if (this.lastTime + this.interval > Time.currentElapsedTime()) {
            return;
        }
        this.exitCode = ExitCode.EXECUTION_FINISHED.getValue();
        this.runCommand();
    }

    private void runCommand() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(this.getExecString());
        Timer timer = null;
        ShellTimeoutTimerTask shellTimeoutTimerTask = null;
        this.timedOut = new AtomicBoolean(false);
        this.completed = new AtomicBoolean(false);
        if (this.environment != null) {
            processBuilder.environment().putAll(this.environment);
        }
        if (this.dir != null) {
            processBuilder.directory(this.dir);
        }
        this.process = processBuilder.start();
        if (this.timeOutInterval > 0L) {
            timer = new Timer();
            shellTimeoutTimerTask = new ShellTimeoutTimerTask(this);
            timer.schedule((TimerTask)shellTimeoutTimerTask, this.timeOutInterval);
        }
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        final StringBuffer stringBuffer = new StringBuffer();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String string = bufferedReader.readLine();
                    while (string != null && !this.isInterrupted()) {
                        stringBuffer.append(string);
                        stringBuffer.append(System.getProperty("line.separator"));
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    LOG.c("Error reading the error stream", iOException);
                }
            }
        };
        try {
            thread.start();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.parseExecResult(bufferedReader2);
            String string = bufferedReader2.readLine();
            while (string != null) {
                string = bufferedReader2.readLine();
            }
            this.exitCode = this.process.waitFor();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                LOG.c("Interrupted while reading the error stream", interruptedException);
            }
            this.completed.set(true);
            if (this.exitCode != ExitCode.EXECUTION_FINISHED.getValue()) {
                throw new ExitCodeException(this.exitCode, stringBuffer.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.toString());
        }
        finally {
            if (timer != null && !this.timedOut.get()) {
                timer.cancel();
            }
            try {
                bufferedReader2.close();
            }
            catch (IOException iOException) {
                LOG.c("Error while closing the input stream", iOException);
            }
            if (!this.completed.get()) {
                thread.interrupt();
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                LOG.c("Error while closing the error stream", iOException);
            }
            this.process.destroy();
            this.lastTime = Time.currentElapsedTime();
        }
    }

    protected abstract String[] getExecString();

    protected abstract void parseExecResult(BufferedReader var1) throws IOException;

    public Process getProcess() {
        return this.process;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean isTimedOut() {
        return this.timedOut.get();
    }

    private void setTimedOut() {
        this.timedOut.set(true);
    }

    public static String execCommand(String ... stringArray) throws IOException {
        return Shell.execCommand(null, stringArray, 0L);
    }

    public static String execCommand(Map<String, String> map, String[] stringArray, long l2) throws IOException {
        ShellCommandExecutor shellCommandExecutor = new ShellCommandExecutor(stringArray, null, map, l2);
        shellCommandExecutor.execute();
        return shellCommandExecutor.getOutput();
    }

    public static String execCommand(Map<String, String> map, String ... stringArray) throws IOException {
        return Shell.execCommand(map, stringArray, 0L);
    }

    static class ShellTimeoutTimerTask
    extends TimerTask {
        private Shell shell;

        public ShellTimeoutTimerTask(Shell shell) {
            this.shell = shell;
        }

        @Override
        public void run() {
            block2: {
                Process process = this.shell.getProcess();
                try {
                    process.exitValue();
                }
                catch (Exception exception) {
                    if (process == null || this.shell.completed.get()) break block2;
                    this.shell.setTimedOut();
                    process.destroy();
                }
            }
        }
    }

    public static class ShellCommandExecutor
    extends Shell {
        private String[] command;
        private StringBuffer output;

        public ShellCommandExecutor(String[] stringArray) {
            this(stringArray, null);
        }

        public ShellCommandExecutor(String[] stringArray, File file) {
            this(stringArray, file, null);
        }

        public ShellCommandExecutor(String[] stringArray, File file, Map<String, String> map) {
            this(stringArray, file, map, 0L);
        }

        public ShellCommandExecutor(String[] stringArray, File file, Map<String, String> map, long l2) {
            this.command = (String[])stringArray.clone();
            if (file != null) {
                this.setWorkingDirectory(file);
            }
            if (map != null) {
                this.setEnvironment(map);
            }
            this.timeOutInterval = l2;
        }

        public void execute() throws IOException {
            this.run();
        }

        @Override
        protected String[] getExecString() {
            return this.command;
        }

        @Override
        protected void parseExecResult(BufferedReader bufferedReader) throws IOException {
            int n2;
            this.output = new StringBuffer();
            char[] cArray = new char[512];
            while ((n2 = bufferedReader.read(cArray, 0, cArray.length)) > 0) {
                this.output.append(cArray, 0, n2);
            }
        }

        public String getOutput() {
            return this.output == null ? "" : this.output.toString();
        }

        public String toString() {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray = this.getExecString()) {
                if (string.indexOf(32) >= 0) {
                    stringBuilder.append('\"').append(string).append('\"');
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
    }

    public static class ExitCodeException
    extends IOException {
        int exitCode;

        public ExitCodeException(int n2, String string) {
            super(string);
            this.exitCode = n2;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

