/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import java.util.Arrays;
import java.util.List;

public abstract class OpResult {
    private int type;

    private OpResult(int n2) {
        this.type = n2;
    }

    public int getType() {
        return this.type;
    }

    public static class ErrorResult
    extends OpResult {
        private int err;

        public ErrorResult(int n2) {
            super(-1);
            this.err = n2;
        }

        public int getErr() {
            return this.err;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ErrorResult)) {
                return false;
            }
            ErrorResult errorResult = (ErrorResult)object;
            return this.getType() == errorResult.getType() && this.err == errorResult.getErr();
        }

        public int hashCode() {
            return this.getType() * 35 + this.err;
        }
    }

    public static class GetDataResult
    extends OpResult {
        private byte[] data;
        private Stat stat;

        public GetDataResult(byte[] byArray, Stat stat) {
            super(4);
            this.data = byArray == null ? null : Arrays.copyOf(byArray, byArray.length);
            this.stat = stat;
        }

        public byte[] getData() {
            return this.data == null ? null : Arrays.copyOf(this.data, this.data.length);
        }

        public Stat getStat() {
            return this.stat;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof GetDataResult)) {
                return false;
            }
            GetDataResult getDataResult = (GetDataResult)object;
            return this.getType() == getDataResult.getType() && this.stat.equals(getDataResult.stat) && Arrays.equals(this.data, getDataResult.data);
        }

        public int hashCode() {
            return (int)((long)(this.getType() * 35) + this.stat.getMzxid() + (long)Arrays.hashCode(this.data));
        }
    }

    public static class GetChildrenResult
    extends OpResult {
        private List<String> children;

        public GetChildrenResult(List<String> list) {
            super(8);
            this.children = list;
        }

        public List<String> getChildren() {
            return this.children;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof GetChildrenResult)) {
                return false;
            }
            GetChildrenResult getChildrenResult = (GetChildrenResult)object;
            return this.getType() == getChildrenResult.getType() && this.children.equals(getChildrenResult.children);
        }

        public int hashCode() {
            return this.getType() * 35 + this.children.hashCode();
        }
    }

    public static class CheckResult
    extends OpResult {
        public CheckResult() {
            super(13);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CheckResult)) {
                return false;
            }
            CheckResult checkResult = (CheckResult)object;
            return this.getType() == checkResult.getType();
        }

        public int hashCode() {
            return this.getType();
        }
    }

    public static class SetDataResult
    extends OpResult {
        private Stat stat;

        public SetDataResult(Stat stat) {
            super(5);
            this.stat = stat;
        }

        public Stat getStat() {
            return this.stat;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SetDataResult)) {
                return false;
            }
            SetDataResult setDataResult = (SetDataResult)object;
            return this.getType() == setDataResult.getType() && this.stat.getMzxid() == setDataResult.stat.getMzxid();
        }

        public int hashCode() {
            return (int)((long)(this.getType() * 35) + this.stat.getMzxid());
        }
    }

    public static class DeleteResult
    extends OpResult {
        public DeleteResult() {
            super(2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof DeleteResult)) {
                return false;
            }
            DeleteResult deleteResult = (DeleteResult)object;
            return this.getType() == deleteResult.getType();
        }

        public int hashCode() {
            return this.getType();
        }
    }

    public static class CreateResult
    extends OpResult {
        private String path;
        private Stat stat;

        public CreateResult(String string) {
            this(1, string, null);
        }

        public CreateResult(String string, Stat stat) {
            this(15, string, stat);
        }

        private CreateResult(int n2, String string, Stat stat) {
            super(n2);
            this.path = string;
            this.stat = stat;
        }

        public String getPath() {
            return this.path;
        }

        public Stat getStat() {
            return this.stat;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CreateResult)) {
                return false;
            }
            CreateResult createResult = (CreateResult)object;
            boolean bl2 = this.stat == null && createResult.stat == null || this.stat != null && createResult.stat != null && this.stat.getMzxid() == createResult.stat.getMzxid();
            return this.getType() == createResult.getType() && this.path.equals(createResult.getPath()) && bl2;
        }

        public int hashCode() {
            return (int)((long)(this.getType() * 35 + this.path.hashCode()) + (this.stat == null ? 0L : this.stat.getMzxid()));
        }
    }
}

