/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XcoreXdatabricksX240X9088.kme;
import XcoreXdatabricksX240X9088.lme;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateOptions;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Op;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CheckVersionRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateTTLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.DeleteRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildrenRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetDataRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.MultiHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetDataRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiOperationRecord
implements mme,
Iterable<Op> {
    private List<Op> ops = new ArrayList<Op>();
    private Op.OpKind opKind = null;

    public MultiOperationRecord() {
    }

    public MultiOperationRecord(Iterable<Op> iterable) throws IllegalArgumentException {
        for (Op op2 : iterable) {
            this.setOrCheckOpKind(op2.getKind());
            this.add(op2);
        }
    }

    @Override
    public Iterator<Op> iterator() {
        return this.ops.iterator();
    }

    public void add(Op op2) throws IllegalArgumentException {
        this.setOrCheckOpKind(op2.getKind());
        this.ops.add(op2);
    }

    public int size() {
        return this.ops.size();
    }

    public Op.OpKind getOpKind() {
        return this.opKind;
    }

    private void setOrCheckOpKind(Op.OpKind opKind) throws IllegalArgumentException {
        if (this.opKind == null) {
            this.opKind = opKind;
        } else if (opKind != this.opKind) {
            throw new IllegalArgumentException("Mixing read and write operations (transactions) is not allowed in a multi request.");
        }
    }

    @Override
    public void serialize(lme lme2, String string) throws IOException {
        lme2.b(this, string);
        block3: for (Op op2 : this.ops) {
            MultiHeader multiHeader = new MultiHeader(op2.getType(), false, -1);
            multiHeader.serialize(lme2, string);
            switch (op2.getType()) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 8: 
                case 13: 
                case 15: 
                case 19: 
                case 21: {
                    op2.toRequestRecord().serialize(lme2, string);
                    continue block3;
                }
            }
            throw new IOException("Invalid type of op");
        }
        new MultiHeader(-1, true, -1).serialize(lme2, string);
        lme2.c(this, string);
    }

    @Override
    public void deserialize(kme kme2, String string) throws IOException {
        kme2.g(string);
        MultiHeader multiHeader = new MultiHeader();
        multiHeader.deserialize(kme2, string);
        try {
            while (!multiHeader.getDone()) {
                switch (multiHeader.getType()) {
                    case 1: 
                    case 15: 
                    case 19: {
                        CreateRequest createRequest = new CreateRequest();
                        createRequest.deserialize(kme2, string);
                        CreateMode createMode = CreateMode.fromFlag(createRequest.getFlags(), null);
                        if (createMode == null) {
                            throw new IOException("invalid flag " + createRequest.getFlags() + " for create mode");
                        }
                        CreateOptions createOptions = CreateOptions.newBuilder(createRequest.getAcl(), createMode).build();
                        this.add(Op.create(createRequest.getPath(), createRequest.getData(), createOptions, multiHeader.getType()));
                        break;
                    }
                    case 21: {
                        CreateTTLRequest createTTLRequest = new CreateTTLRequest();
                        createTTLRequest.deserialize(kme2, string);
                        this.add(Op.create(createTTLRequest.getPath(), createTTLRequest.getData(), createTTLRequest.getAcl(), createTTLRequest.getFlags(), createTTLRequest.getTtl()));
                        break;
                    }
                    case 2: {
                        DeleteRequest deleteRequest = new DeleteRequest();
                        deleteRequest.deserialize(kme2, string);
                        this.add(Op.delete(deleteRequest.getPath(), deleteRequest.getVersion()));
                        break;
                    }
                    case 5: {
                        SetDataRequest setDataRequest = new SetDataRequest();
                        setDataRequest.deserialize(kme2, string);
                        this.add(Op.setData(setDataRequest.getPath(), setDataRequest.getData(), setDataRequest.getVersion()));
                        break;
                    }
                    case 13: {
                        CheckVersionRequest checkVersionRequest = new CheckVersionRequest();
                        checkVersionRequest.deserialize(kme2, string);
                        this.add(Op.check(checkVersionRequest.getPath(), checkVersionRequest.getVersion()));
                        break;
                    }
                    case 8: {
                        GetChildrenRequest getChildrenRequest = new GetChildrenRequest();
                        getChildrenRequest.deserialize(kme2, string);
                        this.add(Op.getChildren(getChildrenRequest.getPath()));
                        break;
                    }
                    case 4: {
                        GetDataRequest getDataRequest = new GetDataRequest();
                        getDataRequest.deserialize(kme2, string);
                        this.add(Op.getData(getDataRequest.getPath()));
                        break;
                    }
                    default: {
                        throw new IOException("Invalid type of op");
                    }
                }
                multiHeader.deserialize(kme2, string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Mixing different kind of ops");
        }
        kme2.h(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiOperationRecord)) {
            return false;
        }
        MultiOperationRecord multiOperationRecord = (MultiOperationRecord)object;
        if (this.ops != null) {
            Iterator<Op> iterator = multiOperationRecord.ops.iterator();
            for (Op op2 : this.ops) {
                boolean bl2 = iterator.hasNext();
                if (!bl2) {
                    return false;
                }
                Op op3 = iterator.next();
                if (op2.equals(op3)) continue;
                return false;
            }
            return !iterator.hasNext();
        }
        return multiOperationRecord.ops == null;
    }

    public int hashCode() {
        int n2 = 1023;
        for (Op op2 : this.ops) {
            n2 = n2 * 25 + op2.hashCode();
        }
        return n2;
    }
}

