/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Shell;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.ZKClientConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKConfig;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class Login {
    private static final String KINIT_COMMAND_DEFAULT = "/usr/bin/kinit";
    private static final foe LOG = goe.a(Login.class);
    public static final String SYSTEM_USER = System.getProperty("user.name", "<NA>");
    public CallbackHandler callbackHandler;
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private static final float TICKET_RENEW_JITTER = 0.05f;
    private static final long DEFAULT_MIN_TIME_BEFORE_RELOGIN = 60000L;
    public static final String MIN_TIME_BEFORE_RELOGIN_CONFIG_KEY = "zookeeper.kerberos.minReLoginTimeMs";
    private static final long MIN_TIME_BEFORE_RELOGIN = Long.getLong("zookeeper.kerberos.minReLoginTimeMs", 60000L);
    private Subject subject = null;
    private Thread t = null;
    private boolean isKrbTicket = false;
    private boolean isUsingTicketCache = false;
    private LoginContext login = null;
    private String loginContextName = null;
    private String principal = null;
    private long lastLogin = Time.currentElapsedTime() - MIN_TIME_BEFORE_RELOGIN;
    private final ZKConfig zkConfig;

    public Login(String string, CallbackHandler callbackHandler, final ZKConfig zKConfig) throws LoginException {
        AppConfigurationEntry[] appConfigurationEntryArray;
        this.zkConfig = zKConfig;
        this.callbackHandler = callbackHandler;
        this.login = this.login(string);
        this.loginContextName = string;
        this.subject = this.login.getSubject();
        this.isKrbTicket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
        AppConfigurationEntry[] appConfigurationEntryArray2 = appConfigurationEntryArray = Configuration.getConfiguration().getAppConfigurationEntry(string);
        int n2 = appConfigurationEntryArray2.length;
        int n3 = 0;
        if (n3 < n2) {
            String string2;
            AppConfigurationEntry appConfigurationEntry = appConfigurationEntryArray2[n3];
            if (appConfigurationEntry.getOptions().get("useTicketCache") != null && (string2 = (String)appConfigurationEntry.getOptions().get("useTicketCache")).equals("true")) {
                this.isUsingTicketCache = true;
            }
            if (appConfigurationEntry.getOptions().get("principal") != null) {
                this.principal = (String)appConfigurationEntry.getOptions().get("principal");
            }
        }
        if (!this.isKrbTicket) {
            return;
        }
        this.t = new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.c("TGT refresh thread started.");
                block12: while (true) {
                    block28: {
                        Date date;
                        long l2;
                        KerberosTicket kerberosTicket = Login.this.getTGT();
                        long l3 = Time.currentWallTime();
                        if (kerberosTicket == null) {
                            l2 = l3 + MIN_TIME_BEFORE_RELOGIN;
                            date = new Date(l2);
                            LOG.d("No TGT found: will try again at {}", (Object)date);
                        } else {
                            l2 = Login.this.getRefreshTime(kerberosTicket);
                            long l4 = kerberosTicket.getEndTime().getTime();
                            Date date2 = new Date(l4);
                            if (Login.this.isUsingTicketCache && kerberosTicket.getEndTime().equals(kerberosTicket.getRenewTill())) {
                                LOG.e("The TGT cannot be renewed beyond the next expiry date: {}.This process will not be able to authenticate new SASL connections after that time (for example, it will not be authenticate a new connection with a Zookeeper Quorum member).  Ask your system administrator to either increase the 'renew until' time by doing : 'modprinc -maxrenewlife {}' within kadmin, or instead, to generate a keytab for {}. Because the TGT's expiry cannot be further extended by refreshing, exiting refresh thread now.", date2, Login.this.principal, Login.this.principal);
                                return;
                            }
                            if (l2 > l4 || l3 + MIN_TIME_BEFORE_RELOGIN > l4) {
                                l2 = l3;
                            } else {
                                if (l2 < l3 + MIN_TIME_BEFORE_RELOGIN) {
                                    Date date3 = new Date(l2);
                                    Date date4 = new Date(l3 + MIN_TIME_BEFORE_RELOGIN);
                                    LOG.d("TGT refresh thread time adjusted from : {} to : {} since the former is sooner than the minimum refresh interval ({} seconds) from now.", date3, date4, MIN_TIME_BEFORE_RELOGIN / 1000L);
                                }
                                l2 = Math.max(l2, l3 + MIN_TIME_BEFORE_RELOGIN);
                            }
                            date = new Date(l2);
                            if (l2 > l4) {
                                LOG.e("next refresh: {} is later than expiry {}. This may indicate a clock skew problem. Check that this host and the KDC's hosts' clocks are in sync. Exiting refresh thread.", (Object)date, (Object)date2);
                                return;
                            }
                        }
                        if (l3 == l2) {
                            LOG.c("refreshing now because expiry is before next scheduled refresh time.");
                        } else {
                            if (l3 < l2) {
                                Date date5 = new Date(l2);
                                LOG.c("TGT refresh sleeping until: {}", (Object)date5.toString());
                                try {
                                    Thread.sleep(l2 - l3);
                                    break block28;
                                }
                                catch (InterruptedException interruptedException) {
                                    LOG.d("TGT renewal thread has been interrupted and will exit.");
                                    break;
                                }
                            }
                            LOG.e("nextRefresh:{} is in the past: exiting refresh thread. Check clock sync between this host and KDC - (KDC's clock is likely ahead of this host). Manual intervention will be required for this client to successfully authenticate. Exiting refresh thread.", (Object)date);
                            break;
                        }
                    }
                    if (Login.this.isUsingTicketCache) {
                        String string = zKConfig.getProperty("zookeeper.kinit", Login.KINIT_COMMAND_DEFAULT);
                        String string2 = "-R";
                        for (int i2 = 1; i2 >= 0; --i2) {
                            try {
                                LOG.b("running ticket cache refresh command: {} {}", (Object)string, (Object)string2);
                                Shell.execCommand(string, string2);
                                break;
                            }
                            catch (Exception exception) {
                                if (i2 > 0) {
                                    try {
                                        Login.this.sleepBeforeRetryFailedRefresh();
                                        continue;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        LOG.e("Interrupted while renewing TGT, exiting Login thread");
                                        return;
                                    }
                                }
                                LOG.d("Could not renew TGT due to problem running shell command: '{} {}'. Exiting refresh thread.", string, string2, exception);
                                return;
                            }
                        }
                    }
                    try {
                        int n2 = 1;
                        while (true) {
                            if (n2 < 0) continue block12;
                            try {
                                Login.this.reLogin();
                                continue block12;
                            }
                            catch (LoginException loginException) {
                                if (n2 > 0) {
                                    --n2;
                                    try {
                                        Login.this.sleepBeforeRetryFailedRefresh();
                                        continue;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        LOG.d("Interrupted during login retry after LoginException:", loginException);
                                        throw loginException;
                                    }
                                }
                                LOG.e("Could not refresh TGT for principal: {}.", (Object)Login.this.principal, (Object)loginException);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (LoginException loginException) {
                        LOG.d("Failed to refresh TGT: refresh thread exiting now.", loginException);
                        break;
                    }
                }
            }
        });
        this.t.setDaemon(true);
    }

    public void startThreadIfNeeded() {
        if (this.t != null) {
            this.t.start();
        }
    }

    public void shutdown() {
        if (this.t != null && this.t.isAlive()) {
            this.t.interrupt();
            try {
                this.t.join();
            }
            catch (InterruptedException interruptedException) {
                LOG.c("error while waiting for Login thread to shutdown.", interruptedException);
            }
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getUserName() {
        if (this.principal == null || this.principal.isEmpty()) {
            return SYSTEM_USER;
        }
        return this.principal;
    }

    public String getLoginContextName() {
        return this.loginContextName;
    }

    private synchronized LoginContext login(String string) throws LoginException {
        if (string == null) {
            throw new LoginException("loginContext name (JAAS file section header) was null. Please check your java.security.login.auth.config (=" + System.getProperty("java.security.login.auth.config") + ") and your " + this.getLoginContextMessage());
        }
        LoginContext loginContext = new LoginContext(string, this.callbackHandler);
        loginContext.login();
        LOG.c("{} successfully logged in.", (Object)string);
        return loginContext;
    }

    private String getLoginContextMessage() {
        if (this.zkConfig instanceof ZKClientConfig) {
            return "zookeeper.sasl.clientconfig(=" + this.zkConfig.getProperty("zookeeper.sasl.clientconfig", "Client") + ")";
        }
        return "zookeeper.sasl.serverconfig(=" + System.getProperty("zookeeper.sasl.serverconfig", "Server") + ")";
    }

    private long getRefreshTime(KerberosTicket kerberosTicket) {
        long l2 = kerberosTicket.getStartTime().getTime();
        long l3 = kerberosTicket.getEndTime().getTime();
        LOG.c("TGT valid starting at:        {}", (Object)kerberosTicket.getStartTime().toString());
        LOG.c("TGT expires:                  {}", (Object)kerberosTicket.getEndTime().toString());
        long l4 = l2 + (long)((double)(l3 - l2) * ((double)0.8f + (double)0.05f * ThreadLocalRandom.current().nextDouble()));
        if (l4 > l3) {
            return Time.currentWallTime();
        }
        return l4;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> set = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket kerberosTicket : set) {
            KerberosPrincipal kerberosPrincipal = kerberosTicket.getServer();
            if (!kerberosPrincipal.getName().equals("krbtgt/" + kerberosPrincipal.getRealm() + "@" + kerberosPrincipal.getRealm())) continue;
            LOG.b("Client principal is \"{}\".", (Object)kerberosTicket.getClient().getName());
            LOG.b("Server principal is \"{}\".", (Object)kerberosTicket.getServer().getName());
            return kerberosTicket;
        }
        return null;
    }

    private boolean hasSufficientTimeElapsed() {
        long l2 = Time.currentElapsedTime();
        if (l2 - this.getLastLogin() < MIN_TIME_BEFORE_RELOGIN) {
            LOG.d("Not attempting to re-login since the last re-login was attempted less than {} seconds before.", (Object)(MIN_TIME_BEFORE_RELOGIN / 1000L));
            return false;
        }
        this.setLastLogin(l2);
        return true;
    }

    private LoginContext getLogin() {
        return this.login;
    }

    private void setLogin(LoginContext loginContext) {
        this.login = loginContext;
    }

    private void setLastLogin(long l2) {
        this.lastLogin = l2;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reLogin() throws LoginException {
        if (!this.isKrbTicket) {
            return;
        }
        LoginContext loginContext = this.getLogin();
        if (loginContext == null) {
            throw new LoginException("login must be done first");
        }
        if (!this.hasSufficientTimeElapsed()) {
            return;
        }
        LOG.c("Initiating logout for {}", (Object)this.principal);
        Class<Login> clazz = Login.class;
        synchronized (Login.class) {
            this.logout();
            loginContext = new LoginContext(this.loginContextName, this.getSubject());
            LOG.c("Initiating re-login for {}", (Object)this.principal);
            loginContext.login();
            this.setLogin(loginContext);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected synchronized void logout() throws LoginException {
        if (this.subject != null && !this.subject.getPrincipals().isEmpty()) {
            this.login.logout();
        }
    }

    protected void sleepBeforeRetryFailedRefresh() throws InterruptedException {
        Thread.sleep(10000L);
    }
}

