/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.EphemeralType;
import java.util.List;
import java.util.Objects;

public class CreateOptions {
    private final CreateMode createMode;
    private final List<ACL> acl;
    private final long ttl;

    public CreateMode getCreateMode() {
        return this.createMode;
    }

    public List<ACL> getAcl() {
        return this.acl;
    }

    public long getTtl() {
        return this.ttl;
    }

    public static Builder newBuilder(List<ACL> list, CreateMode createMode) {
        return new Builder(createMode, list);
    }

    private CreateOptions(CreateMode createMode, List<ACL> list, long l2) {
        this.createMode = createMode;
        this.acl = list;
        this.ttl = l2;
        EphemeralType.validateTTL(createMode, l2);
    }

    public static class Builder {
        private final CreateMode createMode;
        private final List<ACL> acl;
        private long ttl = -1L;

        private Builder(CreateMode createMode, List<ACL> list) {
            this.createMode = Objects.requireNonNull(createMode, "create mode is mandatory for create options");
            this.acl = Objects.requireNonNull(list, "acl is mandatory for create options");
        }

        public Builder withTtl(long l2) {
            this.ttl = l2;
            return this;
        }

        public CreateOptions build() {
            return new CreateOptions(this.createMode, this.acl, this.ttl);
        }
    }
}

