/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.yetus.audience.tools;

import XdepsXdatabricksX240X9088.org.apache.yetus.audience.InterfaceAudience;
import XdepsXdatabricksX240X9088.org.apache.yetus.audience.InterfaceStability;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;

class RootDocProcessor {
    static String stability = "-unstable";
    static boolean treatUnannotatedClassesAsPrivate = false;
    private static Map<Object, Object> proxies = new WeakHashMap<Object, Object>();

    RootDocProcessor() {
    }

    public static RootDoc process(RootDoc rootDoc) {
        return (RootDoc)RootDocProcessor.process(rootDoc, RootDoc.class);
    }

    private static Object process(Object object, Class<?> clazz) {
        if (object == null) {
            return null;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz2.getName().startsWith("com.sun.")) {
            return RootDocProcessor.getProxy(object);
        }
        if (object instanceof Object[]) {
            Class<?> clazz3 = clazz.isArray() ? clazz.getComponentType() : clazz2.getComponentType();
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])Array.newInstance(clazz3, objectArray.length);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray2[i2] = RootDocProcessor.process(objectArray[i2], clazz3);
            }
            return objectArray2;
        }
        return object;
    }

    private static Object getProxy(Object object) {
        Object object2 = proxies.get(object);
        if (object2 == null) {
            object2 = Proxy.newProxyInstance(object.getClass().getClassLoader(), object.getClass().getInterfaces(), (InvocationHandler)new ExcludeHandler(object));
            proxies.put(object, object2);
        }
        return object2;
    }

    static class ExcludeHandler
    implements InvocationHandler {
        private Object target;

        public ExcludeHandler(Object object) {
            this.target = object;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (this.target instanceof Doc) {
                if (string.equals("isIncluded")) {
                    Doc doc2 = (Doc)this.target;
                    return !ExcludeHandler.exclude(doc2) && doc2.isIncluded();
                }
                if (this.target instanceof RootDoc) {
                    switch (string) {
                        case "classes": {
                            return ExcludeHandler.filter((Doc[])((RootDoc)this.target).classes(), ClassDoc.class);
                        }
                        case "specifiedClasses": {
                            return ExcludeHandler.filter((Doc[])((RootDoc)this.target).specifiedClasses(), ClassDoc.class);
                        }
                        case "specifiedPackages": {
                            return ExcludeHandler.filter((Doc[])((RootDoc)this.target).specifiedPackages(), PackageDoc.class);
                        }
                    }
                } else if (this.target instanceof ClassDoc) {
                    if (this.isFiltered(objectArray)) {
                        switch (string) {
                            case "methods": {
                                return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).methods(true), MethodDoc.class);
                            }
                            case "fields": {
                                return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).fields(true), FieldDoc.class);
                            }
                            case "innerClasses": {
                                return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).innerClasses(true), ClassDoc.class);
                            }
                            case "constructors": {
                                return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).constructors(true), ConstructorDoc.class);
                            }
                        }
                    }
                } else if (this.target instanceof PackageDoc) {
                    switch (string) {
                        case "allClasses": {
                            if (this.isFiltered(objectArray)) {
                                return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).allClasses(true), ClassDoc.class);
                            }
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).allClasses(), ClassDoc.class);
                        }
                        case "annotationTypes": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).annotationTypes(), AnnotationTypeDoc.class);
                        }
                        case "enums": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).enums(), ClassDoc.class);
                        }
                        case "errors": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).errors(), ClassDoc.class);
                        }
                        case "exceptions": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).exceptions(), ClassDoc.class);
                        }
                        case "interfaces": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).interfaces(), ClassDoc.class);
                        }
                        case "ordinaryClasses": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).ordinaryClasses(), ClassDoc.class);
                        }
                    }
                }
            }
            if (objectArray != null && (string.equals("compareTo") || string.equals("equals") || string.equals("overrides") || string.equals("subclassOf"))) {
                objectArray[0] = this.unwrap(objectArray[0]);
            }
            try {
                return RootDocProcessor.process(method.invoke(this.target, objectArray), method.getReturnType());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }

        private static boolean exclude(Doc doc2) {
            AnnotationDesc[] annotationDescArray = null;
            if (doc2 instanceof ProgramElementDoc) {
                annotationDescArray = ((ProgramElementDoc)doc2).annotations();
            } else if (doc2 instanceof PackageDoc) {
                annotationDescArray = ((PackageDoc)doc2).annotations();
            }
            if (annotationDescArray != null) {
                String string;
                for (AnnotationDesc annotationDesc : annotationDescArray) {
                    string = annotationDesc.annotationType().qualifiedTypeName();
                    if (string.equals(InterfaceAudience.Private.class.getCanonicalName()) || string.equals(InterfaceAudience.LimitedPrivate.class.getCanonicalName())) {
                        return true;
                    }
                    if (stability.equals("-evolving") && string.equals(InterfaceStability.Unstable.class.getCanonicalName())) {
                        return true;
                    }
                    if (!stability.equals("-stable") || !string.equals(InterfaceStability.Unstable.class.getCanonicalName()) && !string.equals(InterfaceStability.Evolving.class.getCanonicalName())) continue;
                    return true;
                }
                for (AnnotationDesc annotationDesc : annotationDescArray) {
                    string = annotationDesc.annotationType().qualifiedTypeName();
                    if (!string.equals(InterfaceAudience.Public.class.getCanonicalName())) continue;
                    return false;
                }
            }
            if (treatUnannotatedClassesAsPrivate) {
                return doc2.isClass() || doc2.isInterface() || doc2.isAnnotationType();
            }
            return false;
        }

        private static Object[] filter(Doc[] docArray, Class<?> clazz) {
            if (docArray == null || docArray.length == 0) {
                return docArray;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(docArray.length);
            for (Doc doc2 : docArray) {
                if (ExcludeHandler.exclude(doc2)) continue;
                arrayList.add(RootDocProcessor.process(doc2, clazz));
            }
            return arrayList.toArray((Object[])Array.newInstance(clazz, arrayList.size()));
        }

        private Object unwrap(Object object) {
            if (object instanceof Proxy) {
                return ((ExcludeHandler)Proxy.getInvocationHandler((Object)object)).target;
            }
            return object;
        }

        private boolean isFiltered(Object[] objectArray) {
            return objectArray != null && Boolean.TRUE.equals(objectArray[0]);
        }
    }
}

