/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.traffic;

import XdepsXdatabricksX240X9088.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import XdepsXdatabricksX240X9088.io.netty.handler.traffic.TrafficCounter;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class GlobalTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final ConcurrentMap<Integer, PerChannel> channelQueues = PlatformDependent.newConcurrentHashMap();
    private final AtomicLong queuesSize = new AtomicLong();
    long maxGlobalWriteSize = 0x19000000L;

    void createGlobalTrafficCounter(ScheduledExecutorService scheduledExecutorService) {
        TrafficCounter trafficCounter = new TrafficCounter(this, (ScheduledExecutorService)ObjectUtil.checkNotNull((Object)scheduledExecutorService, (String)"executor"), "GlobalTC", this.checkInterval);
        this.setTrafficCounter(trafficCounter);
        trafficCounter.start();
    }

    @Override
    protected int userDefinedWritabilityIndex() {
        return 2;
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l3, long l4, long l5) {
        super(l2, l3, l4, l5);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l3, long l4) {
        super(l2, l3, l4);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l3) {
        super(l2, l3);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2) {
        super(l2);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(EventExecutor eventExecutor) {
        this.createGlobalTrafficCounter((ScheduledExecutorService)eventExecutor);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    public void setMaxGlobalWriteSize(long l2) {
        this.maxGlobalWriteSize = l2;
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    private PerChannel getOrSetPerChannel(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        Integer n2 = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(n2);
        if (perChannel == null) {
            perChannel = new PerChannel();
            perChannel.messagesQueue = new ArrayDeque();
            perChannel.queueSize = 0L;
            perChannel.lastWriteTimestamp = perChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put(n2, perChannel);
        }
        return perChannel;
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.getOrSetPerChannel(channelHandlerContext);
        super.handlerAdded(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        Channel channel = channelHandlerContext.channel();
        Integer n2 = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.remove(n2);
        if (perChannel != null) {
            PerChannel perChannel2 = perChannel;
            synchronized (perChannel2) {
                if (channel.isActive()) {
                    for (ToSend toSend : perChannel.messagesQueue) {
                        long l2 = this.calculateSize(toSend.toSend);
                        this.trafficCounter.bytesRealWriteFlowControl(l2);
                        perChannel.queueSize -= l2;
                        this.queuesSize.addAndGet(-l2);
                        channelHandlerContext.write(toSend.toSend, toSend.promise);
                    }
                } else {
                    this.queuesSize.addAndGet(-perChannel.queueSize);
                    for (ToSend toSend : perChannel.messagesQueue) {
                        if (!(toSend.toSend instanceof ByteBuf)) continue;
                        ((ByteBuf)toSend.toSend).release();
                    }
                }
                perChannel.messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    long checkWaitReadTime(ChannelHandlerContext channelHandlerContext, long l2, long l3) {
        Integer n2 = channelHandlerContext.channel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(n2);
        if (perChannel != null && l2 > this.maxTime && l3 + l2 - perChannel.lastReadTimestamp > this.maxTime) {
            l2 = this.maxTime;
        }
        return l2;
    }

    @Override
    void informReadOperation(ChannelHandlerContext channelHandlerContext, long l2) {
        Integer n2 = channelHandlerContext.channel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(n2);
        if (perChannel != null) {
            perChannel.lastReadTimestamp = l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void submitWrite(final ChannelHandlerContext channelHandlerContext, Object object, long l2, long l3, long l4, ChannelPromise channelPromise) {
        ToSend toSend;
        Channel channel = channelHandlerContext.channel();
        Integer n2 = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(n2);
        if (perChannel == null) {
            perChannel = this.getOrSetPerChannel(channelHandlerContext);
        }
        long l5 = l3;
        boolean bl2 = false;
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            if (l3 == 0L && perChannel.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l2);
                channelHandlerContext.write(object, channelPromise);
                perChannel.lastWriteTimestamp = l4;
                return;
            }
            if (l5 > this.maxTime && l4 + l5 - perChannel.lastWriteTimestamp > this.maxTime) {
                l5 = this.maxTime;
            }
            toSend = new ToSend(l5 + l4, object, l2, channelPromise);
            perChannel.messagesQueue.addLast(toSend);
            perChannel.queueSize += l2;
            this.queuesSize.addAndGet(l2);
            this.checkWriteSuspend(channelHandlerContext, l5, perChannel.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.setUserDefinedWritability(channelHandlerContext, false);
        }
        final long l6 = toSend.relativeTimeAction;
        final PerChannel perChannel3 = perChannel;
        channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                GlobalTrafficShapingHandler.this.sendAllValid(channelHandlerContext, perChannel3, l6);
            }
        }, l5, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext channelHandlerContext, PerChannel perChannel, long l2) {
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            ToSend toSend = perChannel.messagesQueue.pollFirst();
            while (toSend != null) {
                long l3;
                if (toSend.relativeTimeAction <= l2) {
                    l3 = toSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(l3);
                    perChannel.queueSize -= l3;
                } else {
                    perChannel.messagesQueue.addFirst(toSend);
                    break;
                }
                this.queuesSize.addAndGet(-l3);
                channelHandlerContext.write(toSend.toSend, toSend.promise);
                perChannel.lastWriteTimestamp = l2;
                toSend = perChannel.messagesQueue.pollFirst();
            }
            if (perChannel.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    static final class ToSend {
        final long relativeTimeAction;
        final Object toSend;
        final long size;
        final ChannelPromise promise;

        private ToSend(long l2, Object object, long l3, ChannelPromise channelPromise) {
            this.relativeTimeAction = l2;
            this.toSend = object;
            this.size = l3;
            this.promise = channelPromise;
        }
    }

    static final class PerChannel {
        ArrayDeque<ToSend> messagesQueue;
        long queueSize;
        long lastWriteTimestamp;
        long lastReadTimestamp;

        private PerChannel() {
        }
    }
}

