/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.timeout;

import XdepsXdatabricksX240X9088.io.netty.handler.timeout.WriteTimeoutException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public class WriteTimeoutHandler
extends ChannelOutboundHandlerAdapter {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long timeoutNanos;
    private WriteTimeoutTask lastTask;
    private boolean closed;

    public WriteTimeoutHandler(int n2) {
        this(n2, TimeUnit.SECONDS);
    }

    public WriteTimeoutHandler(long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull((Object)((Object)timeUnit), (String)"unit");
        this.timeoutNanos = l2 <= 0L ? 0L : Math.max(timeUnit.toNanos(l2), MIN_TIMEOUT_NANOS);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (this.timeoutNanos > 0L) {
            channelPromise = channelPromise.unvoid();
            this.scheduleTimeout(channelHandlerContext, channelPromise);
        }
        channelHandlerContext.write(object, channelPromise);
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        assert (channelHandlerContext.executor().inEventLoop());
        WriteTimeoutTask writeTimeoutTask = this.lastTask;
        this.lastTask = null;
        while (writeTimeoutTask != null) {
            assert (writeTimeoutTask.ctx.executor().inEventLoop());
            writeTimeoutTask.scheduledFuture.cancel(false);
            WriteTimeoutTask writeTimeoutTask2 = writeTimeoutTask.prev;
            writeTimeoutTask.prev = null;
            writeTimeoutTask.next = null;
            writeTimeoutTask = writeTimeoutTask2;
        }
    }

    private void scheduleTimeout(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        WriteTimeoutTask writeTimeoutTask = new WriteTimeoutTask(channelHandlerContext, channelPromise);
        writeTimeoutTask.scheduledFuture = channelHandlerContext.executor().schedule((Runnable)writeTimeoutTask, this.timeoutNanos, TimeUnit.NANOSECONDS);
        if (!writeTimeoutTask.scheduledFuture.isDone()) {
            this.addWriteTimeoutTask(writeTimeoutTask);
            channelPromise.addListener((GenericFutureListener)writeTimeoutTask);
        }
    }

    private void addWriteTimeoutTask(WriteTimeoutTask writeTimeoutTask) {
        assert (writeTimeoutTask.ctx.executor().inEventLoop());
        if (this.lastTask != null) {
            this.lastTask.next = writeTimeoutTask;
            writeTimeoutTask.prev = this.lastTask;
        }
        this.lastTask = writeTimeoutTask;
    }

    private void removeWriteTimeoutTask(WriteTimeoutTask writeTimeoutTask) {
        assert (writeTimeoutTask.ctx.executor().inEventLoop());
        if (writeTimeoutTask == this.lastTask) {
            assert (writeTimeoutTask.next == null);
            this.lastTask = this.lastTask.prev;
            if (this.lastTask != null) {
                this.lastTask.next = null;
            }
        } else {
            if (writeTimeoutTask.prev == null && writeTimeoutTask.next == null) {
                return;
            }
            if (writeTimeoutTask.prev == null) {
                writeTimeoutTask.next.prev = null;
            } else {
                writeTimeoutTask.prev.next = writeTimeoutTask.next;
                writeTimeoutTask.next.prev = writeTimeoutTask.prev;
            }
        }
        writeTimeoutTask.prev = null;
        writeTimeoutTask.next = null;
    }

    protected void writeTimedOut(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (!this.closed) {
            channelHandlerContext.fireExceptionCaught((Throwable)((Object)WriteTimeoutException.INSTANCE));
            channelHandlerContext.close();
            this.closed = true;
        }
    }

    final class WriteTimeoutTask
    implements ChannelFutureListener,
    Runnable {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;
        WriteTimeoutTask prev;
        WriteTimeoutTask next;
        Future<?> scheduledFuture;

        WriteTimeoutTask(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
            this.ctx = channelHandlerContext;
            this.promise = channelPromise;
        }

        @Override
        public void run() {
            if (!this.promise.isDone()) {
                try {
                    WriteTimeoutHandler.this.writeTimedOut(this.ctx);
                }
                catch (Throwable throwable) {
                    this.ctx.fireExceptionCaught(throwable);
                }
            }
            WriteTimeoutHandler.this.removeWriteTimeoutTask(this);
        }

        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            this.scheduledFuture.cancel(false);
            if (this.ctx.executor().inEventLoop()) {
                WriteTimeoutHandler.this.removeWriteTimeoutTask(this);
            } else {
                assert (this.promise.isDone());
                this.ctx.executor().execute((Runnable)this);
            }
        }
    }
}

