/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.stream;

import XdepsXdatabricksX240X9088.io.netty.handler.stream.ChunkedInput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.ObjectUtil;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ChunkedStream
implements ChunkedInput<ByteBuf> {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final PushbackInputStream in;
    private final int chunkSize;
    private long offset;
    private boolean closed;

    public ChunkedStream(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public ChunkedStream(InputStream inputStream, int n2) {
        ObjectUtil.checkNotNull((Object)inputStream, (String)"in");
        ObjectUtil.checkPositive((int)n2, (String)"chunkSize");
        this.in = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        this.chunkSize = n2;
    }

    public long transferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        if (this.closed) {
            return true;
        }
        if (this.in.available() > 0) {
            return false;
        }
        int n2 = this.in.read();
        if (n2 < 0) {
            return true;
        }
        this.in.unread(n2);
        return false;
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        this.in.close();
    }

    @Override
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        int n2 = this.in.available();
        int n3 = n2 <= 0 ? this.chunkSize : Math.min(this.chunkSize, this.in.available());
        boolean bl2 = true;
        ByteBuf byteBuf = byteBufAllocator.buffer(n3);
        try {
            int n4 = byteBuf.writeBytes((InputStream)this.in, n3);
            if (n4 < 0) {
                ByteBuf byteBuf2 = null;
                return byteBuf2;
            }
            this.offset += (long)n4;
            bl2 = false;
            ByteBuf byteBuf3 = byteBuf;
            return byteBuf3;
        }
        finally {
            if (bl2) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long progress() {
        return this.offset;
    }
}

