/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.stream;

import XdepsXdatabricksX240X9088.io.netty.handler.stream.ChunkedInput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ChunkedNioStream
implements ChunkedInput<ByteBuf> {
    private final ReadableByteChannel in;
    private final int chunkSize;
    private long offset;
    private final ByteBuffer byteBuffer;

    public ChunkedNioStream(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, 8192);
    }

    public ChunkedNioStream(ReadableByteChannel readableByteChannel, int n2) {
        this.in = (ReadableByteChannel)ObjectUtil.checkNotNull((Object)readableByteChannel, (String)"in");
        this.chunkSize = ObjectUtil.checkPositive((int)n2, (String)"chunkSize");
        this.byteBuffer = ByteBuffer.allocate(n2);
    }

    public long transferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        if (this.byteBuffer.position() > 0) {
            return false;
        }
        if (this.in.isOpen()) {
            int n2 = this.in.read(this.byteBuffer);
            if (n2 < 0) {
                return true;
            }
            this.offset += (long)n2;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws Exception {
        this.in.close();
    }

    @Override
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        int n2;
        if (this.isEndOfInput()) {
            return null;
        }
        int n3 = this.byteBuffer.position();
        while ((n2 = this.in.read(this.byteBuffer)) >= 0) {
            this.offset += (long)n2;
            if ((n3 += n2) != this.chunkSize) continue;
            break;
        }
        this.byteBuffer.flip();
        n2 = 1;
        ByteBuf byteBuf = byteBufAllocator.buffer(this.byteBuffer.remaining());
        try {
            byteBuf.writeBytes(this.byteBuffer);
            this.byteBuffer.clear();
            n2 = 0;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (n2 != 0) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long progress() {
        return this.offset;
    }
}

