/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.stream;

import XdepsXdatabricksX240X9088.io.netty.handler.stream.ChunkedInput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ChunkedFile
implements ChunkedInput<ByteBuf> {
    private final RandomAccessFile file;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    public ChunkedFile(File file) throws IOException {
        this(file, 8192);
    }

    public ChunkedFile(File file, int n2) throws IOException {
        this(new RandomAccessFile(file, "r"), n2);
    }

    public ChunkedFile(RandomAccessFile randomAccessFile) throws IOException {
        this(randomAccessFile, 8192);
    }

    public ChunkedFile(RandomAccessFile randomAccessFile, int n2) throws IOException {
        this(randomAccessFile, 0L, randomAccessFile.length(), n2);
    }

    public ChunkedFile(RandomAccessFile randomAccessFile, long l2, long l3, int n2) throws IOException {
        ObjectUtil.checkNotNull((Object)randomAccessFile, (String)"file");
        ObjectUtil.checkPositiveOrZero((long)l2, (String)"offset");
        ObjectUtil.checkPositiveOrZero((long)l3, (String)"length");
        ObjectUtil.checkPositive((int)n2, (String)"chunkSize");
        this.file = randomAccessFile;
        this.offset = this.startOffset = l2;
        this.endOffset = l2 + l3;
        this.chunkSize = n2;
        randomAccessFile.seek(l2);
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.offset >= this.endOffset || !this.file.getChannel().isOpen();
    }

    @Override
    public void close() throws Exception {
        this.file.close();
    }

    @Override
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        long l2 = this.offset;
        if (l2 >= this.endOffset) {
            return null;
        }
        int n2 = (int)Math.min((long)this.chunkSize, this.endOffset - l2);
        ByteBuf byteBuf = byteBufAllocator.heapBuffer(n2);
        boolean bl2 = true;
        try {
            this.file.readFully(byteBuf.array(), byteBuf.arrayOffset(), n2);
            byteBuf.writerIndex(n2);
            this.offset = l2 + (long)n2;
            bl2 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl2) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public long progress() {
        return this.offset - this.startOffset;
    }
}

