/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ApplicationProtocolConfig;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.BouncyCastlePemReader;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.CipherSuiteFilter;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ClientAuth;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkSslClientContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkSslServerContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSsl;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslClientContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslServerContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.PemReader;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ReferenceCountedOpenSslServerContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslContextOption;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslHandler;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslProvider;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.util.AttributeMap;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;

public abstract class SslContext {
    static final String ALIAS = "key";
    static final CertificateFactory X509_CERT_FACTORY;
    private final boolean startTls;
    private final AttributeMap attributes = new DefaultAttributeMap();
    private static final String OID_PKCS5_PBES2 = "1.2.840.113549.1.5.13";
    private static final String PBES2 = "PBES2";

    public static SslProvider defaultServerProvider() {
        return SslContext.defaultProvider();
    }

    public static SslProvider defaultClientProvider() {
        return SslContext.defaultProvider();
    }

    private static SslProvider defaultProvider() {
        if (OpenSsl.isAvailable()) {
            return SslProvider.OPENSSL;
        }
        return SslProvider.JDK;
    }

    public static SslContext newServerContext(File file, File file2) throws SSLException {
        return SslContext.newServerContext(file, file2, null);
    }

    public static SslContext newServerContext(File file, File file2, String string) throws SSLException {
        return SslContext.newServerContext(null, file, file2, string);
    }

    public static SslContext newServerContext(File file, File file2, String string, Iterable<String> iterable, Iterable<String> iterable2, long l2, long l3) throws SSLException {
        return SslContext.newServerContext(null, file, file2, string, iterable, iterable2, l2, l3);
    }

    public static SslContext newServerContext(File file, File file2, String string, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) throws SSLException {
        return SslContext.newServerContext(null, file, file2, string, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
    }

    public static SslContext newServerContext(SslProvider sslProvider, File file, File file2) throws SSLException {
        return SslContext.newServerContext(sslProvider, file, file2, null);
    }

    public static SslContext newServerContext(SslProvider sslProvider, File file, File file2, String string) throws SSLException {
        return SslContext.newServerContext(sslProvider, file, file2, string, null, IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    public static SslContext newServerContext(SslProvider sslProvider, File file, File file2, String string, Iterable<String> iterable, Iterable<String> iterable2, long l2, long l3) throws SSLException {
        return SslContext.newServerContext(sslProvider, file, file2, string, iterable, IdentityCipherSuiteFilter.INSTANCE, SslContext.toApplicationProtocolConfig(iterable2), l2, l3);
    }

    public static SslContext newServerContext(SslProvider sslProvider, File file, File file2, String string, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, Iterable<String> iterable2, long l2, long l3) throws SSLException {
        return SslContext.newServerContext(sslProvider, null, trustManagerFactory, file, file2, string, null, iterable, IdentityCipherSuiteFilter.INSTANCE, SslContext.toApplicationProtocolConfig(iterable2), l2, l3);
    }

    public static SslContext newServerContext(SslProvider sslProvider, File file, File file2, String string, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) throws SSLException {
        return SslContext.newServerContext(sslProvider, null, null, file, file2, string, null, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, KeyStore.getDefaultType());
    }

    public static SslContext newServerContext(SslProvider sslProvider, File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) throws SSLException {
        return SslContext.newServerContext(sslProvider, file, trustManagerFactory, file2, file3, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, KeyStore.getDefaultType());
    }

    static SslContext newServerContext(SslProvider sslProvider, File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, String string2) throws SSLException {
        try {
            return SslContext.newServerContextInternal(sslProvider, null, SslContext.toX509Certificates(file), trustManagerFactory, SslContext.toX509Certificates(file2), SslContext.toPrivateKey(file3, string), string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, ClientAuth.NONE, null, false, false, string2, new Map.Entry[0]);
        }
        catch (Exception exception) {
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException("failed to initialize the server-side SSL context", exception);
        }
    }

    static SslContext newServerContextInternal(SslProvider sslProvider, Provider provider, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3, String string2, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        if (sslProvider == null) {
            sslProvider = SslContext.defaultServerProvider();
        }
        switch (sslProvider) {
            case JDK: {
                if (bl3) {
                    throw new IllegalArgumentException("OCSP is not supported with this SslProvider: " + (Object)((Object)sslProvider));
                }
                return new JdkSslServerContext(provider, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, clientAuth, stringArray, bl2, string2);
            }
            case OPENSSL: {
                SslContext.verifyNullSslContextProvider(sslProvider, provider);
                return new OpenSslServerContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, clientAuth, stringArray, bl2, bl3, string2, entryArray);
            }
            case OPENSSL_REFCNT: {
                SslContext.verifyNullSslContextProvider(sslProvider, provider);
                return new ReferenceCountedOpenSslServerContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, clientAuth, stringArray, bl2, bl3, string2, entryArray);
            }
        }
        throw new Error(sslProvider.toString());
    }

    private static void verifyNullSslContextProvider(SslProvider sslProvider, Provider provider) {
        if (provider != null) {
            throw new IllegalArgumentException("Java Security Provider unsupported for SslProvider: " + (Object)((Object)sslProvider));
        }
    }

    public static SslContext newClientContext() throws SSLException {
        return SslContext.newClientContext(null, null, null);
    }

    public static SslContext newClientContext(File file) throws SSLException {
        return SslContext.newClientContext(null, file);
    }

    public static SslContext newClientContext(TrustManagerFactory trustManagerFactory) throws SSLException {
        return SslContext.newClientContext(null, null, trustManagerFactory);
    }

    public static SslContext newClientContext(File file, TrustManagerFactory trustManagerFactory) throws SSLException {
        return SslContext.newClientContext(null, file, trustManagerFactory);
    }

    public static SslContext newClientContext(File file, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, Iterable<String> iterable2, long l2, long l3) throws SSLException {
        return SslContext.newClientContext(null, file, trustManagerFactory, iterable, iterable2, l2, l3);
    }

    public static SslContext newClientContext(File file, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) throws SSLException {
        return SslContext.newClientContext(null, file, trustManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
    }

    public static SslContext newClientContext(SslProvider sslProvider) throws SSLException {
        return SslContext.newClientContext(sslProvider, null, null);
    }

    public static SslContext newClientContext(SslProvider sslProvider, File file) throws SSLException {
        return SslContext.newClientContext(sslProvider, file, null);
    }

    public static SslContext newClientContext(SslProvider sslProvider, TrustManagerFactory trustManagerFactory) throws SSLException {
        return SslContext.newClientContext(sslProvider, null, trustManagerFactory);
    }

    public static SslContext newClientContext(SslProvider sslProvider, File file, TrustManagerFactory trustManagerFactory) throws SSLException {
        return SslContext.newClientContext(sslProvider, file, trustManagerFactory, null, IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    public static SslContext newClientContext(SslProvider sslProvider, File file, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, Iterable<String> iterable2, long l2, long l3) throws SSLException {
        return SslContext.newClientContext(sslProvider, file, trustManagerFactory, null, null, null, null, iterable, IdentityCipherSuiteFilter.INSTANCE, SslContext.toApplicationProtocolConfig(iterable2), l2, l3);
    }

    public static SslContext newClientContext(SslProvider sslProvider, File file, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) throws SSLException {
        return SslContext.newClientContext(sslProvider, file, trustManagerFactory, null, null, null, null, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
    }

    public static SslContext newClientContext(SslProvider sslProvider, File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) throws SSLException {
        try {
            return SslContext.newClientContextInternal(sslProvider, null, SslContext.toX509Certificates(file), trustManagerFactory, SslContext.toX509Certificates(file2), SslContext.toPrivateKey(file3, string), string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, null, l2, l3, false, KeyStore.getDefaultType(), new Map.Entry[0]);
        }
        catch (Exception exception) {
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException("failed to initialize the client-side SSL context", exception);
        }
    }

    static SslContext newClientContextInternal(SslProvider sslProvider, Provider provider, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, String[] stringArray, long l2, long l3, boolean bl2, String string2, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        if (sslProvider == null) {
            sslProvider = SslContext.defaultClientProvider();
        }
        switch (sslProvider) {
            case JDK: {
                if (bl2) {
                    throw new IllegalArgumentException("OCSP is not supported with this SslProvider: " + (Object)((Object)sslProvider));
                }
                return new JdkSslClientContext(provider, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, stringArray, l2, l3, string2);
            }
            case OPENSSL: {
                SslContext.verifyNullSslContextProvider(sslProvider, provider);
                OpenSsl.ensureAvailability();
                return new OpenSslClientContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, stringArray, l2, l3, bl2, string2, entryArray);
            }
            case OPENSSL_REFCNT: {
                SslContext.verifyNullSslContextProvider(sslProvider, provider);
                OpenSsl.ensureAvailability();
                return new ReferenceCountedOpenSslClientContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, stringArray, l2, l3, bl2, string2, entryArray);
            }
        }
        throw new Error(sslProvider.toString());
    }

    static ApplicationProtocolConfig toApplicationProtocolConfig(Iterable<String> iterable) {
        ApplicationProtocolConfig applicationProtocolConfig = iterable == null ? ApplicationProtocolConfig.DISABLED : new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN_AND_ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, iterable);
        return applicationProtocolConfig;
    }

    protected SslContext() {
        this(false);
    }

    protected SslContext(boolean bl2) {
        this.startTls = bl2;
    }

    public final AttributeMap attributes() {
        return this.attributes;
    }

    public final boolean isServer() {
        return !this.isClient();
    }

    public abstract boolean isClient();

    public abstract List<String> cipherSuites();

    public long sessionCacheSize() {
        return this.sessionContext().getSessionCacheSize();
    }

    public long sessionTimeout() {
        return this.sessionContext().getSessionTimeout();
    }

    public final List<String> nextProtocols() {
        return this.applicationProtocolNegotiator().protocols();
    }

    public abstract ApplicationProtocolNegotiator applicationProtocolNegotiator();

    public abstract SSLEngine newEngine(ByteBufAllocator var1);

    public abstract SSLEngine newEngine(ByteBufAllocator var1, String var2, int var3);

    public abstract SSLSessionContext sessionContext();

    public final SslHandler newHandler(ByteBufAllocator byteBufAllocator) {
        return this.newHandler(byteBufAllocator, this.startTls);
    }

    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl2) {
        return new SslHandler(this.newEngine(byteBufAllocator), bl2);
    }

    public SslHandler newHandler(ByteBufAllocator byteBufAllocator, Executor executor) {
        return this.newHandler(byteBufAllocator, this.startTls, executor);
    }

    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl2, Executor executor) {
        return new SslHandler(this.newEngine(byteBufAllocator), bl2, executor);
    }

    public final SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n2) {
        return this.newHandler(byteBufAllocator, string, n2, this.startTls);
    }

    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2) {
        return new SslHandler(this.newEngine(byteBufAllocator, string, n2), bl2);
    }

    public SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n2, Executor executor) {
        return this.newHandler(byteBufAllocator, string, n2, this.startTls, executor);
    }

    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2, Executor executor) {
        return new SslHandler(this.newEngine(byteBufAllocator, string, n2), bl2, executor);
    }

    protected static PKCS8EncodedKeySpec generateKeySpec(char[] cArray, byte[] byArray) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (cArray == null) {
            return new PKCS8EncodedKeySpec(byArray);
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
        String string = SslContext.getPBEAlgorithm(encryptedPrivateKeyInfo);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        Cipher cipher = Cipher.getInstance(string);
        cipher.init(2, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
        return encryptedPrivateKeyInfo.getKeySpec(cipher);
    }

    private static String getPBEAlgorithm(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        AlgorithmParameters algorithmParameters = encryptedPrivateKeyInfo.getAlgParameters();
        String string = encryptedPrivateKeyInfo.getAlgName();
        if (PlatformDependent.javaVersion() >= 8 && algorithmParameters != null && (OID_PKCS5_PBES2.equals(string) || PBES2.equals(string))) {
            return algorithmParameters.toString();
        }
        return encryptedPrivateKeyInfo.getAlgName();
    }

    protected static KeyStore buildKeyStore(X509Certificate[] x509CertificateArray, PrivateKey privateKey, char[] cArray, String string) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (string == null) {
            string = KeyStore.getDefaultType();
        }
        KeyStore keyStore = KeyStore.getInstance(string);
        keyStore.load(null, null);
        keyStore.setKeyEntry(ALIAS, privateKey, cArray, x509CertificateArray);
        return keyStore;
    }

    protected static PrivateKey toPrivateKey(File file, String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        return SslContext.toPrivateKey(file, string, true);
    }

    static PrivateKey toPrivateKey(File file, String string, boolean bl2) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        PrivateKey privateKey;
        if (file == null) {
            return null;
        }
        if (bl2 && BouncyCastlePemReader.isAvailable() && (privateKey = BouncyCastlePemReader.getPrivateKey(file, string)) != null) {
            return privateKey;
        }
        return SslContext.getPrivateKeyFromByteBuffer(PemReader.readPrivateKey(file), string);
    }

    protected static PrivateKey toPrivateKey(InputStream inputStream, String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        if (inputStream == null) {
            return null;
        }
        if (BouncyCastlePemReader.isAvailable()) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(0x100000);
            PrivateKey privateKey = BouncyCastlePemReader.getPrivateKey(inputStream, string);
            if (privateKey != null) {
                return privateKey;
            }
            inputStream.reset();
        }
        return SslContext.getPrivateKeyFromByteBuffer(PemReader.readPrivateKey(inputStream), string);
    }

    private static PrivateKey getPrivateKeyFromByteBuffer(ByteBuf byteBuf, String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        byte[] byArray = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(byArray).release();
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = SslContext.generateKeySpec(string == null ? null : string.toCharArray(), byArray);
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            try {
                return KeyFactory.getInstance("DSA").generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException2) {
                try {
                    return KeyFactory.getInstance("EC").generatePrivate(pKCS8EncodedKeySpec);
                }
                catch (InvalidKeySpecException invalidKeySpecException3) {
                    throw new InvalidKeySpecException("Neither RSA, DSA nor EC worked", invalidKeySpecException3);
                }
            }
        }
    }

    protected static TrustManagerFactory buildTrustManagerFactory(File file, TrustManagerFactory trustManagerFactory) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        return SslContext.buildTrustManagerFactory(file, trustManagerFactory, null);
    }

    protected static TrustManagerFactory buildTrustManagerFactory(File file, TrustManagerFactory trustManagerFactory, String string) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        X509Certificate[] x509CertificateArray = SslContext.toX509Certificates(file);
        return SslContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory, string);
    }

    protected static X509Certificate[] toX509Certificates(File file) throws CertificateException {
        if (file == null) {
            return null;
        }
        return SslContext.getCertificatesFromBuffers(PemReader.readCertificates(file));
    }

    protected static X509Certificate[] toX509Certificates(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            return null;
        }
        return SslContext.getCertificatesFromBuffers(PemReader.readCertificates(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] getCertificatesFromBuffers(ByteBuf[] byteBufArray) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate[] x509CertificateArray = new X509Certificate[byteBufArray.length];
        try {
            for (int i2 = 0; i2 < byteBufArray.length; ++i2) {
                ByteBufInputStream byteBufInputStream = new ByteBufInputStream(byteBufArray[i2], false);
                try {
                    x509CertificateArray[i2] = (X509Certificate)certificateFactory.generateCertificate((InputStream)byteBufInputStream);
                    continue;
                }
                finally {
                    try {
                        byteBufInputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
            }
        }
        finally {
            for (ByteBuf byteBuf : byteBufArray) {
                byteBuf.release();
            }
        }
        return x509CertificateArray;
    }

    protected static TrustManagerFactory buildTrustManagerFactory(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, String string) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        if (string == null) {
            string = KeyStore.getDefaultType();
        }
        KeyStore keyStore = KeyStore.getInstance(string);
        keyStore.load(null, null);
        int n2 = 1;
        for (X509Certificate x509Certificate : x509CertificateArray) {
            String string2 = Integer.toString(n2);
            keyStore.setCertificateEntry(string2, x509Certificate);
            ++n2;
        }
        if (trustManagerFactory == null) {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }

    static PrivateKey toPrivateKeyInternal(File file, String string) throws SSLException {
        try {
            return SslContext.toPrivateKey(file, string);
        }
        catch (Exception exception) {
            throw new SSLException(exception);
        }
    }

    static X509Certificate[] toX509CertificatesInternal(File file) throws SSLException {
        try {
            return SslContext.toX509Certificates(file);
        }
        catch (CertificateException certificateException) {
            throw new SSLException(certificateException);
        }
    }

    protected static KeyManagerFactory buildKeyManagerFactory(X509Certificate[] x509CertificateArray, String string, PrivateKey privateKey, String string2, KeyManagerFactory keyManagerFactory, String string3) throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException, UnrecoverableKeyException {
        if (string == null) {
            string = KeyManagerFactory.getDefaultAlgorithm();
        }
        char[] cArray = SslContext.keyStorePassword(string2);
        KeyStore keyStore = SslContext.buildKeyStore(x509CertificateArray, privateKey, cArray, string3);
        return SslContext.buildKeyManagerFactory(keyStore, string, cArray, keyManagerFactory);
    }

    static KeyManagerFactory buildKeyManagerFactory(KeyStore keyStore, String string, char[] cArray, KeyManagerFactory keyManagerFactory) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyManagerFactory == null) {
            if (string == null) {
                string = KeyManagerFactory.getDefaultAlgorithm();
            }
            keyManagerFactory = KeyManagerFactory.getInstance(string);
        }
        keyManagerFactory.init(keyStore, cArray);
        return keyManagerFactory;
    }

    static char[] keyStorePassword(String string) {
        return string == null ? EmptyArrays.EMPTY_CHARS : string.toCharArray();
    }

    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new IllegalStateException("unable to instance X.509 CertificateFactory", certificateException);
        }
    }
}

