/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.codec.ByteToMessageDecoder;
import XdepsXdatabricksX240X9088.io.netty.handler.codec.DecoderException;
import XdepsXdatabricksX240X9088.io.netty.handler.codec.TooLongFrameException;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.NotSslRecordException;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SniCompletionEvent;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;

public abstract class SslClientHelloHandler<T>
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    public static final int MAX_CLIENT_HELLO_LENGTH = 0xFFFFFF;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslClientHelloHandler.class);
    private final int maxClientHelloLength;
    private boolean handshakeFailed;
    private boolean suppressRead;
    private boolean readPending;
    private ByteBuf handshakeBuffer;

    public SslClientHelloHandler() {
        this(0xFFFFFF);
    }

    protected SslClientHelloHandler(int n2) {
        this.maxClientHelloLength = ObjectUtil.checkInRange((int)n2, (int)0, (int)0xFFFFFF, (String)"maxClientHelloLength");
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (!this.suppressRead && !this.handshakeFailed) {
            try {
                int n2;
                int n3 = byteBuf.readerIndex();
                int n4 = -1;
                block8: for (int i2 = byteBuf.readableBytes(); i2 >= 5; i2 -= n2) {
                    short s2 = byteBuf.getUnsignedByte(n3);
                    switch (s2) {
                        case 20: 
                        case 21: {
                            int n5 = SslUtils.getEncryptedPacketLength(byteBuf, n3);
                            if (n5 == -2) {
                                this.handshakeFailed = true;
                                NotSslRecordException notSslRecordException = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump((ByteBuf)byteBuf));
                                byteBuf.skipBytes(byteBuf.readableBytes());
                                channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(notSslRecordException));
                                SslUtils.handleHandshakeFailure(channelHandlerContext, notSslRecordException, true);
                                throw notSslRecordException;
                            }
                            if (n5 == -1) {
                                return;
                            }
                            this.select(channelHandlerContext, null);
                            return;
                        }
                        case 22: {
                            short s3 = byteBuf.getUnsignedByte(n3 + 1);
                            if (s3 != 3) break;
                            n2 = byteBuf.getUnsignedShort(n3 + 3) + 5;
                            if (i2 < n2) {
                                return;
                            }
                            if (n2 == 5) {
                                this.select(channelHandlerContext, null);
                                return;
                            }
                            int n6 = n3 + n2;
                            if (n4 == -1) {
                                if (n3 + 4 > n6) {
                                    return;
                                }
                                short s4 = byteBuf.getUnsignedByte(n3 + 5);
                                if (s4 != 1) {
                                    this.select(channelHandlerContext, null);
                                    return;
                                }
                                n4 = byteBuf.getUnsignedMedium(n3 + 5 + 1);
                                if (n4 > this.maxClientHelloLength && this.maxClientHelloLength != 0) {
                                    TooLongFrameException tooLongFrameException = new TooLongFrameException("ClientHello length exceeds " + this.maxClientHelloLength + ": " + n4);
                                    byteBuf.skipBytes(byteBuf.readableBytes());
                                    channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(tooLongFrameException));
                                    SslUtils.handleHandshakeFailure(channelHandlerContext, tooLongFrameException, true);
                                    throw tooLongFrameException;
                                }
                                n3 += 4;
                                if (n4 + 4 + 5 <= (n2 -= 4)) {
                                    this.select(channelHandlerContext, byteBuf.retainedSlice(n3 += 5, n4));
                                    return;
                                }
                                if (this.handshakeBuffer == null) {
                                    this.handshakeBuffer = channelHandlerContext.alloc().buffer(n4);
                                } else {
                                    this.handshakeBuffer.clear();
                                }
                            }
                            this.handshakeBuffer.writeBytes(byteBuf, n3 + 5, n2 - 5);
                            n3 += n2;
                            if (n4 > this.handshakeBuffer.readableBytes()) continue block8;
                            ByteBuf byteBuf2 = this.handshakeBuffer.setIndex(0, n4);
                            this.handshakeBuffer = null;
                            this.select(channelHandlerContext, byteBuf2);
                            return;
                        }
                    }
                    this.select(channelHandlerContext, null);
                    return;
                }
            }
            catch (NotSslRecordException notSslRecordException) {
                throw notSslRecordException;
            }
            catch (TooLongFrameException tooLongFrameException) {
                throw tooLongFrameException;
            }
            catch (Exception exception) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump((ByteBuf)byteBuf), (Throwable)exception);
                }
                this.select(channelHandlerContext, null);
            }
        }
    }

    private void releaseHandshakeBuffer() {
        SslClientHelloHandler.releaseIfNotNull(this.handshakeBuffer);
        this.handshakeBuffer = null;
    }

    private static void releaseIfNotNull(ByteBuf byteBuf) {
        if (byteBuf != null) {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void select(final ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Exception {
        try {
            Future<T> future = this.lookup(channelHandlerContext, byteBuf);
            if (future.isDone()) {
                this.onLookupComplete(channelHandlerContext, future);
            } else {
                this.suppressRead = true;
                final ByteBuf byteBuf2 = byteBuf;
                future.addListener((GenericFutureListener)new FutureListener<T>(){

                    public void operationComplete(Future<T> future) {
                        SslClientHelloHandler.releaseIfNotNull(byteBuf2);
                        try {
                            SslClientHelloHandler.this.suppressRead = false;
                            try {
                                SslClientHelloHandler.this.onLookupComplete(channelHandlerContext, future);
                            }
                            catch (DecoderException decoderException) {
                                channelHandlerContext.fireExceptionCaught((Throwable)decoderException);
                            }
                            catch (Exception exception) {
                                channelHandlerContext.fireExceptionCaught((Throwable)new DecoderException((Throwable)exception));
                            }
                            catch (Throwable throwable) {
                                channelHandlerContext.fireExceptionCaught(throwable);
                            }
                        }
                        finally {
                            if (SslClientHelloHandler.this.readPending) {
                                SslClientHelloHandler.this.readPending = false;
                                channelHandlerContext.read();
                            }
                        }
                    }
                });
                byteBuf = null;
            }
        }
        catch (Throwable throwable) {
            PlatformDependent.throwException((Throwable)throwable);
        }
        finally {
            SslClientHelloHandler.releaseIfNotNull(byteBuf);
        }
    }

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.releaseHandshakeBuffer();
        super.handlerRemoved0(channelHandlerContext);
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, ByteBuf var2) throws Exception;

    protected abstract void onLookupComplete(ChannelHandlerContext var1, Future<T> var2) throws Exception;

    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.suppressRead) {
            this.readPending = true;
        } else {
            channelHandlerContext.read();
        }
    }

    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.disconnect(channelPromise);
    }

    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.close(channelPromise);
    }

    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.deregister(channelPromise);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.write(object, channelPromise);
    }

    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.flush();
    }
}

