/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.codec.DecoderException;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.AbstractSniHandler;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslHandler;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AsyncMapping;
import io.netty.util.DomainNameMapping;
import io.netty.util.Mapping;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;

public class SniHandler
extends AbstractSniHandler<SslContext> {
    private static final Selection EMPTY_SELECTION = new Selection(null, null);
    protected final AsyncMapping<String, SslContext> mapping;
    private volatile Selection selection = EMPTY_SELECTION;

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping) {
        this(new AsyncMappingAdapter(mapping));
    }

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping, int n2, long l2) {
        this(new AsyncMappingAdapter(mapping), n2, l2);
    }

    public SniHandler(DomainNameMapping<? extends SslContext> domainNameMapping) {
        this((Mapping<? super String, ? extends SslContext>)domainNameMapping);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> asyncMapping) {
        this(asyncMapping, 0, 0L);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> asyncMapping, int n2, long l2) {
        super(n2, l2);
        this.mapping = (AsyncMapping)ObjectUtil.checkNotNull(asyncMapping, (String)"mapping");
    }

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping, long l2) {
        this(new AsyncMappingAdapter(mapping), l2);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> asyncMapping, long l2) {
        this(asyncMapping, 0, l2);
    }

    public String hostname() {
        return this.selection.hostname;
    }

    public SslContext sslContext() {
        return this.selection.context;
    }

    @Override
    protected Future<SslContext> lookup(ChannelHandlerContext channelHandlerContext, String string) throws Exception {
        return this.mapping.map((Object)string, channelHandlerContext.executor().newPromise());
    }

    @Override
    protected final void onLookupComplete(ChannelHandlerContext channelHandlerContext, String string, Future<SslContext> future) throws Exception {
        if (!future.isSuccess()) {
            Throwable throwable = future.cause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new DecoderException("failed to get the SslContext for " + string, throwable);
        }
        SslContext sslContext = (SslContext)future.getNow();
        this.selection = new Selection(sslContext, string);
        try {
            this.replaceHandler(channelHandlerContext, string, sslContext);
        }
        catch (Throwable throwable) {
            this.selection = EMPTY_SELECTION;
            PlatformDependent.throwException((Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceHandler(ChannelHandlerContext channelHandlerContext, String string, SslContext sslContext) throws Exception {
        SslHandler sslHandler = null;
        try {
            sslHandler = this.newSslHandler(sslContext, channelHandlerContext.alloc());
            channelHandlerContext.pipeline().replace((ChannelHandler)this, SslHandler.class.getName(), (ChannelHandler)sslHandler);
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease((Object)sslHandler.engine());
            }
        }
    }

    protected SslHandler newSslHandler(SslContext sslContext, ByteBufAllocator byteBufAllocator) {
        SslHandler sslHandler = sslContext.newHandler(byteBufAllocator);
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        return sslHandler;
    }

    static final class Selection {
        final SslContext context;
        final String hostname;

        Selection(SslContext sslContext, String string) {
            this.context = sslContext;
            this.hostname = string;
        }
    }

    static final class AsyncMappingAdapter
    implements AsyncMapping<String, SslContext> {
        private final Mapping<? super String, ? extends SslContext> mapping;

        private AsyncMappingAdapter(Mapping<? super String, ? extends SslContext> mapping) {
            this.mapping = (Mapping)ObjectUtil.checkNotNull(mapping, (String)"mapping");
        }

        public Future<SslContext> map(String string, Promise<SslContext> promise) {
            SslContext sslContext;
            try {
                sslContext = (SslContext)this.mapping.map((Object)string);
            }
            catch (Throwable throwable) {
                return promise.setFailure(throwable);
            }
            return promise.setSuccess((Object)sslContext);
        }
    }
}

