/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslSession;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslSessionCache;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslSessionId;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslSessionStats;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslSessionTicketKey;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.internal.tcnative.SSL;
import io.netty.internal.tcnative.SSLContext;
import io.netty.internal.tcnative.SSLSessionCache;
import io.netty.internal.tcnative.SessionTicketKey;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

public abstract class OpenSslSessionContext
implements SSLSessionContext {
    private final OpenSslSessionStats stats;
    private final OpenSslKeyMaterialProvider provider;
    final ReferenceCountedOpenSslContext context;
    private final OpenSslSessionCache sessionCache;
    private final long mask;

    OpenSslSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, OpenSslKeyMaterialProvider openSslKeyMaterialProvider, long l2, OpenSslSessionCache openSslSessionCache) {
        this.context = referenceCountedOpenSslContext;
        this.provider = openSslKeyMaterialProvider;
        this.mask = l2;
        this.stats = new OpenSslSessionStats(referenceCountedOpenSslContext);
        this.sessionCache = openSslSessionCache;
        SSLContext.setSSLSessionCache((long)referenceCountedOpenSslContext.ctx, (SSLSessionCache)openSslSessionCache);
    }

    final boolean useKeyManager() {
        return this.provider != null;
    }

    @Override
    public void setSessionCacheSize(int n2) {
        ObjectUtil.checkPositiveOrZero((int)n2, (String)"size");
        this.sessionCache.setSessionCacheSize(n2);
    }

    @Override
    public int getSessionCacheSize() {
        return this.sessionCache.getSessionCacheSize();
    }

    @Override
    public void setSessionTimeout(int n2) {
        ObjectUtil.checkPositiveOrZero((int)n2, (String)"seconds");
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setSessionCacheTimeout((long)this.context.ctx, (long)n2);
            this.sessionCache.setSessionTimeout(n2);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionCache.getSessionTimeout();
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        return this.sessionCache.getSession(new OpenSslSessionId(byArray));
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return new Enumeration<byte[]>(){
            private final Iterator<OpenSslSessionId> ids;
            {
                this.ids = OpenSslSessionContext.this.sessionCache.getIds().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.ids.hasNext();
            }

            @Override
            public byte[] nextElement() {
                return this.ids.next().cloneBytes();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicketKeys(byte[] byArray) {
        if (byArray.length % 48 != 0) {
            throw new IllegalArgumentException("keys.length % 48 != 0");
        }
        SessionTicketKey[] sessionTicketKeyArray = new SessionTicketKey[byArray.length / 48];
        int n2 = 0;
        for (int i2 = 0; i2 < sessionTicketKeyArray.length; ++i2) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n2, 16);
            byte[] byArray3 = Arrays.copyOfRange(byArray, n2 += 16, 16);
            byte[] byArray4 = Arrays.copyOfRange(byArray, n2, 16);
            n2 += 16;
            sessionTicketKeyArray[i2 += 16] = new SessionTicketKey(byArray2, byArray3, byArray4);
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.clearOptions((long)this.context.ctx, (int)SSL.SSL_OP_NO_TICKET);
            SSLContext.setSessionTicketKeys((long)this.context.ctx, (SessionTicketKey[])sessionTicketKeyArray);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicketKeys(OpenSslSessionTicketKey ... openSslSessionTicketKeyArray) {
        ObjectUtil.checkNotNull((Object)openSslSessionTicketKeyArray, (String)"keys");
        SessionTicketKey[] sessionTicketKeyArray = new SessionTicketKey[openSslSessionTicketKeyArray.length];
        for (int i2 = 0; i2 < sessionTicketKeyArray.length; ++i2) {
            sessionTicketKeyArray[i2] = openSslSessionTicketKeyArray[i2].key;
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.clearOptions((long)this.context.ctx, (int)SSL.SSL_OP_NO_TICKET);
            if (sessionTicketKeyArray.length > 0) {
                SSLContext.setSessionTicketKeys((long)this.context.ctx, (SessionTicketKey[])sessionTicketKeyArray);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionCacheEnabled(boolean bl2) {
        long l2 = bl2 ? this.mask | SSL.SSL_SESS_CACHE_NO_INTERNAL_LOOKUP | SSL.SSL_SESS_CACHE_NO_INTERNAL_STORE : SSL.SSL_SESS_CACHE_OFF;
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setSessionCacheMode((long)this.context.ctx, (long)l2);
            if (!bl2) {
                this.sessionCache.clear();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isSessionCacheEnabled() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            boolean bl2 = (SSLContext.getSessionCacheMode((long)this.context.ctx) & this.mask) != 0L;
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    public OpenSslSessionStats stats() {
        return this.stats;
    }

    final void removeFromCache(OpenSslSessionId openSslSessionId) {
        this.sessionCache.removeSessionWithId(openSslSessionId);
    }

    final boolean isInCache(OpenSslSessionId openSslSessionId) {
        return this.sessionCache.containsSessionWithId(openSslSessionId);
    }

    boolean setSessionFromCache(long l2, OpenSslSession openSslSession, String string, int n2) {
        return this.sessionCache.setSession(l2, openSslSession, string, n2);
    }

    final void destroy() {
        if (this.provider != null) {
            this.provider.destroy();
        }
        this.sessionCache.clear();
    }
}

