/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslKeyMaterial;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;

final class OpenSslKeyMaterialManager {
    static final String KEY_TYPE_RSA = "RSA";
    static final String KEY_TYPE_DH_RSA = "DH_RSA";
    static final String KEY_TYPE_EC = "EC";
    static final String KEY_TYPE_EC_EC = "EC_EC";
    static final String KEY_TYPE_EC_RSA = "EC_RSA";
    private static final Map<String, String> KEY_TYPES = new HashMap<String, String>();
    private final OpenSslKeyMaterialProvider provider;

    OpenSslKeyMaterialManager(OpenSslKeyMaterialProvider openSslKeyMaterialProvider) {
        this.provider = openSslKeyMaterialProvider;
    }

    void setKeyMaterialServerSide(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) throws SSLException {
        Object[] objectArray = referenceCountedOpenSslEngine.authMethods();
        if (objectArray.length == 0) {
            throw new SSLHandshakeException("Unable to find key material");
        }
        HashSet<String> hashSet = new HashSet<String>(KEY_TYPES.size());
        for (String string : objectArray) {
            String string2;
            String string3 = KEY_TYPES.get(string);
            if (string3 == null || !hashSet.add(string3) || (string2 = this.chooseServerAlias(referenceCountedOpenSslEngine, string3)) == null) continue;
            this.setKeyMaterial(referenceCountedOpenSslEngine, string2);
            return;
        }
        throw new SSLHandshakeException("Unable to find key material for auth method(s): " + Arrays.toString(objectArray));
    }

    void setKeyMaterialClientSide(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String[] stringArray, X500Principal[] x500PrincipalArray) throws SSLException {
        String string = this.chooseClientAlias(referenceCountedOpenSslEngine, stringArray, x500PrincipalArray);
        if (string != null) {
            this.setKeyMaterial(referenceCountedOpenSslEngine, string);
        }
    }

    private void setKeyMaterial(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String string) throws SSLException {
        OpenSslKeyMaterial openSslKeyMaterial = null;
        try {
            openSslKeyMaterial = this.provider.chooseKeyMaterial(referenceCountedOpenSslEngine.alloc, string);
            if (openSslKeyMaterial == null) {
                return;
            }
            referenceCountedOpenSslEngine.setKeyMaterial(openSslKeyMaterial);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException(exception);
        }
        finally {
            if (openSslKeyMaterial != null) {
                openSslKeyMaterial.release();
            }
        }
    }

    private String chooseClientAlias(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String[] stringArray, X500Principal[] x500PrincipalArray) {
        X509KeyManager x509KeyManager = this.provider.keyManager();
        if (x509KeyManager instanceof X509ExtendedKeyManager) {
            return ((X509ExtendedKeyManager)x509KeyManager).chooseEngineClientAlias(stringArray, x500PrincipalArray, referenceCountedOpenSslEngine);
        }
        return x509KeyManager.chooseClientAlias(stringArray, x500PrincipalArray, null);
    }

    private String chooseServerAlias(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String string) {
        X509KeyManager x509KeyManager = this.provider.keyManager();
        if (x509KeyManager instanceof X509ExtendedKeyManager) {
            return ((X509ExtendedKeyManager)x509KeyManager).chooseEngineServerAlias(string, null, referenceCountedOpenSslEngine);
        }
        return x509KeyManager.chooseServerAlias(string, null, null);
    }

    static {
        KEY_TYPES.put(KEY_TYPE_RSA, KEY_TYPE_RSA);
        KEY_TYPES.put("DHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_ECDSA", KEY_TYPE_EC);
        KEY_TYPES.put("ECDH_RSA", KEY_TYPE_EC_RSA);
        KEY_TYPES.put("ECDH_ECDSA", KEY_TYPE_EC_EC);
        KEY_TYPES.put(KEY_TYPE_DH_RSA, KEY_TYPE_DH_RSA);
    }
}

