/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkSslEngine;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.conscrypt.AllocatedBuffer;
import org.conscrypt.BufferAllocator;
import org.conscrypt.Conscrypt;
import org.conscrypt.HandshakeListener;

abstract class ConscryptAlpnSslEngine
extends JdkSslEngine {
    private static final boolean USE_BUFFER_ALLOCATOR = SystemPropertyUtil.getBoolean((String)"XdepsXdatabricksX240X9088.io.netty.handler.ssl.conscrypt.useBufferAllocator", (boolean)true);

    static ConscryptAlpnSslEngine newClientEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ClientEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
    }

    static ConscryptAlpnSslEngine newServerEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ServerEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
    }

    private ConscryptAlpnSslEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, List<String> list) {
        super(sSLEngine);
        if (USE_BUFFER_ALLOCATOR) {
            Conscrypt.setBufferAllocator((SSLEngine)sSLEngine, (BufferAllocator)new BufferAllocatorAdapter(byteBufAllocator));
        }
        Conscrypt.setApplicationProtocols((SSLEngine)sSLEngine, (String[])list.toArray(EmptyArrays.EMPTY_STRINGS));
    }

    final int calculateOutNetBufSize(int n2, int n3) {
        return this.calculateSpace(n2, n3, Integer.MAX_VALUE);
    }

    final int calculateRequiredOutBufSpace(int n2, int n3) {
        return this.calculateSpace(n2, n3, Conscrypt.maxEncryptedPacketLength());
    }

    private int calculateSpace(int n2, int n3, long l2) {
        long l3 = (long)Conscrypt.maxSealOverhead((SSLEngine)this.getWrappedEngine()) * (long)n3;
        return (int)Math.min(l2, (long)n2 + l3);
    }

    final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) throws SSLException {
        return Conscrypt.unwrap((SSLEngine)this.getWrappedEngine(), (ByteBuffer[])byteBufferArray, (ByteBuffer[])byteBufferArray2);
    }

    static final class BufferAdapter
    extends AllocatedBuffer {
        private final ByteBuf nettyBuffer;
        private final ByteBuffer buffer;

        BufferAdapter(ByteBuf byteBuf) {
            this.nettyBuffer = byteBuf;
            this.buffer = byteBuf.nioBuffer(0, byteBuf.capacity());
        }

        public ByteBuffer nioBuffer() {
            return this.buffer;
        }

        public AllocatedBuffer retain() {
            this.nettyBuffer.retain();
            return this;
        }

        public AllocatedBuffer release() {
            this.nettyBuffer.release();
            return this;
        }
    }

    static final class BufferAllocatorAdapter
    extends BufferAllocator {
        private final ByteBufAllocator alloc;

        BufferAllocatorAdapter(ByteBufAllocator byteBufAllocator) {
            this.alloc = byteBufAllocator;
        }

        public AllocatedBuffer allocateDirectBuffer(int n2) {
            return new BufferAdapter(this.alloc.directBuffer(n2));
        }
    }

    static final class ServerEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector;

        ServerEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
            super(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator.protocols());
            Conscrypt.setHandshakeListener((SSLEngine)sSLEngine, (HandshakeListener)new HandshakeListener(){

                public void onHandshakeFinished() throws SSLException {
                    ServerEngine.this.selectProtocol();
                }
            });
            this.protocolSelector = (JdkApplicationProtocolNegotiator.ProtocolSelector)ObjectUtil.checkNotNull((Object)jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())), (String)"protocolSelector");
        }

        private void selectProtocol() throws SSLException {
            try {
                String string = Conscrypt.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
                this.protocolSelector.select(string != null ? Collections.singletonList(string) : Collections.emptyList());
            }
            catch (Throwable throwable) {
                throw SslUtils.toSSLHandshakeException(throwable);
            }
        }
    }

    static final class ClientEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener;

        ClientEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
            super(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator.protocols());
            Conscrypt.setHandshakeListener((SSLEngine)sSLEngine, (HandshakeListener)new HandshakeListener(){

                public void onHandshakeFinished() throws SSLException {
                    ClientEngine.this.selectProtocol();
                }
            });
            this.protocolListener = (JdkApplicationProtocolNegotiator.ProtocolSelectionListener)ObjectUtil.checkNotNull((Object)jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols()), (String)"protocolListener");
        }

        private void selectProtocol() throws SSLException {
            String string = Conscrypt.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
            try {
                this.protocolListener.selected(string);
            }
            catch (Throwable throwable) {
                throw SslUtils.toSSLHandshakeException(throwable);
            }
        }
    }
}

