/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.codec.DecoderException;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslHandler;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.RecyclableArrayList;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import javax.net.ssl.SSLException;

public abstract class ApplicationProtocolNegotiationHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ApplicationProtocolNegotiationHandler.class);
    private final String fallbackProtocol;
    private final RecyclableArrayList bufferedMessages = RecyclableArrayList.newInstance();
    private ChannelHandlerContext ctx;
    private boolean sslHandlerChecked;

    protected ApplicationProtocolNegotiationHandler(String string) {
        this.fallbackProtocol = (String)ObjectUtil.checkNotNull((Object)string, (String)"fallbackProtocol");
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
        super.handlerAdded(channelHandlerContext);
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.fireBufferedMessages();
        this.bufferedMessages.recycle();
        super.handlerRemoved(channelHandlerContext);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        this.bufferedMessages.add(object);
        if (!this.sslHandlerChecked) {
            this.sslHandlerChecked = true;
            if (channelHandlerContext.pipeline().get(SslHandler.class) == null) {
                this.removeSelfIfPresent(channelHandlerContext);
            }
        }
    }

    private void fireBufferedMessages() {
        if (!this.bufferedMessages.isEmpty()) {
            for (int i2 = 0; i2 < this.bufferedMessages.size(); ++i2) {
                this.ctx.fireChannelRead(this.bufferedMessages.get(i2));
            }
            this.ctx.fireChannelReadComplete();
            this.bufferedMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent sslHandshakeCompletionEvent = (SslHandshakeCompletionEvent)object;
            try {
                if (sslHandshakeCompletionEvent.isSuccess()) {
                    SslHandler sslHandler = (SslHandler)channelHandlerContext.pipeline().get(SslHandler.class);
                    if (sslHandler == null) {
                        throw new IllegalStateException("cannot find an SslHandler in the pipeline (required for application-level protocol negotiation)");
                    }
                    String string = sslHandler.applicationProtocol();
                    this.configurePipeline(channelHandlerContext, string != null ? string : this.fallbackProtocol);
                }
            }
            catch (Throwable throwable) {
                this.exceptionCaught(channelHandlerContext, throwable);
            }
            finally {
                if (sslHandshakeCompletionEvent.isSuccess()) {
                    this.removeSelfIfPresent(channelHandlerContext);
                }
            }
        }
        if (object instanceof ChannelInputShutdownEvent) {
            this.fireBufferedMessages();
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.fireBufferedMessages();
        super.channelInactive(channelHandlerContext);
    }

    private void removeSelfIfPresent(ChannelHandlerContext channelHandlerContext) {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        if (!channelHandlerContext.isRemoved()) {
            channelPipeline.remove((ChannelHandler)this);
        }
    }

    protected abstract void configurePipeline(ChannelHandlerContext var1, String var2) throws Exception;

    protected void handshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        logger.warn("{} TLS handshake failed:", (Object)channelHandlerContext.channel(), (Object)throwable);
        channelHandlerContext.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        Throwable throwable2;
        if (throwable instanceof DecoderException && (throwable2 = throwable.getCause()) instanceof SSLException) {
            try {
                this.handshakeFailure(channelHandlerContext, throwable2);
                return;
            }
            finally {
                this.removeSelfIfPresent(channelHandlerContext);
            }
        }
        logger.warn("{} Failed to select the application-level protocol:", (Object)channelHandlerContext.channel(), (Object)throwable);
        channelHandlerContext.fireExceptionCaught(throwable);
        channelHandlerContext.close();
    }
}

