/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SniCompletionEvent;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslClientHelloHandler;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslHandshakeTimeoutException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSniHandler<T>
extends SslClientHelloHandler<T> {
    protected final long handshakeTimeoutMillis;
    private ScheduledFuture<?> timeoutFuture;
    private String hostname;

    private static String extractSniHostname(ByteBuf byteBuf) {
        int n2 = byteBuf.readerIndex();
        int n3 = byteBuf.writerIndex();
        if (n3 - (n2 += 34) >= 6) {
            int n4;
            int n5;
            short s2 = byteBuf.getUnsignedByte(n2);
            int n6 = byteBuf.getUnsignedShort(n2 += s2 + 1);
            short s3 = byteBuf.getUnsignedByte(n2 += n6 + 2);
            n2 += s3 + 1;
            if ((n5 = (n2 += 2) + (n4 = byteBuf.getUnsignedShort(n2))) <= n3) {
                while (n5 - n2 >= 4) {
                    int n7;
                    int n8 = byteBuf.getUnsignedShort(n2);
                    n2 += 2;
                    if (n5 - (n2 += 2) < (n7 = byteBuf.getUnsignedShort(n2))) break;
                    if (n8 == 0) {
                        int n9;
                        if (n5 - (n2 += 2) < 3) break;
                        short s4 = byteBuf.getUnsignedByte(n2);
                        ++n2;
                        if (s4 != 0 || n5 - (n2 += 2) < (n9 = byteBuf.getUnsignedShort(n2))) break;
                        String string = byteBuf.toString(n2, n9, CharsetUtil.US_ASCII);
                        return string.toLowerCase(Locale.US);
                    }
                    n2 += n7;
                }
            }
        }
        return null;
    }

    protected AbstractSniHandler(long l2) {
        this(0, l2);
    }

    protected AbstractSniHandler(int n2, long l2) {
        super(n2);
        this.handshakeTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)l2, (String)"handshakeTimeoutMillis");
    }

    public AbstractSniHandler() {
        this(0, 0L);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (channelHandlerContext.channel().isActive()) {
            this.checkStartTimeout(channelHandlerContext);
        }
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.fireChannelActive();
        this.checkStartTimeout(channelHandlerContext);
    }

    private void checkStartTimeout(final ChannelHandlerContext channelHandlerContext) {
        if (this.handshakeTimeoutMillis <= 0L || this.timeoutFuture != null) {
            return;
        }
        this.timeoutFuture = channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (channelHandlerContext.channel().isActive()) {
                    SslHandshakeTimeoutException sslHandshakeTimeoutException = new SslHandshakeTimeoutException("handshake timed out after " + AbstractSniHandler.this.handshakeTimeoutMillis + "ms");
                    channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(sslHandshakeTimeoutException));
                    channelHandlerContext.close();
                }
            }
        }, this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    protected Future<T> lookup(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Exception {
        this.hostname = byteBuf == null ? null : AbstractSniHandler.extractSniHostname(byteBuf);
        return this.lookup(channelHandlerContext, this.hostname);
    }

    @Override
    protected void onLookupComplete(ChannelHandlerContext channelHandlerContext, Future<T> future) throws Exception {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        try {
            this.onLookupComplete(channelHandlerContext, this.hostname, future);
        }
        finally {
            AbstractSniHandler.fireSniCompletionEvent(channelHandlerContext, this.hostname, future);
        }
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, String var2) throws Exception;

    protected abstract void onLookupComplete(ChannelHandlerContext var1, String var2, Future<T> var3) throws Exception;

    private static void fireSniCompletionEvent(ChannelHandlerContext channelHandlerContext, String string, Future<?> future) {
        Throwable throwable = future.cause();
        if (throwable == null) {
            channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(string));
        } else {
            channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(string, throwable));
        }
    }
}

