/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ipfilter;

import XdepsXdatabricksX240X9088.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import XdepsXdatabricksX240X9088.io.netty.handler.ipfilter.IpFilterRule;
import XdepsXdatabricksX240X9088.io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final boolean acceptIfNotFound;
    private final List<IpFilterRule> rules;

    public RuleBasedIpFilter(IpFilterRule ... ipFilterRuleArray) {
        this(true, ipFilterRuleArray);
    }

    public RuleBasedIpFilter(boolean bl2, IpFilterRule ... ipFilterRuleArray) {
        ObjectUtil.checkNotNull((Object)ipFilterRuleArray, (String)"rules");
        this.acceptIfNotFound = bl2;
        this.rules = new ArrayList<IpFilterRule>(ipFilterRuleArray.length);
        for (IpFilterRule ipFilterRule : ipFilterRuleArray) {
            if (ipFilterRule == null) continue;
            this.rules.add(ipFilterRule);
        }
    }

    @Override
    protected boolean accept(ChannelHandlerContext channelHandlerContext, InetSocketAddress inetSocketAddress) throws Exception {
        for (IpFilterRule ipFilterRule : this.rules) {
            if (!ipFilterRule.matches(inetSocketAddress)) continue;
            return ipFilterRule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return this.acceptIfNotFound;
    }
}

