/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.flow;

import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;

public class FlowControlHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FlowControlHandler.class);
    private final boolean releaseMessages;
    private RecyclableArrayDeque queue;
    private ChannelConfig config;
    private boolean shouldConsume;

    public FlowControlHandler() {
        this(true);
    }

    public FlowControlHandler(boolean bl2) {
        this.releaseMessages = bl2;
    }

    boolean isQueueEmpty() {
        return this.queue == null || this.queue.isEmpty();
    }

    private void destroy() {
        if (this.queue != null) {
            if (!this.queue.isEmpty()) {
                logger.trace("Non-empty queue: {}", (Object)this.queue);
                if (this.releaseMessages) {
                    Object e2;
                    while ((e2 = this.queue.poll()) != null) {
                        ReferenceCountUtil.safeRelease(e2);
                    }
                }
            }
            this.queue.recycle();
            this.queue = null;
        }
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.config = channelHandlerContext.channel().config();
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.handlerRemoved(channelHandlerContext);
        if (!this.isQueueEmpty()) {
            this.dequeue(channelHandlerContext, this.queue.size());
        }
        this.destroy();
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.destroy();
        channelHandlerContext.fireChannelInactive();
    }

    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.dequeue(channelHandlerContext, 1) == 0) {
            this.shouldConsume = true;
            channelHandlerContext.read();
        } else if (this.config.isAutoRead()) {
            channelHandlerContext.read();
        }
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (this.queue == null) {
            this.queue = RecyclableArrayDeque.newInstance();
        }
        this.queue.offer(object);
        int n2 = this.shouldConsume ? 1 : 0;
        this.shouldConsume = false;
        this.dequeue(channelHandlerContext, n2);
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.isQueueEmpty()) {
            channelHandlerContext.fireChannelReadComplete();
        }
    }

    private int dequeue(ChannelHandlerContext channelHandlerContext, int n2) {
        Object e2;
        int n3;
        for (n3 = 0; this.queue != null && (n3 < n2 || this.config.isAutoRead()) && (e2 = this.queue.poll()) != null; ++n3) {
            channelHandlerContext.fireChannelRead(e2);
        }
        if (this.queue != null && this.queue.isEmpty()) {
            this.queue.recycle();
            this.queue = null;
            if (n3 > 0) {
                channelHandlerContext.fireChannelReadComplete();
            }
        }
        return n3;
    }

    static final class RecyclableArrayDeque
    extends ArrayDeque<Object> {
        private static final long serialVersionUID = 0L;
        private static final int DEFAULT_NUM_ELEMENTS = 2;
        private static final ObjectPool<RecyclableArrayDeque> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<RecyclableArrayDeque>(){

            public RecyclableArrayDeque newObject(ObjectPool.Handle<RecyclableArrayDeque> handle) {
                return new RecyclableArrayDeque(2, handle);
            }
        });
        private final ObjectPool.Handle<RecyclableArrayDeque> handle;

        public static RecyclableArrayDeque newInstance() {
            return (RecyclableArrayDeque)RECYCLER.get();
        }

        private RecyclableArrayDeque(int n2, ObjectPool.Handle<RecyclableArrayDeque> handle) {
            super(n2);
            this.handle = handle;
        }

        public void recycle() {
            this.clear();
            this.handle.recycle((Object)this);
        }
    }
}

