/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.address;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;

public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> addressResolverGroup) {
        this.resolverGroup = (AddressResolverGroup)ObjectUtil.checkNotNull(addressResolverGroup, (String)"resolverGroup");
    }

    public void connect(final ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        AddressResolver addressResolver = this.resolverGroup.getResolver(channelHandlerContext.executor());
        if (addressResolver.isSupported(socketAddress) && !addressResolver.isResolved(socketAddress)) {
            addressResolver.resolve(socketAddress).addListener((GenericFutureListener)new FutureListener<SocketAddress>(){

                public void operationComplete(Future<SocketAddress> future) {
                    Throwable throwable = future.cause();
                    if (throwable != null) {
                        channelPromise.setFailure(throwable);
                    } else {
                        channelHandlerContext.connect((SocketAddress)future.getNow(), socketAddress2, channelPromise);
                    }
                    channelHandlerContext.pipeline().remove((ChannelHandler)ResolveAddressHandler.this);
                }
            });
        } else {
            channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
            channelHandlerContext.pipeline().remove((ChannelHandler)this);
        }
    }
}

