/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLTrimFunction
extends Expression {
    Expression expression;
    Expression trimChars;
    Type trimType;

    public SQLTrimFunction(Expression expression, Expression expression2, Type type) {
        this.expression = expression;
        this.trimChars = expression2;
        this.trimType = type;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Object object = this.expression.eval(map);
        if (object != null) {
            String string = object.toString();
            if (this.trimChars != null) {
                Object object2 = this.trimChars.eval(map);
                if (object2 != null) {
                    int n;
                    int n2;
                    String string2 = object2.toString();
                    if (this.trimType == Type.LEADING || this.trimType == Type.BOTH) {
                        for (n2 = 0; n2 < string.length() && string2.indexOf(string.charAt(n2)) >= 0; ++n2) {
                        }
                    }
                    if (this.trimType == Type.TRAILING || this.trimType == Type.BOTH) {
                        for (n = string.length() - 1; n >= n2 && string2.indexOf(string.charAt(n)) >= 0; --n) {
                        }
                    }
                    object = n >= n2 ? string.substring(n2, n + 1) : "";
                } else {
                    object = null;
                }
            } else if (this.trimType == Type.BOTH) {
                object = string.trim();
            } else if (this.trimType == Type.LEADING) {
                int n;
                for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
                }
                object = string.substring(n, string.length());
            } else {
                int n;
                for (n = string.length() - 1; n >= 0 && Character.isWhitespace(string.charAt(n)); --n) {
                }
                object = string.substring(0, n + 1);
            }
        }
        return object;
    }

    public String toString() {
        if (this.trimType == Type.LEADING) {
            return "LTRIM(" + this.expression + ")";
        }
        if (this.trimType == Type.TRAILING) {
            return "RTRIM(" + this.expression + ")";
        }
        return "TRIM(" + this.expression + ")";
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.expression.usedColumns());
        if (this.trimChars != null) {
            linkedList.addAll(this.trimChars.usedColumns());
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.expression.aggregateFunctions());
        if (this.trimChars != null) {
            linkedList.addAll(this.trimChars.aggregateFunctions());
        }
        return linkedList;
    }

    public static enum Type {
        LEADING,
        TRAILING,
        BOTH;

    }
}

