/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.relique.io.DataReader;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.AsteriskExpression;
import org.relique.jdbc.csv.ColumnName;
import org.relique.jdbc.csv.CsvConnection;
import org.relique.jdbc.csv.CsvReader;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvResultSetMetaData;
import org.relique.jdbc.csv.CsvStatement;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.NumericConstant;
import org.relique.jdbc.csv.StringConverter;

public class CsvResultSet
implements ResultSet {
    private ResultSetMetaData resultSetMetaData;
    private CsvStatement statement;
    private int resultSetType = 1005;
    private DataReader reader;
    private String tableName;
    private int lastIndexRead = -1;
    private LogicalExpression whereClause;
    private List<Expression> groupByColumns;
    private List<Expression> distinctColumns;
    private LogicalExpression havingClause;
    private List<Object[]> orderByColumns;
    private List<Object[]> queryEnvironment;
    private List<AggregateFunction> aggregateFunctions;
    private Set<ArrayList<Object>> distinctValues;
    private Map<String, Object> recordEnvironment;
    private List<String> usedColumns;
    private StringConverter converter;
    private ArrayList<Map<String, Object>> bufferedRecordEnvironments = null;
    private int currentRow;
    private boolean hitTail = false;
    private boolean nextResult = true;
    private int maxRows;
    private int fetchSize;
    private int fetchDirection;
    private int limit;
    private boolean isClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected CsvResultSet(CsvStatement csvStatement, DataReader dataReader, String string, List<Object[]> list, boolean bl, int n, LogicalExpression logicalExpression, List<Expression> list2, LogicalExpression logicalExpression2, List<Object[]> list3, int n2, int n3, String string2, int n4) throws ClassNotFoundException, SQLException {
        Object[] objectArray;
        int n5;
        this.statement = csvStatement;
        this.maxRows = csvStatement.getMaxRows();
        this.fetchSize = csvStatement.getFetchSize();
        this.fetchDirection = csvStatement.getFetchDirection();
        this.limit = n2;
        this.resultSetType = n;
        this.reader = dataReader;
        this.tableName = string;
        this.queryEnvironment = new ArrayList<Object[]>(list);
        this.aggregateFunctions = new ArrayList<AggregateFunction>();
        this.whereClause = logicalExpression;
        this.groupByColumns = list2 != null ? new ArrayList<Expression>(list2) : null;
        this.havingClause = logicalExpression2;
        this.orderByColumns = list3 != null ? new ArrayList<Object[]>(list3) : null;
        if (bl) {
            this.distinctValues = new HashSet<ArrayList<Object>>();
        }
        String string3 = ((CsvConnection)csvStatement.getConnection()).getTimeFormat();
        String string4 = ((CsvConnection)csvStatement.getConnection()).getDateFormat();
        String string5 = ((CsvConnection)csvStatement.getConnection()).getTimestampFormat();
        String string6 = ((CsvConnection)csvStatement.getConnection()).getTimeZoneName();
        Locale locale = ((CsvConnection)csvStatement.getConnection()).getLocale();
        this.converter = new StringConverter(string4, string3, string5, string6, locale);
        if (dataReader instanceof CsvReader) {
            ((CsvReader)dataReader).setConverter(this.converter);
            if (!"".equals(string2)) {
                ((CsvReader)dataReader).setColumnTypes(string2);
            }
        }
        this.usedColumns = logicalExpression != null ? new LinkedList<String>(logicalExpression.usedColumns()) : new LinkedList<String>();
        String[] stringArray = dataReader.getColumnNames();
        String string7 = dataReader.getTableAlias();
        HashSet<String> hashSet = new HashSet<String>();
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            String object22 = stringArray[n5].toUpperCase();
            hashSet.add(object22);
            if (string != null) {
                hashSet.add(string.toUpperCase() + "." + object22);
            }
            if (string7 == null) continue;
            hashSet.add(string7 + "." + object22);
        }
        if (this.resultSetType != 1003 && this.resultSetType != 1004 && this.resultSetType != 1005) {
            throw new SQLException(CsvResources.getString("invalidResultSetType") + ": " + this.resultSetType);
        }
        for (n5 = 0; n5 < this.queryEnvironment.size(); ++n5) {
            Object[] objectArray3 = this.queryEnvironment.get(n5);
            if (!(objectArray3[1] instanceof AsteriskExpression)) continue;
            objectArray = (AsteriskExpression)objectArray3[1];
            String string8 = objectArray.toString();
            if (!(string8.equals("*") || string7 != null && string8.equalsIgnoreCase(string7 + ".*"))) {
                throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + string8);
            }
            this.queryEnvironment.remove(n5);
            for (int i = 0; i < stringArray.length; ++i) {
                this.queryEnvironment.add(n5 + i, new Object[]{stringArray[i], new ColumnName(stringArray[i])});
            }
        }
        if (this.groupByColumns != null) {
            for (n5 = 0; n5 < this.groupByColumns.size(); ++n5) {
                Expression objectArray4 = this.groupByColumns.get(n5);
                if (!(objectArray4 instanceof NumericConstant)) continue;
                objectArray = (NumericConstant)objectArray4;
                if (!(objectArray.value instanceof Integer)) {
                    throw new SQLException(CsvResources.getString("invalidGroupBy") + ": " + objectArray);
                }
                int n6 = objectArray.value.intValue();
                if (--n6 < 0 || n6 >= this.queryEnvironment.size()) {
                    throw new SQLException(CsvResources.getString("invalidGroupBy") + ": " + (n6 + 1));
                }
                Object[] objectArray2 = this.queryEnvironment.get(n6);
                this.groupByColumns.set(n5, (Expression)objectArray2[1]);
            }
        }
        if (this.groupByColumns != null) {
            for (Expression n9 : this.groupByColumns) {
                this.usedColumns.addAll(n9.usedColumns());
            }
            if (logicalExpression2 != null) {
                this.usedColumns.addAll(logicalExpression2.usedColumns());
            }
        }
        if (this.orderByColumns != null) {
            for (Object[] n13 : this.orderByColumns) {
                objectArray = (Expression)n13[1];
                if (!(objectArray instanceof NumericConstant)) continue;
                NumericConstant numericConstant = (NumericConstant)objectArray;
                if (!(numericConstant.value instanceof Integer)) {
                    throw new SQLException(CsvResources.getString("invalidOrderBy") + ": " + numericConstant);
                }
                int n7 = numericConstant.value.intValue();
                if (--n7 < 0 || n7 >= this.queryEnvironment.size()) {
                    throw new SQLException(CsvResources.getString("invalidOrderBy") + ": " + (n7 + 1));
                }
                Object[] objectArray3 = this.queryEnvironment.get(n7);
                n13[1] = objectArray3[1];
            }
        }
        if (this.orderByColumns != null) {
            for (Object[] objectArray4 : this.orderByColumns) {
                objectArray = (Expression)objectArray4[1];
                this.usedColumns.addAll(objectArray.usedColumns());
            }
        }
        for (int i = 0; i < this.queryEnvironment.size(); ++i) {
            Object[] objectArray5 = this.queryEnvironment.get(i);
            objectArray = (Expression)objectArray5[1];
            List<AggregateFunction> list4 = objectArray.aggregateFunctions();
            this.aggregateFunctions.addAll(list4);
            for (AggregateFunction aggregateFunction : list4) {
                this.usedColumns.addAll(aggregateFunction.aggregateColumns());
            }
        }
        if (this.aggregateFunctions.size() > 0 && this.groupByColumns == null) {
            void var24_50;
            LinkedList<String> linkedList = new LinkedList<String>();
            boolean bl2 = false;
            while (var24_50 < this.queryEnvironment.size()) {
                objectArray = this.queryEnvironment.get((int)var24_50);
                if (objectArray[1] != null) {
                    linkedList.addAll(objectArray[1].usedColumns());
                }
                ++var24_50;
            }
            if (linkedList.size() > 0 && this.aggregateFunctions.size() > 0) {
                throw new SQLException(CsvResources.getString("columnsWithAggregateFunctions"));
            }
        }
        if (logicalExpression != null && logicalExpression.aggregateFunctions().size() > 0) {
            throw new SQLException(CsvResources.getString("noAggregateFunctions"));
        }
        if (!((CsvConnection)csvStatement.getConnection()).isIndexedFiles()) {
            for (int i = 0; i < this.queryEnvironment.size(); ++i) {
                Object[] objectArray6 = this.queryEnvironment.get(i);
                if (objectArray6[1] != null) {
                    objectArray = (Expression)objectArray6[1];
                    List<String> list5 = objectArray.usedColumns();
                    for (String string9 : list5) {
                        if (hashSet.contains(string9)) continue;
                        throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + string9);
                    }
                }
                hashSet.add(objectArray6[0].toString());
            }
        }
        if (!((CsvConnection)csvStatement.getConnection()).isIndexedFiles()) {
            for (String string10 : this.usedColumns) {
                if (hashSet.contains(string10)) continue;
                throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + string10);
            }
            this.checkGroupBy();
            if (this.orderByColumns != null) {
                for (Object[] objectArray7 : this.orderByColumns) {
                    objectArray = (Expression)objectArray7[1];
                    LinkedList<String> linkedList = new LinkedList<String>(objectArray.usedColumns());
                    for (AggregateFunction aggregateFunction : objectArray.aggregateFunctions()) {
                        linkedList.addAll(aggregateFunction.aggregateColumns());
                    }
                    if (!linkedList.isEmpty()) continue;
                    throw new SQLException(CsvResources.getString("invalidOrderBy") + ": " + objectArray.toString());
                }
            }
        }
        if (this.distinctValues != null) {
            for (int i = 0; i < this.queryEnvironment.size(); ++i) {
                Object[] objectArray8 = this.queryEnvironment.get(i);
                objectArray = (Expression)objectArray8[1];
                this.usedColumns.addAll(objectArray.usedColumns());
            }
        }
        if (this.groupByColumns != null || this.orderByColumns != null || this.aggregateFunctions.size() > 0 || this.isScrollable()) {
            this.bufferedRecordEnvironments = new ArrayList();
            this.currentRow = 0;
        }
        if (this.groupByColumns != null) {
            int n8 = this.maxRows;
            int n9 = this.limit;
            this.maxRows = 0;
            this.limit = -1;
            objectArray = new ArrayList();
            HashMap hashMap = new HashMap();
            try {
                ArrayList arrayList;
                while (this.next()) {
                    Map<String, Object> map = this.updateRecordEnvironment(true);
                    if (this.converter != null) {
                        map.put("@STRINGCONVERTER", this.converter);
                    }
                    ArrayList<Object> arrayList2 = new ArrayList<Object>(this.groupByColumns.size());
                    for (Expression expression : this.groupByColumns) {
                        arrayList2.add(expression.eval(map));
                    }
                    arrayList = (ArrayList)hashMap.get(arrayList2);
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                        hashMap.put(arrayList2, arrayList);
                        objectArray.add(arrayList2);
                    }
                    arrayList.add(this.recordEnvironment);
                }
                this.bufferedRecordEnvironments.clear();
                for (ArrayList arrayList3 : objectArray) {
                    arrayList = (ArrayList)hashMap.get(arrayList3);
                    HashMap<String, Object> hashMap2 = new HashMap<String, Object>((Map)arrayList.get(0));
                    hashMap2.put("@GROUPROWS", arrayList);
                    if (this.havingClause != null && !this.havingClause.isTrue(hashMap2)) continue;
                    this.bufferedRecordEnvironments.add(hashMap2);
                }
                if (this.orderByColumns != null) {
                    this.sortRows(n3);
                }
            }
            finally {
                this.maxRows = n8;
                this.limit = n9;
            }
            this.currentRow = 0;
            this.nextResult = true;
            this.recordEnvironment = null;
            this.updateRecordEnvironment(false);
            this.hitTail = true;
        } else if (this.aggregateFunctions.size() > 0) {
            int n10 = this.maxRows;
            int n11 = this.limit;
            this.maxRows = 0;
            this.limit = -1;
            try {
                while (this.next()) {
                    objectArray = this.aggregateFunctions.iterator();
                    while (objectArray.hasNext()) {
                        AggregateFunction aggregateFunction;
                        AggregateFunction aggregateFunction2 = aggregateFunction = objectArray.next();
                        aggregateFunction2.processRow(this.recordEnvironment);
                    }
                }
                this.bufferedRecordEnvironments.clear();
                if ((n11 < 0 || n11 > 0) && n3 == 0) {
                    this.bufferedRecordEnvironments.add(new HashMap());
                }
            }
            finally {
                this.maxRows = n10;
                this.limit = n11;
            }
            this.currentRow = 0;
            this.nextResult = true;
            this.recordEnvironment = null;
            this.updateRecordEnvironment(false);
            this.hitTail = true;
        } else if (this.orderByColumns != null) {
            int n12 = this.maxRows;
            int n13 = this.limit;
            this.maxRows = 0;
            this.limit = -1;
            try {
                while (this.next()) {
                }
            }
            finally {
                this.maxRows = n12;
                this.limit = n13;
            }
            this.sortRows(n3);
            this.currentRow = 0;
            this.nextResult = true;
            this.recordEnvironment = null;
            this.updateRecordEnvironment(false);
        } else if (n3 > 0) {
            int n14 = this.maxRows;
            int n15 = this.limit;
            this.maxRows = 0;
            this.limit = -1;
            try {
                while (n3 > 0) {
                    if (!this.next()) {
                        break;
                    }
                    --n3;
                }
            }
            finally {
                this.maxRows = n14;
                this.limit = n15;
                this.currentRow = 0;
                this.nextResult = true;
                if (this.bufferedRecordEnvironments != null) {
                    this.bufferedRecordEnvironments.clear();
                }
            }
        }
    }

    private boolean isScrollable() {
        return this.resultSetType == 1004 || this.resultSetType == 1005;
    }

    /*
     * WARNING - void declaration
     */
    private void checkGroupBy() throws SQLException {
        if (this.groupByColumns != null) {
            boolean bl;
            void var4_25;
            void var3_11;
            Object object;
            void var3_9;
            for (Expression object32 : this.groupByColumns) {
                List<String> list = object32.usedColumns();
                if (!list.isEmpty()) continue;
                throw new SQLException(CsvResources.getString("invalidGroupBy") + ": " + object32.toString());
            }
            ArrayList arrayList = new ArrayList();
            for (Expression bl2 : this.groupByColumns) {
                arrayList.addAll(bl2.usedColumns());
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            boolean bl3 = false;
            while (var3_9 < this.queryEnvironment.size()) {
                Object[] objectArray = this.queryEnvironment.get((int)var3_9);
                arrayList2.add(objectArray[0].toString());
                if (objectArray[1] != null) {
                    object = (Object[])objectArray[1];
                    for (String string : ((Expression)object).usedColumns()) {
                        arrayList2.add(string.toString());
                    }
                }
                ++var3_9;
            }
            boolean bl4 = false;
            while (var3_11 < this.queryEnvironment.size()) {
                Object[] objectArray = this.queryEnvironment.get((int)var3_11);
                if (!arrayList.contains(objectArray[0]) && objectArray[1] != null) {
                    object = (Expression)objectArray[1];
                    for (String string : ((Expression)object).usedColumns()) {
                        String string2;
                        String string3 = string.toString();
                        if (arrayList.contains(string3) || this.tableName != null && arrayList.contains(this.tableName.toUpperCase() + "." + string3) || (string2 = this.reader.getTableAlias()) != null && arrayList.contains(string2 + "." + string3)) continue;
                        throw new SQLException(CsvResources.getString("columnNotInGroupBy") + ": " + string3);
                    }
                }
                ++var3_11;
            }
            if (this.havingClause != null) {
                for (String string : this.havingClause.usedColumns()) {
                    if (arrayList2.contains(string)) continue;
                    throw new SQLException(CsvResources.getString("invalidHaving") + ": " + string);
                }
            }
            if (this.orderByColumns != null) {
                for (Object[] objectArray : this.orderByColumns) {
                    object = (Expression)objectArray[1];
                    for (String string : ((Expression)object).usedColumns()) {
                        if (arrayList2.contains(string.toString())) continue;
                        throw new SQLException(CsvResources.getString("orderByNotInGroupBy") + ": " + string);
                    }
                }
            }
            boolean bl5 = false;
            boolean bl6 = false;
            while (var4_25 < this.queryEnvironment.size()) {
                object = this.queryEnvironment.get((int)var4_25);
                Expression expression = (Expression)object[1];
                if (expression.aggregateFunctions().size() > 0) {
                    boolean bl7 = true;
                }
                ++var4_25;
            }
            if (this.havingClause != null && this.havingClause.aggregateFunctions().size() > 0) {
                bl = true;
            }
            if (!bl) {
                this.distinctValues = new HashSet<ArrayList<Object>>();
                this.distinctColumns = new ArrayList<Expression>(this.groupByColumns);
                this.groupByColumns = null;
            }
        }
    }

    private void sortRows(int n) throws SQLException {
        int n2;
        Map[] mapArray = new Map[this.bufferedRecordEnvironments.size()];
        for (n2 = 0; n2 < mapArray.length; ++n2) {
            mapArray[n2] = this.bufferedRecordEnvironments.get(n2);
        }
        this.bufferedRecordEnvironments.clear();
        try {
            Arrays.sort(mapArray, new OrderByComparator());
        }
        catch (OrderByException orderByException) {
            throw new SQLException(orderByException.getMessage());
        }
        n2 = mapArray.length;
        if (this.maxRows != 0 && this.maxRows < n2) {
            n2 = this.maxRows;
        }
        if (this.limit >= 0 && n + this.limit < n2) {
            n2 = n + this.limit;
        }
        for (int i = n; i < n2; ++i) {
            this.bufferedRecordEnvironments.add(mapArray[i]);
        }
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CsvResources.getString("closedResultSet"));
        }
    }

    @Override
    public boolean next() throws SQLException {
        boolean bl;
        this.checkOpen();
        if ((this.groupByColumns != null || this.aggregateFunctions.size() > 0 || this.orderByColumns != null || this.isScrollable()) && this.currentRow < this.bufferedRecordEnvironments.size()) {
            ++this.currentRow;
            this.recordEnvironment = this.bufferedRecordEnvironments.get(this.currentRow - 1);
            this.updateRecordEnvironment(true);
            bl = true;
        } else {
            Map<String, Object> map;
            bl = this.maxRows != 0 && this.currentRow >= this.maxRows ? false : (this.limit >= 0 && this.currentRow >= this.limit ? false : (this.hitTail ? false : this.reader.next()));
            if (bl) {
                this.recordEnvironment = this.reader.getEnvironment();
                this.recordEnvironment.put("@STATEMENT", this.statement);
            } else {
                this.recordEnvironment = null;
            }
            if (this.whereClause != null || this.distinctValues != null) {
                map = this.updateRecordEnvironment(bl);
                while (bl && (this.whereClause != null && !this.whereClause.isTrue(map) || this.distinctColumns != null && this.havingClause != null && !this.havingClause.isTrue(map) || this.distinctValues != null && !this.addDistinctEnvironment(map))) {
                    bl = this.reader.next();
                    if (bl) {
                        this.recordEnvironment = this.reader.getEnvironment();
                        this.recordEnvironment.put("@STATEMENT", this.statement);
                    } else {
                        this.recordEnvironment = null;
                    }
                    map = this.updateRecordEnvironment(bl);
                }
            }
            if (this.orderByColumns != null || this.isScrollable()) {
                if (bl) {
                    map = this.reader.getEnvironment();
                    map.put("@STATEMENT", this.statement);
                    this.bufferedRecordEnvironments.add(map);
                    ++this.currentRow;
                } else {
                    this.hitTail = true;
                    this.currentRow = this.bufferedRecordEnvironments.size() + 1;
                }
            } else if (bl) {
                ++this.currentRow;
            } else {
                this.hitTail = true;
            }
        }
        this.nextResult = bl;
        return bl;
    }

    private Map<String, Object> updateRecordEnvironment(boolean bl) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!bl) {
            this.recordEnvironment = null;
            return hashMap;
        }
        for (n = 0; n < this.queryEnvironment.size(); ++n) {
            object3 = this.queryEnvironment.get(n);
            object2 = (String)object3[0];
            object = ((Expression)object3[1]).eval(this.recordEnvironment);
            hashMap.put(((String)object2).toUpperCase(), object);
        }
        for (n = 0; n < this.usedColumns.size(); ++n) {
            object3 = this.usedColumns.get(n);
            if (hashMap.containsKey(object3 = object3.toUpperCase())) continue;
            hashMap.put((String)object3, this.recordEnvironment.get(object3));
        }
        String string = "@GROUPROWS";
        object3 = this.recordEnvironment.get(string);
        if (object3 != null) {
            hashMap.put(string, object3);
        }
        if ((object2 = this.recordEnvironment.get(string = "@STRINGCONVERTER")) != null) {
            hashMap.put(string, object2);
        }
        if ((object = this.recordEnvironment.get(string = "@STATEMENT")) != null) {
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private boolean addDistinctEnvironment(Map<String, Object> map) throws SQLException {
        ArrayList<Object> arrayList;
        if (this.distinctColumns != null) {
            arrayList = new ArrayList<Object>(this.distinctColumns.size());
            for (int i = 0; i < this.distinctColumns.size(); ++i) {
                Object object = this.distinctColumns.get(i).eval(map);
                arrayList.add(object);
            }
        } else {
            arrayList = new ArrayList(this.queryEnvironment.size());
            for (int i = 0; i < this.queryEnvironment.size(); ++i) {
                Object[] objectArray = this.queryEnvironment.get(i);
                Object object = ((Expression)objectArray[1]).eval(map);
                arrayList.add(object);
            }
        }
        boolean bl = this.distinctValues.add(arrayList);
        return bl;
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        this.reader.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.lastIndexRead >= 0) {
            return this.getString(this.lastIndexRead) == null;
        }
        throw new SQLException(CsvResources.getString("noGetMethod"));
    }

    @Override
    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        Boolean bl;
        String string = this.getString(n);
        if (string != null && (bl = this.converter.parseBoolean(string)) != null) {
            return bl;
        }
        return false;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        Byte by;
        String string = this.getString(n);
        if (string != null && (by = this.converter.parseByte(string)) != null) {
            return by;
        }
        return 0;
    }

    @Override
    public short getShort(int n) throws SQLException {
        Short s;
        String string = this.getString(n);
        if (string != null && (s = this.converter.parseShort(string)) != null) {
            return s;
        }
        return 0;
    }

    @Override
    public int getInt(int n) throws SQLException {
        Integer n2;
        String string = this.getString(n);
        if (string != null && (n2 = this.converter.parseInt(string)) != null) {
            return n2;
        }
        return 0;
    }

    @Override
    public long getLong(int n) throws SQLException {
        Long l;
        String string = this.getString(n);
        if (string != null && (l = this.converter.parseLong(string)) != null) {
            return l;
        }
        return 0L;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        Float f;
        String string = this.getString(n);
        if (string != null && (f = this.converter.parseFloat(string)) != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    @Override
    public double getDouble(int n) throws SQLException {
        Double d;
        String string = this.getString(n);
        if (string != null && (d = this.converter.parseDouble(string)) != null) {
            return d;
        }
        return 0.0;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            return this.converter.parseBytes(string);
        }
        return null;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return (Date)this.getObject(n);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return (Time)this.getObject(n);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object instanceof Date) {
            object = new Timestamp(((Date)object).getTime());
        }
        return (Timestamp)object;
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            return this.converter.parseAsciiStream(string);
        }
        return null;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.getAsciiStream(n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        return this.getAsciiStream(n);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException(CsvResources.getString("methodNotSupported") + ": ResultSet.getCursorName()");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultSetMetaData == null) {
            Object object;
            Object[] objectArray;
            int n;
            String[] stringArray = this.reader.getColumnTypes();
            String[] stringArray2 = this.reader.getColumnNames();
            int[] nArray = this.reader.getColumnSizes();
            String string = this.reader.getTableAlias();
            int n2 = this.queryEnvironment.size();
            String[] stringArray3 = new String[n2];
            String[] stringArray4 = new String[n2];
            int[] nArray2 = new int[n2];
            String[] stringArray5 = new String[n2];
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (n = 0; n < stringArray.length; ++n) {
                objectArray = StringConverter.getLiteralForTypeName(stringArray[n]);
                object = stringArray2[n].toUpperCase();
                hashMap.put((String)object, objectArray);
                if (this.tableName != null) {
                    hashMap.put(this.tableName.toUpperCase() + "." + (String)object, objectArray);
                }
                if (string == null) continue;
                hashMap.put(string + "." + (String)object, objectArray);
            }
            if (this.converter != null) {
                hashMap.put("@STRINGCONVERTER", this.converter);
            }
            hashMap.put("@STATEMENT", this.statement);
            for (n = 0; n < n2; ++n) {
                objectArray = this.queryEnvironment.get(n);
                stringArray3[n] = (String)objectArray[0];
                stringArray4[n] = stringArray3[n];
                object = null;
                try {
                    Expression expression = (Expression)objectArray[1];
                    int n3 = 20;
                    if (expression instanceof ColumnName) {
                        String string2 = expression.usedColumns().get(0);
                        for (int i = 0; i < stringArray2.length; ++i) {
                            if (!string2.equalsIgnoreCase(stringArray2[i])) continue;
                            n3 = nArray[i];
                            break;
                        }
                    }
                    nArray2[n] = n3;
                    object = expression.eval(hashMap);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                stringArray5[n] = object != null ? StringConverter.getTypeNameForLiteral(object) : "expression";
            }
            this.resultSetMetaData = new CsvResultSetMetaData(this.tableName, stringArray3, stringArray4, stringArray5, nArray2);
        }
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.preAccessor(n);
        Object[] objectArray = this.queryEnvironment.get(n - 1);
        if (this.recordEnvironment != null) {
            return ((Expression)objectArray[1]).eval(this.recordEnvironment);
        }
        return null;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        return string == null ? null : new StringReader(string);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        String string2 = this.getString(string);
        return string2 == null ? null : new StringReader(string2);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        String string = this.getString(n);
        if (string != null) {
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException(CsvResources.getString("cannotConvertToBigDecimal") + ": " + string);
            }
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            return this.currentRow == 0;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.isBeforeFirst()");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            return this.currentRow == this.bufferedRecordEnvironments.size() + 1;
        }
        return !this.nextResult && this.currentRow > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            return this.currentRow == 1;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.isFirst()");
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            if (!this.hitTail && this.currentRow != 0) {
                this.next();
                this.previous();
            }
            return this.currentRow == this.bufferedRecordEnvironments.size();
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.isLast()");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkOpen();
        if (!this.isScrollable()) {
            throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.beforeFirst()");
        }
        this.first();
        this.previous();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            while (this.next()) {
            }
        } else {
            throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.afterLast()");
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            this.currentRow = 0;
            boolean bl = this.next();
            this.updateRecordEnvironment(bl);
            return bl;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.first()");
    }

    @Override
    public boolean last() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            this.afterLast();
            this.previous();
            return this.bufferedRecordEnvironments.size() != 0;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.last()");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        if (!this.isScrollable() && !this.nextResult) {
            return 0;
        }
        return this.currentRow;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            boolean bl;
            if (n < 0) {
                this.last();
                n = this.currentRow + n + 1;
            } else {
                while (this.bufferedRecordEnvironments.size() < n && this.next()) {
                }
            }
            if (n <= 0) {
                bl = false;
                this.currentRow = 0;
            } else if (n > this.bufferedRecordEnvironments.size()) {
                bl = false;
                this.currentRow = this.bufferedRecordEnvironments.size() + 1;
            } else {
                bl = true;
                this.currentRow = n;
                this.recordEnvironment = this.bufferedRecordEnvironments.get(this.currentRow - 1);
            }
            this.updateRecordEnvironment(bl);
            return bl;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.absolute()");
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            if (this.currentRow + n >= 0) {
                return this.absolute(this.currentRow + n);
            }
            this.currentRow = 0;
            this.updateRecordEnvironment(false);
            return false;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.relative()");
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            if (this.currentRow > 1) {
                --this.currentRow;
                this.recordEnvironment = this.bufferedRecordEnvironments.get(this.currentRow - 1);
                this.updateRecordEnvironment(true);
                return true;
            }
            this.currentRow = 0;
            this.recordEnvironment = null;
            this.updateRecordEnvironment(false);
            return false;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.previous()");
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkOpen();
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new SQLException(CsvResources.getString("unsupportedDirection") + ": " + n);
        }
        this.fetchDirection = n;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.rowUpdated()");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.rowInserted()");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.rowDeleted()");
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateNull(int)");
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBoolean(int, boolean)");
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateByte(int, byte)");
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateShort(int, short)");
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateInt(int, int)");
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateLong(int, long)");
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateFloat(int, float)");
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateDouble(int, double)");
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBigDecimal(int, BigDecimal)");
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateString(int, String)");
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBytes(int, byte[])");
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateDate(int, Date)");
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateTime(int, Time)");
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateTimestamp(int, Timestamp)");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateAsciiStream(int, InputStream, int)");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBinaryStreamint, InputStream, int)");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateCharacterStream(int, Reader, int)");
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.udpateObject(int, Object)");
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateObject(int, Object, int)");
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateNull(String)");
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBoolean(String, boolean)");
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateByte(String, byte)");
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateShort(String, short)");
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateInt(String, int)");
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateLong(String, long)");
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateFloat(String, float)");
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateDouble(String, double)");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBigDecimal(String, BigDecimal)");
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateString(String, String)");
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBytes(String, byte[])");
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateDate(String, Date)");
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateTime(String, Time)");
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateTimestamp(String, Timestamp)");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateAsciiStream(String, InputStream, int)");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBinaryStream(String, InputStream, int)");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateCharacterStream(String, Reader, int)");
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateObject(String, Object, int)");
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateObject(String, Object)");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.insertRow()");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateRow()");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.deleteRow()");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.refreshRow()");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.cancelRowUpdates()");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.moveToInsertRow()");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.moveToeCurrentRow()");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getObject(int, Map)");
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getRef(int)");
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getBlob(int)");
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getClob(int)");
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getArray(int)");
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getObject(String, Map)");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getRef(String)");
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getBlob(String)");
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getClob(String)");
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getArray(String)");
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getDate(int, Calendar)");
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getDate(String, Calendar)");
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getTime(int, Calendar)");
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getTime(String, Calendar)");
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getTimestamp(int, Calendar)");
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getTimestamp(String, Calendar)");
    }

    private void preAccessor(int n) throws SQLException {
        this.lastIndexRead = n;
        this.checkOpen();
        if (n < 1 || n > this.queryEnvironment.size()) {
            throw new SQLException(CsvResources.getString("invalidColumnIndex") + ": " + n);
        }
        if (this.currentRow == 0) {
            throw new SQLException(CsvResources.getString("noCurrentRow"));
        }
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getURL(int)");
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getURL(String)");
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateRef(int,java.sql.Ref)");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateRef(String,java.sql.Ref)");
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBlob(int,java.sql.Blob)");
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBlob(String,java.sql.Blob)");
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateClob(int,java.sql.Clob)");
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateClob(String,java.sql.Clob)");
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateArray(int,java.sql.Array)");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateArray(String,java.sql.Array)");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int n) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String string) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        this.checkOpen();
        if (string.equals("")) {
            throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + string);
        }
        for (int i = 0; i < this.queryEnvironment.size(); ++i) {
            Object[] objectArray = this.queryEnvironment.get(i);
            if (!((String)objectArray[0]).equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + string);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return null;
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getObject(String, Class<T>)");
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getObject(int, Class<T>)");
    }

    public class OrderByComparator
    implements Comparator<Map<String, Object>> {
        @Override
        public int compare(Map<String, Object> map, Map<String, Object> map2) {
            int n = 0;
            try {
                for (int i = 0; i < CsvResultSet.this.orderByColumns.size() && n == 0; ++i) {
                    Object[] objectArray = (Object[])CsvResultSet.this.orderByColumns.get(i);
                    Integer n2 = (Integer)objectArray[0];
                    Expression expression = (Expression)objectArray[1];
                    CsvResultSet.this.recordEnvironment = map;
                    Map map3 = CsvResultSet.this.updateRecordEnvironment(true);
                    if (CsvResultSet.this.converter != null) {
                        map3.put("@STRINGCONVERTER", CsvResultSet.this.converter);
                    }
                    Comparable comparable = (Comparable)expression.eval(map3);
                    CsvResultSet.this.recordEnvironment = map2;
                    Map map4 = CsvResultSet.this.updateRecordEnvironment(true);
                    if (CsvResultSet.this.converter != null) {
                        map4.put("@STRINGCONVERTER", CsvResultSet.this.converter);
                    }
                    Comparable comparable2 = (Comparable)expression.eval(map4);
                    n = comparable == null ? (comparable2 == null ? 0 : -1) : (comparable2 == null ? 1 : comparable.compareTo(comparable2));
                    if (n2 >= 0) continue;
                    n = -n;
                }
            }
            catch (SQLException sQLException) {
                throw new OrderByException(sQLException.getMessage());
            }
            return n;
        }
    }

    public class OrderByException
    extends RuntimeException {
        public OrderByException(String string) {
            super(string);
        }
    }
}

