/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.relique.io.DataReader;
import org.relique.jdbc.csv.CsvRawReader;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.StringConverter;

public class CsvReader
extends DataReader {
    private CsvRawReader rawReader;
    private int transposedLines;
    private int transposedFieldsToSkip;
    private String[] columnNames;
    private String[] tableAndColumnNames;
    private String[] aliasedColumnNames;
    private String[] columnTypes;
    private String[] upperColumnNames;
    private Vector<String[]> firstTable;
    private int joiningValueNo;
    private int valuesToJoin;
    private String[] joiningValues;
    private StringConverter converter;
    private String[] fieldValues;
    private int lineNumber;

    public CsvReader(CsvRawReader csvRawReader, int n, int n2, String string) throws SQLException {
        this.rawReader = csvRawReader;
        this.transposedLines = n;
        this.transposedFieldsToSkip = n2;
        this.columnNames = csvRawReader.parseLine(string, true);
        this.firstTable = null;
        this.columnTypes = null;
        if (!this.isPlainReader()) {
            this.firstTable = new Vector();
            this.joiningValueNo = 0;
            this.joiningValues = null;
            try {
                String[] stringArray = null;
                for (int i = 0; i < n; ++i) {
                    String string2 = csvRawReader.getNextDataLine();
                    stringArray = csvRawReader.parseLine(string2, false);
                    this.firstTable.add(stringArray);
                }
                this.valuesToJoin = stringArray.length;
                this.fieldValues = new String[this.columnNames.length];
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
        }
    }

    public void setConverter(StringConverter stringConverter) {
        this.converter = stringConverter;
    }

    private int getTransposedFieldsToSkip() {
        return this.transposedFieldsToSkip;
    }

    private boolean isPlainReader() {
        return this.transposedLines == 0 && this.transposedFieldsToSkip == 0;
    }

    @Override
    public boolean next() throws SQLException {
        int n;
        if (this.isPlainReader()) {
            boolean bl = this.rawReader.next();
            this.lineNumber = this.rawReader.getLineNumber();
            this.fieldValues = this.rawReader.getFieldValues();
            return bl;
        }
        if (this.joiningValues == null || this.joiningValueNo + this.getTransposedFieldsToSkip() == this.valuesToJoin) {
            String string;
            try {
                string = this.rawReader.getNextDataLine();
                if (string != null) {
                    this.lineNumber = this.rawReader.getLineNumber();
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            if (string == null) {
                return false;
            }
            this.joiningValues = this.rawReader.parseLine(string, false);
            this.joiningValueNo = 0;
        }
        for (n = 0; n < this.transposedLines; ++n) {
            this.fieldValues[n] = this.firstTable.get(n)[this.joiningValueNo + this.getTransposedFieldsToSkip()];
        }
        for (n = this.transposedLines; n < this.columnNames.length - 1; ++n) {
            this.fieldValues[n] = this.joiningValues[n - this.transposedLines];
        }
        this.fieldValues[this.columnNames.length - 1] = this.joiningValues[this.columnNames.length - this.transposedLines - 1 + this.joiningValueNo];
        ++this.joiningValueNo;
        if (this.columnTypes == null) {
            this.getColumnTypes();
        }
        return true;
    }

    @Override
    public String[] getColumnNames() {
        if (this.isPlainReader()) {
            return this.rawReader.getColumnNames();
        }
        return this.columnNames;
    }

    private String[] getUpperColumnNames() {
        if (this.upperColumnNames == null) {
            this.upperColumnNames = this.getColumnNames();
            for (int i = 0; i < this.upperColumnNames.length; ++i) {
                this.upperColumnNames[i] = this.upperColumnNames[i].toUpperCase();
            }
        }
        return this.upperColumnNames;
    }

    private String[] getTableAndColumnNames() {
        if (this.tableAndColumnNames == null) {
            String string = this.rawReader.getTableName().toUpperCase();
            String[] stringArray = this.getUpperColumnNames();
            this.tableAndColumnNames = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.tableAndColumnNames[i] = string + "." + stringArray[i];
            }
        }
        return this.tableAndColumnNames;
    }

    private String[] getAliasedColumnNames() {
        String string;
        if (this.aliasedColumnNames == null && (string = this.rawReader.getTableAlias()) != null) {
            String[] stringArray = this.getUpperColumnNames();
            this.aliasedColumnNames = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.aliasedColumnNames[i] = string + "." + stringArray[i];
            }
        }
        return this.aliasedColumnNames;
    }

    private Object getField(int n) throws SQLException {
        if (this.isPlainReader()) {
            return this.rawReader.getField(n);
        }
        return null;
    }

    @Override
    public void close() {
        this.rawReader.close();
    }

    @Override
    public Map<String, Object> getEnvironment() throws SQLException {
        if (this.fieldValues.length != this.getColumnNames().length) {
            throw new SQLException(CsvResources.getString("wrongColumnCount") + ": " + this.lineNumber + " " + CsvResources.getString("columnsRead") + ": " + this.fieldValues.length + " " + CsvResources.getString("columnsExpected") + ": " + this.getColumnNames().length);
        }
        if (this.columnTypes == null) {
            this.getColumnTypes();
        }
        String[] stringArray = this.getUpperColumnNames();
        String[] stringArray2 = this.getTableAndColumnNames();
        String[] stringArray3 = this.getAliasedColumnNames();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("@STRINGCONVERTER", this.converter);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Object object = this.converter.convert(this.columnTypes[i], this.fieldValues[i]);
            hashMap.put(string, object);
            hashMap.put(stringArray2[i], object);
            if (stringArray3 == null) continue;
            hashMap.put(stringArray3[i], object);
        }
        return hashMap;
    }

    public void setColumnTypes(String string) throws SQLException {
        int n;
        String[] stringArray = string.split(",");
        if (stringArray.length == 0) {
            throw new SQLException(CsvResources.getString("invalidColumnType") + ": " + string);
        }
        this.columnTypes = new String[this.getColumnNames().length];
        for (n = 0; n < Math.min(stringArray.length, this.columnTypes.length); ++n) {
            String string2 = stringArray[n].trim();
            if (this.converter.forSQLName(string2) == null) {
                throw new SQLException(CsvResources.getString("invalidColumnType") + ": " + string2);
            }
            this.columnTypes[n] = string2;
        }
        for (n = stringArray.length; n < this.columnTypes.length; ++n) {
            this.columnTypes[n] = stringArray[stringArray.length - 1].trim();
        }
    }

    @Override
    public String[] getColumnTypes() throws SQLException {
        if (this.columnTypes == null) {
            this.inferColumnTypes();
        }
        return this.columnTypes;
    }

    private void inferColumnTypes() throws SQLException {
        if (this.fieldValues == null) {
            throw new SQLException(CsvResources.getString("cannotInferColumns"));
        }
        this.columnTypes = new String[this.fieldValues.length];
        for (int i = 0; i < this.fieldValues.length; ++i) {
            try {
                String string = "String";
                String string2 = this.getField(i).toString();
                if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false")) {
                    string = "Boolean";
                } else if (string2.equals("" + this.converter.parseInt(string2))) {
                    string = "Int";
                } else if (string2.equals("" + this.converter.parseLong(string2))) {
                    string = "Long";
                } else if (string2.equals("" + this.converter.parseDouble(string2))) {
                    string = "Double";
                } else if (string2.equals("" + this.converter.parseBytes(string2))) {
                    string = "Bytes";
                } else if (string2.equals("" + this.converter.parseBigDecimal(string2))) {
                    string = "BigDecimal";
                } else if (this.converter.parseTimestamp(string2) != null) {
                    string = "Timestamp";
                } else if (string2.equals(("" + this.converter.parseDate(string2) + "          ").substring(0, 10))) {
                    string = "Date";
                } else if (string2.equals(("" + this.converter.parseTime(string2) + "        ").substring(0, 8))) {
                    string = "Time";
                } else if (string2.equals("" + this.converter.parseAsciiStream(string2))) {
                    string = "AsciiStream";
                }
                this.columnTypes[i] = string;
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public int[] getColumnSizes() {
        return this.rawReader.getColumnSizes();
    }

    @Override
    public String getTableAlias() {
        return this.rawReader.getTableAlias();
    }
}

