/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.relique.io.ListDataReader;
import org.relique.jdbc.csv.AsteriskExpression;
import org.relique.jdbc.csv.CsvConnection;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvResultSet;
import org.relique.jdbc.csv.CsvStatement;
import org.relique.jdbc.csv.LikePattern;
import org.relique.jdbc.csv.StringConverter;

public class CsvDatabaseMetaData
implements DatabaseMetaData {
    private static final String SCHEMA_NAME = "PUBLIC";
    private Connection createdByConnection;
    private CsvStatement internalStatement = null;

    public CsvDatabaseMetaData(Connection connection) {
        this.createdByConnection = connection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": DatabaseMetaData.getAttributes(String,String,String,String)");
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        String string4 = "SCOPE,COLUMN_NAME,DATA_TYPE,TYPE_NAME,COLUMN_SIZE,BUFFER_LENGTH,DECIMAL_DIGITS,PSEUDO_COLUMN";
        String string5 = "Short,String,Integer,String,Integer,Integer,Short,Short";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSet resultSet = this.createResultSet(string4, string5, arrayList);
        return resultSet;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String string = "TABLE_CAT";
        String string2 = "String";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSet resultSet = this.createResultSet(string, string2, arrayList);
        return resultSet;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "catalog";
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        return this.getTablePrivileges(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        Object object;
        String string5 = "TABLE_CAT,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,DATA_TYPE,TYPE_NAME,COLUMN_SIZE,BUFFER_LENGTH,DECIMAL_DIGITS,NUM_PREC_RADIX,NULLABLE,REMARKS,COLUMN_DEF,SQL_DATA_TYPE,SQL_DATETIME_SUB,CHAR_OCTET_LENGTH,ORDINAL_POSITION,IS_NULLABLE,SCOPE_CATLOG,SCOPE_SCHEMA,SCOPE_TABLE,SOURCE_DATA_TYPE,IS_AUTOINCREMENT";
        String string6 = "String,String,String,String,Integer,String,Integer,Integer,Integer,Integer,Integer,String,String,Integer,Integer,Integer,Integer,String,String,String,String,Short,String";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        try {
            if (this.internalStatement == null) {
                this.internalStatement = (CsvStatement)this.createdByConnection.createStatement();
            }
            resultSet = this.getTables(string, string2, string3, null);
            while (resultSet.next()) {
                object = resultSet.getString(3);
                resultSet2 = this.internalStatement.executeQuery("SELECT * FROM " + (String)object);
                ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                Integer n2 = Short.MAX_VALUE;
                Integer n3 = Short.MAX_VALUE;
                Integer n4 = 0;
                Integer n5 = 10;
                Integer n6 = 1;
                Object var18_18 = null;
                Object var19_19 = null;
                for (int i = 0; i < n; ++i) {
                    String string7 = resultSetMetaData.getColumnName(i + 1);
                    if (string4 != null && !LikePattern.matches(string4, "\\", string7)) continue;
                    int n7 = resultSetMetaData.getColumnType(i + 1);
                    String string8 = resultSetMetaData.getColumnTypeName(i + 1);
                    Object[] objectArray = new Object[]{null, SCHEMA_NAME, object, string7, n7, string8, n2, n4, n3, n5, n6, var18_18, var19_19, n4, n4, n2, i + 1, "YES", null, null, null, null, "NO"};
                    arrayList.add(objectArray);
                }
                resultSet2.close();
                resultSet2 = null;
            }
        }
        finally {
            if (resultSet2 != null) {
                resultSet2.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        object = this.createResultSet(string5, string6, arrayList);
        return object;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.createdByConnection;
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": DatabaseMetaData.getCrossReference(String,String,String,String,String,String)");
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "CsvJdbc";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "1";
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "CsvJdbc";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "1";
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        String string4 = "PKTABLE_CAT,PKTABLE_SCHEM,PKTABLE_NAME,PKCOLUMN_NAME,FKTABLE_CAT,FKTABLE_SCHEM,FKTABLE_NAME,FKCOLUMN_NAME,KEY_SEQ,UPDATE_RULE,DELETE_RULE,FK_NAME,PK_NAME,DEFERRABILITY";
        String string5 = "String,String,String,String,String,String,String,String,Short,Short,Short,String,String,Short";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSet resultSet = this.createResultSet(string4, string5, arrayList);
        return resultSet;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getExportedKeys(string, string2, string3);
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        String string4 = "TABLE_CAT,TABLE_SCHEM,TABLE_NAME,NON_UNIQUE,INDEX_QUALIFIER,INDEX_NAME,TYPE,ORDINAL_POSITION,COLUMN_NAME,ASC_OR_DESC,CARDINALITY,PAGES,FILTER_CONDITION";
        String string5 = "String,String,String,Boolean,String,String,Short,Short,String,String,Integer,Integer,String";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSet resultSet = this.createResultSet(string4, string5, arrayList);
        return resultSet;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        String string4 = "TABLE_CAT,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,KEY_SEQ,PK_NAME";
        String string5 = "String,String,String,String,Short,String";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSet resultSet = this.createResultSet(string4, string5, arrayList);
        return resultSet;
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": DatabaseMetaData.getProcedureColumns(String,String,String,String)");
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        String string4 = "PROCEDURE_CAT,PROCEDURE_SCHEM,PROCEDURE_NAME,reserved4,reserved5,reserved6,REMARKS,PROCEDURE_TYPE,SPECIFIC_NAME";
        String string5 = "String,String,String,String,String,String,String,Short,String";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSet resultSet = this.createResultSet(string4, string5, arrayList);
        return resultSet;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String string = "TABLE_SCHEM,TABLE_CATALOG";
        String string2 = "String,String";
        Object[] objectArray = new Object[]{SCHEMA_NAME, null};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(objectArray);
        ResultSet resultSet = this.createResultSet(string, string2, arrayList);
        return resultSet;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "_";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": DatabaseMetaData.getSuperTables(String,String,String)");
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + "DatabaseMetaData.getSuperTypes(String,String,String)");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        String string4 = "TABLE_CAT,TABLE_SCHEM,TABLE_NAME,GRANTOR,GRANTEE,PRIVILEGE,IS_GRANTABLE";
        String string5 = "String,String,String,String,String,String,String";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSet resultSet = this.createResultSet(string4, string5, arrayList);
        return resultSet;
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        int n;
        String string4 = "TABLE_CAT,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,REMARKS,TYPE_CAT,TYPE_SCHEM,TYPE_NAME,SELF_REFERENCING_COL_NAME,REF_GENERATION";
        String string5 = "String,String,String,String,String,String,String,String,String,String";
        List<String> list = ((CsvConnection)this.createdByConnection).getTableNames();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(list.size());
        boolean bl = false;
        if (stringArray == null) {
            bl = true;
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equals("TABLE")) continue;
                bl = true;
            }
        }
        for (n = 0; n < list.size(); ++n) {
            String string6 = list.get(n);
            if (!bl || string3 != null && !LikePattern.matches(string3, "\\", string6)) continue;
            Object[] objectArray = new Object[]{null, SCHEMA_NAME, string6, "TABLE", "", null, null, null, null, null};
            arrayList.add(objectArray);
        }
        ResultSet resultSet = this.createResultSet(string4, string5, arrayList);
        return resultSet;
    }

    private ResultSet createResultSet(String string, String string2, List<Object[]> list) throws SQLException {
        ListDataReader listDataReader = new ListDataReader(string.split(","), string2.split(","), list);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(new Object[]{"*", new AsteriskExpression("*")});
        CsvResultSet csvResultSet = null;
        try {
            if (this.internalStatement == null) {
                this.internalStatement = (CsvStatement)this.createdByConnection.createStatement();
            }
            csvResultSet = new CsvResultSet(this.internalStatement, listDataReader, "", arrayList, false, 1003, null, null, null, null, -1, 0, string2, 0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(classNotFoundException.getMessage());
        }
        return csvResultSet;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String string = "TABLE_TYPE";
        String string2 = "String";
        Object[] objectArray = new Object[]{"TABLE"};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(objectArray);
        ResultSet resultSet = this.createResultSet(string, string2, arrayList);
        return resultSet;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        String string = "TYPE_NAME,DATA_TYPE,PRECISION,LITERAL_PREFIX,LITERAL_SUFFIX,CREATE_PARAMS,NULLABLE,CASE_SENSITIVE,SEARCHABLE,UNSIGNED_ATTRIBUTE,FIXED_PREC_SCALE,AUTO_INCREMENT,LOCAL_TYPE_NAME,MINIMUM_SCALE,MAXIMUM_SCALE,SQL_DATA_TYPE,SQL_DATETIME_SUB,NUM_PREC_RADIX";
        String string2 = "String,Integer,Integer,String,String,String,Short,Boolean,Short,Boolean,Boolean,Boolean,String,Short,Short,Integer,Integer,Integer";
        List<Object[]> list = StringConverter.getTypeInfo();
        ResultSet resultSet = this.createResultSet(string, string2, list);
        return resultSet;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        String string4 = "TYPE_CAT,TYPE_SCHEM,TYPE_NAME,CLASS_NAME,DATA_TYPE,REMARKS,BASE_TYPE";
        String string5 = "String,String,String,String,Integer,String,Short";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSet resultSet = this.createResultSet(string4, string5, arrayList);
        return resultSet;
    }

    @Override
    public String getURL() throws SQLException {
        return ((CsvConnection)this.createdByConnection).getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return "unknown";
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        return this.getBestRowIdentifier(string, string2, string3, 0, false);
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 1;
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        if (n == 1003) {
            return true;
        }
        return n == 1005;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        return null;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return null;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "TABLE_CAT,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,DATA_TYPE,COLUMN_SIZE,DECIMAL_DIGITS,NUM_PREC_RADIX,COLUMN_USAGE,REMARKS,CHAR_OCTET_LENGTH,IS_NULLABLE";
        String string6 = "String,String,String,String,Integer,Integer,Integer,Integer,String,String,Integer,String";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSet resultSet = this.createResultSet(string5, string6, arrayList);
        return resultSet;
    }
}

