/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.RelopExpression;

class BetweenExpression
extends LogicalExpression {
    Expression obj;
    Expression left;
    Expression right;

    public BetweenExpression(Expression expression, Expression expression2, Expression expression3) {
        this.obj = expression;
        this.left = expression2;
        this.right = expression3;
    }

    @Override
    public boolean isTrue(Map<String, Object> map) throws SQLException {
        Integer n;
        Comparable comparable = (Comparable)this.left.eval(map);
        Comparable comparable2 = (Comparable)this.right.eval(map);
        Comparable comparable3 = (Comparable)this.obj.eval(map);
        Integer n2 = RelopExpression.compare(comparable, comparable3, map);
        boolean bl = false;
        if (n2 != null && n2 <= 0 && (n = RelopExpression.compare(comparable2, comparable3, map)) != null && n >= 0) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return "B " + this.obj + " " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.obj.usedColumns());
        linkedList.addAll(this.left.usedColumns());
        linkedList.addAll(this.right.usedColumns());
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.obj.aggregateFunctions());
        linkedList.addAll(this.left.aggregateFunctions());
        linkedList.addAll(this.right.aggregateFunctions());
        return linkedList;
    }
}

