/*
 * Decompiled with CFR 0.152.
 */
package org.relique.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.relique.io.CryptoFilter;

public class XORCipher
implements CryptoFilter {
    private int keyCounter;
    private int[] scrambleKey;

    public XORCipher(String string) {
        this.scrambleKey = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            this.scrambleKey[i] = string.charAt(i);
        }
        this.keyCounter = 0;
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        if (inputStream.available() > 0) {
            return (byte)this.scrambleInt(inputStream.read());
        }
        return -1;
    }

    @Override
    public int read(InputStream inputStream, byte[] byArray) throws IOException {
        int n = inputStream.read(byArray, 0, byArray.length);
        this.scrambleArray(byArray);
        return n;
    }

    @Override
    public int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        n2 = inputStream.read(byArray, n, n2);
        this.scrambleArray(byArray);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("XORCipher(");
        stringBuilder.append(this.scrambleKey.length);
        stringBuilder.append("):'");
        for (int i = 0; i < this.scrambleKey.length; ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(i);
        }
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    private int scrambleInt(int n) {
        int n2 = n;
        if (this.scrambleKey.length > 0) {
            n2 = n ^ this.scrambleKey[this.keyCounter];
            ++this.keyCounter;
            this.keyCounter %= this.scrambleKey.length;
        }
        return n2;
    }

    private void scrambleArray(byte[] byArray) {
        if (this.scrambleKey.length > 0) {
            int n = 0;
            while (n < byArray.length) {
                int n2 = n++;
                byArray[n2] = (byte)(byArray[n2] ^ this.scrambleKey[this.keyCounter]);
                ++this.keyCounter;
                this.keyCounter %= this.scrambleKey.length;
            }
        }
    }

    @Override
    public void write(OutputStream outputStream, int n) throws IOException {
        outputStream.write(this.scrambleInt(n));
    }

    @Override
    public void reset() {
        this.keyCounter = 0;
    }
}

