/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.sqlsheet;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import net.pcal.sqlsheet.XlsConnection;
import net.pcal.sqlsheet.XlsResultSet;
import net.pcal.sqlsheet.parser.CreateTableStatement;
import net.pcal.sqlsheet.parser.InsertIntoStatement;
import net.pcal.sqlsheet.parser.ParsedStatement;
import net.pcal.sqlsheet.parser.SelectStarStatement;
import net.pcal.sqlsheet.parser.SqlSheetParser;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsStatement
implements Statement {
    private XlsConnection connection;
    private Map<String, XlsResultSet> sheet2rs = new HashMap<String, XlsResultSet>();
    private SqlSheetParser parser;

    public XlsStatement(XlsConnection c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.connection = c;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeQuery(sql);
        return false;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.executeQuery(sql);
        return 1;
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        ParsedStatement parsed = this.parse(query);
        if (parsed instanceof SelectStarStatement) {
            return this.doSelect((SelectStarStatement)parsed);
        }
        if (parsed instanceof InsertIntoStatement) {
            return this.doInsert((InsertIntoStatement)parsed);
        }
        if (parsed instanceof CreateTableStatement) {
            return this.doCreateTable((CreateTableStatement)parsed);
        }
        throw new IllegalStateException(parsed.getClass().getName());
    }

    protected ParsedStatement parse(String sql) throws SQLException {
        if (sql == null) {
            throw new IllegalArgumentException();
        }
        if (this.parser == null) {
            this.parser = new SqlSheetParser();
        }
        return this.parser.parse(sql);
    }

    protected ResultSet doSelect(SelectStarStatement sss) throws SQLException {
        XlsResultSet out = this.findOrCreateResultSetFor(sss.getTable());
        out.beforeFirst();
        out.statement = this;
        return out;
    }

    protected ResultSet doCreateTable(CreateTableStatement cts) throws SQLException {
        this.connection.setWriteRequired(true);
        String tableName = cts.getTable().replace("\"", "");
        Sheet newSheet = this.connection.getWorkBook().createSheet(tableName);
        Row row = newSheet.createRow(0);
        for (int i = 0; i < cts.getColumns().size(); i = (int)((short)(i + 1))) {
            Cell cell = row.createCell(i);
            cell.setCellValue(cts.getColumns().get(i));
        }
        return this.findOrCreateResultSetFor(cts.getTable());
    }

    protected ResultSet doInsert(InsertIntoStatement insert) throws SQLException {
        this.connection.setWriteRequired(true);
        XlsResultSet rs = this.findOrCreateResultSetFor(insert.getTable());
        rs.moveToInsertRow();
        for (int i = 0; i < insert.getColumns().size(); ++i) {
            rs.updateObject(i + 1, insert.getValues().get(i));
        }
        return rs;
    }

    private XlsResultSet findOrCreateResultSetFor(String tableName) throws SQLException {
        XlsResultSet out = this.sheet2rs.get(tableName = tableName.trim().toUpperCase());
        if (out == null) {
            Sheet sheet = XlsStatement.getSheetNamed(this.connection.getWorkBook(), tableName);
            out = new XlsResultSet(this.connection.getWorkBook(), sheet);
            out.statement = this;
            this.sheet2rs.put(tableName, out);
        }
        return out;
    }

    private static Sheet getSheetNamed(Workbook wb, String name) throws SQLException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        name = name.trim();
        int count = wb.getNumberOfSheets();
        for (int i = 0; i < count; ++i) {
            String sheetName = wb.getSheetName(i);
            if (sheetName == null || !sheetName.equalsIgnoreCase(name) && !("\"" + sheetName + "\"").equalsIgnoreCase(name)) continue;
            return wb.getSheetAt(i);
        }
        throw new SQLException("No sheet named '" + name + "'");
    }

    @Override
    public void setMaxFieldSize(int p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setMaxRows(int p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setEscapeProcessing(boolean p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setQueryTimeout(int p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setCursorName(String p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setFetchDirection(int p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setFetchSize(int p0) throws SQLException {
        this.nyi();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public void cancel() throws SQLException {
        this.nyi();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.nyi();
    }

    @Override
    public void addBatch(String p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.nyi();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.nyi();
        return -1;
    }

    protected void nyi() throws SQLException {
        throw new SQLException("NYI");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

