/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sqlsheet.stream;

import com.googlecode.sqlsheet.stream.XlsStreamConnection;
import com.googlecode.sqlsheet.stream.XlsStreamResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.pcal.sqlsheet.parser.ParsedStatement;
import net.pcal.sqlsheet.parser.SelectStarStatement;
import net.pcal.sqlsheet.parser.SqlSheetParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsStreamStatement
implements Statement {
    XlsStreamConnection connection;
    SqlSheetParser parser;

    public XlsStreamStatement(XlsStreamConnection c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.connection = c;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeQuery(sql);
        return false;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.executeQuery(sql);
        return 1;
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        ParsedStatement parsed = this.parse(query);
        if (parsed instanceof SelectStarStatement) {
            return this.doSelect((SelectStarStatement)parsed);
        }
        throw new IllegalStateException(parsed.getClass().getName());
    }

    protected ParsedStatement parse(String sql) throws SQLException {
        if (sql == null) {
            throw new IllegalArgumentException();
        }
        if (this.parser == null) {
            this.parser = new SqlSheetParser();
        }
        return this.parser.parse(sql);
    }

    protected ResultSet doSelect(SelectStarStatement sss) throws SQLException {
        XlsStreamResultSet out = this.findOrCreateResultSetFor(sss.getTable());
        out.beforeFirst();
        return out;
    }

    private XlsStreamResultSet findOrCreateResultSetFor(String tableName) throws SQLException {
        return new XlsStreamResultSet(tableName, this.connection);
    }

    @Override
    public void setMaxFieldSize(int p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setMaxRows(int p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setEscapeProcessing(boolean p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setQueryTimeout(int p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setCursorName(String p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setFetchDirection(int p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void setFetchSize(int p0) throws SQLException {
        this.nyi();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public void cancel() throws SQLException {
        this.nyi();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.nyi();
    }

    @Override
    public void addBatch(String p0) throws SQLException {
        this.nyi();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.nyi();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.nyi();
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.nyi();
        return -1;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.nyi();
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.nyi();
        return -1;
    }

    protected void nyi() throws SQLException {
        throw new SQLException("NYI");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

