/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.dvsum.logger.CustomLogger;
import com.dvsum.model.HttpResponseData;
import com.dvsum.util.HttpRequestUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.Action.RestAction;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.Workflow;
import java.util.Map;

public class WorkflowRequestHandler {
    private static final CustomLogger logger = CustomLogger.getLogger(WorkflowRequestHandler.class);

    public static String executeHttpRequest(Workflow workflow, State state, RestAction action, Map<String, Object> headers, Map<String, Object> payload) {
        HttpResponseData responseData = null;
        try {
            switch (action.getMethod()) {
                case "GET": {
                    responseData = action.getUrl().startsWith("http://") ? HttpRequestUtil.sendGetRequest(action.getUrl(), headers) : TLSHttpsRequestor.executeGetWorkflow(action.getUrl(), new String[0], new String[0], headers.keySet().toArray(), headers.values().toArray());
                    break;
                }
                case "POST": {
                    responseData = action.getUrl().startsWith("http://") ? HttpRequestUtil.sendPostRequest(action.getUrl(), JsonUtil.mapToJsonString(payload), headers) : TLSHttpsRequestor.executePostWorkflow(action.getUrl(), JsonUtil.mapToJsonString(payload), headers.keySet().toArray(), headers.values().toArray());
                    break;
                }
                default: {
                    logger.info("Invalid HTTP method. HTTP method :", action.getMethod());
                    break;
                }
                case "PUT": 
                case "DELETE": {
                    return WorkflowRequestHandler.validateResponseData(workflow, state, action, responseData);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while executing Http request. Error :", e.getMessage());
        }
        return WorkflowRequestHandler.validateResponseData(workflow, state, action, responseData);
    }

    public static String validateResponseData(Workflow workflow, State state, Action action, HttpResponseData responseData) {
        String response = null;
        if (responseData.getStatusCode() >= 200 && responseData.getStatusCode() < 300) {
            logger.info("Request successful with status code ", responseData.getStatusCode());
        } else {
            logger.info("Request failed with status code ", responseData.getStatusCode());
            String errorMessage = String.format("Error: Execution of action '%s' for state '%s' failed with status code %d. %s", action.getId(), state.getId(), responseData.getStatusCode(), WorkflowRequestHandler.getNonHtmlResponseBody(responseData.getResponseBody()));
            action.handleError(workflow, state, errorMessage, false);
        }
        response = responseData.getResponseBody();
        return response;
    }

    public static String getNonHtmlResponseBody(String responseBody) {
        if (Util.isNotNullOrEmpty(responseBody) && (responseBody.contains("<html") || responseBody.contains("</html>"))) {
            responseBody = "";
        }
        return responseBody;
    }
}

