/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.MultipartFileUploader;
import com.dvsum.workflow.model.S3PreSignedURLInfo;

public class WorkflowFileUploader {
    private static final CustomLogger logger = CustomLogger.getLogger(WorkflowFileUploader.class);

    public static void uploadResponseFilesToS3(String responseJsonFilePath, String responseJsonContent, String prunedResponseJsonFilePath, String prunedResponseJsonContent, S3PreSignedURLInfo s3PreSignedURLInfo, LogFormat logFormat) {
        WorkflowFileUploader.uploadFileToS3(prunedResponseJsonFilePath, prunedResponseJsonContent, s3PreSignedURLInfo, logFormat);
        WorkflowFileUploader.uploadFileToS3(responseJsonFilePath, responseJsonContent, s3PreSignedURLInfo, logFormat);
    }

    public static void uploadFileToS3(String filePath, String fileContent, S3PreSignedURLInfo s3PreSignedURLInfo, LogFormat logFormat) {
        try {
            FileUtil.writeToFileIfNotExists(filePath, fileContent);
            MultipartFileUploader.uploadFileToS3(filePath, JsonObjectMapperUtil.getJsonObjectFromObject(s3PreSignedURLInfo), logFormat);
            logger.info("File uploaded to S3. File path :", filePath);
        }
        catch (Exception e) {
            logger.error(logFormat.getFormattedLog(), "Error while uploading file to S3. Error :", e.getMessage());
            e.printStackTrace();
        }
    }

    public static String generateFile(String filePath, Object jsonContent, S3PreSignedURLInfo s3PreSignedURLInfo, LogFormat logFormat) {
        return WorkflowFileUploader.generateFile(filePath, jsonContent, false, s3PreSignedURLInfo, logFormat);
    }

    public static String generateFile(String filePath, Object jsonContent, Boolean uploadRawResponseToS3, S3PreSignedURLInfo s3PreSignedURLInfo, LogFormat logFormat) {
        String generatedFilePathKey = filePath;
        try {
            FileUtil.writeToFileIfNotExists(filePath, JsonUtil.getJsonString(jsonContent));
            boolean isCloudSaws = Boolean.parseBoolean(FileUtil.getPropertyWithDefault("is.cloud.saws", "false"));
            if (isCloudSaws || uploadRawResponseToS3.booleanValue()) {
                logger.info("Uploading file to S3. File path :", filePath);
                generatedFilePathKey = MultipartFileUploader.uploadFileToS3(filePath, JsonObjectMapperUtil.getJsonObjectFromObject(s3PreSignedURLInfo), logFormat);
            } else {
                logger.info("Storing file locally. File path :", filePath);
            }
        }
        catch (Exception e) {
            logger.error("Error while generating file. Error :", e.getMessage());
            e.printStackTrace();
        }
        return generatedFilePathKey;
    }
}

