/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.Action.CustomFunctionAction;
import com.dvsum.workflow.model.Action.JdbcAction;
import com.dvsum.workflow.model.Action.RestAction;
import com.dvsum.workflow.model.Ref.RefActionType;
import com.dvsum.workflow.model.Ref.RefExecutionState;
import com.dvsum.workflow.model.Ref.RefStateType;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.StateMachine;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.service.LogHandler;
import com.dvsum.workflow.service.MacAddressExtractor;
import com.dvsum.workflow.service.ThreadStats;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
public class WorkflowExecutionService {
    private static final CustomLogger logger = CustomLogger.getLogger(WorkflowExecutionService.class);
    @Autowired
    private DataSourceFactory dataSourceFactory;
    @Autowired
    @Qualifier(value="workflowThreadExecutor")
    private TaskExecutor workflowThreadExecutor;
    @Value(value="${python.code.execution.api}")
    private String pythonCodeExecutionApi;
    @Value(value="${get.workflow_state.url.api}")
    private String workflowStateGetUrlApi;

    public void startExecution(JSONObject workflowJson) {
        try {
            logger.info("Starting execution.....");
            if (this.isOldWorkflow(workflowJson)) {
                String errorMessage = "Old workflows are not supported on gateways running version 1.3.0 or newer.";
                LogHandler.sendInvalidWFLogMessageToUI(workflowJson, errorMessage);
                logger.error(errorMessage);
                return;
            }
            Workflow workflow = JsonObjectMapperUtil.getObjectFromJsonObject(workflowJson, Workflow.class);
            this.executeStateMachine(workflow, null);
        }
        catch (Exception e) {
            logger.error("Error while executing workflow. Error : ", e.getMessage());
            e.printStackTrace();
        }
    }

    public void resumeExecution(JSONObject webhookPayload) {
        try {
            Workflow workflow = Workflow.loadWorkflowState((JSONObject)webhookPayload.get((Object)"dvsum_metadata"), this.workflowStateGetUrlApi);
            if (!RefExecutionState.isCompletedOrErroredorResumed(workflow.getStateMachine().getCurrentExecutionState())) {
                workflow.getStateMachine().setCurrentExecutionState("RESUMED");
                workflow.saveWorkflowState();
                this.executeStateMachine(workflow, webhookPayload);
            }
        }
        catch (Exception e) {
            logger.error("Error while resuming workflow. Error :", e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isOldWorkflow(JSONObject workflowJson) {
        if (workflowJson == null) {
            return false;
        }
        JSONObject stateMachine = (JSONObject)workflowJson.get((Object)"state_machine");
        Object states = stateMachine.get((Object)"states");
        return states instanceof JSONObject;
    }

    public String getMacAddress(Workflow workflow, JSONObject webhookPayload) {
        String macAddress;
        block5: {
            macAddress = null;
            if (webhookPayload != null) {
                try {
                    macAddress = MacAddressExtractor.extractMacAddress(workflow, (Map<String, Object>)webhookPayload);
                    if (Util.isNotNullOrEmpty(macAddress)) {
                        webhookPayload.put((Object)"detected_mac_address", (Object)macAddress.trim());
                        break block5;
                    }
                    System.out.println("Detected mac address is null or empty.");
                }
                catch (Exception e) {
                    logger.info("Error while getting mac address. Error: ", e.getMessage());
                    LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), e.getMessage(), true, 500);
                    workflow.getStateMachine().setCurrentExecutionState("ERRORED");
                    workflow.failAllStates();
                    workflow.saveWorkflowState();
                }
            } else {
                logger.info("Unable to get MAC Address because webhook payload is null or empty.");
            }
        }
        return macAddress;
    }

    public void executeStateMachine(Workflow workflow, JSONObject webhookPayload) {
        try {
            StateMachine stateMachine = workflow.getStateMachine();
            String nextState = stateMachine.getStartState();
            String END_STATE = "END";
            logger.info("Executing State Machine :", stateMachine.getStateMachineName());
            while (!nextState.equalsIgnoreCase(END_STATE)) {
                State currentState = stateMachine.findState(nextState);
                if (RefExecutionState.isCompleted(currentState.getCurrentExecutionState()) || RefExecutionState.isErrored(currentState.getCurrentExecutionState())) {
                    logger.info("State is not valid to be executed. State's status is ", currentState.getCurrentExecutionState(), " and ID is : ", currentState.getId());
                    nextState = currentState.getNextState();
                    continue;
                }
                logger.info("Executing State :", currentState.getId());
                if (RefStateType.isTask(currentState.getStateType())) {
                    if (this.performStateActions(workflow, currentState, webhookPayload)) {
                        logger.info("Stopping execution...");
                        break;
                    }
                } else {
                    logger.info("Invalid State type. State type :", currentState.getStateType());
                }
                nextState = currentState.getNextState();
                logger.info("Next state :", nextState);
                if (!nextState.equalsIgnoreCase(END_STATE)) continue;
                if (!RefExecutionState.isPending(currentState.getCurrentExecutionState())) {
                    stateMachine.setCurrentExecutionState("COMPLETED");
                }
                workflow.generateResponses();
                workflow.getWorkflowDataStore().clearOutputs();
                workflow.uploadWorkflowStateJson();
                workflow.uploadResponseFiles();
            }
        }
        catch (Exception e) {
            logger.error("Error while executing state machine. Error :", e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean performStateActions(Workflow workflow, State state, JSONObject webhookPayload) {
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        ArrayList<Action> actions = new ArrayList<Action>();
        ArrayList<Long> timeouts = new ArrayList<Long>();
        ThreadPoolExecutor jdkExecutor = ((ThreadPoolTaskExecutor)this.workflowThreadExecutor).getThreadPoolExecutor();
        for (Action action : state.getActions()) {
            logger.info("Working on Action {}", action.getId());
            logger.info(action.getActionType());
            Action currentAction = action;
            long timeout = action.findTimeout(workflow);
            timeouts.add(timeout);
            actions.add(action);
            CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> {
                try {
                    SourceConfig sourceConfig = workflow.findSourceConfig(currentAction.getSourceId());
                    if (RefActionType.isWebhook(currentAction.getActionType()) && RefExecutionState.isPending(currentAction.getCurrentExecutionState())) {
                        boolean stopExecution = currentAction.saveActionResults(workflow, state, webhookPayload.toJSONString(), this.workflowStateGetUrlApi);
                        workflow.saveWorkflowState();
                        return stopExecution;
                    }
                    if (RefExecutionState.isNotStarted(currentAction.getCurrentExecutionState())) {
                        LogHandler.sendActionStartLogToUI(workflow, state, currentAction);
                        String response = this.performTaskStateAction(workflow, state, currentAction, sourceConfig, webhookPayload);
                        if (currentAction.saveActionResults(workflow, state, response, this.workflowStateGetUrlApi)) {
                            workflow.saveWorkflowState();
                            return true;
                        }
                    }
                    workflow.saveWorkflowState();
                    return this.shouldStopExecution(currentAction);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                    return this.shouldStopExecution(currentAction);
                }
            }, jdkExecutor);
            futures.add(future);
        }
        int i = 0;
        while (i < futures.size()) {
            try {
                if (((Boolean)((CompletableFuture)futures.get(i)).get((Long)timeouts.get(i), TimeUnit.SECONDS)).booleanValue()) {
                    return true;
                }
            }
            catch (TimeoutException te) {
                ((CompletableFuture)futures.get(i)).cancel(true);
                Action timedOutAction = (Action)actions.get(i);
                logger.error("Task timed out after {} seconds.", timeouts.get(i));
                String errorMessage = String.format("Error: Action %s timed out after %d seconds", timedOutAction.getId(), timeouts.get(i));
                timedOutAction.handleError(workflow, state, errorMessage, false);
                ThreadStats.logThreads();
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldStopExecution(Action action) {
        return RefActionType.isWebhook(action.getActionType()) && RefExecutionState.isPending(action.getCurrentExecutionState());
    }

    public String performTaskStateAction(Workflow workflow, State state, Action action, SourceConfig sourceConfig, JSONObject webhookPayload) throws Exception {
        String response = "";
        try {
            if (RefActionType.isCustomFunction(action.getActionType())) {
                ((CustomFunctionAction)action).setPythonCodeExecutionApiUrl(this.pythonCodeExecutionApi);
            } else if (RefActionType.isJdbc(action.getActionType())) {
                ((JdbcAction)action).setDataSourceFactory(this.dataSourceFactory);
            } else if (RefActionType.isRest(action.getActionType())) {
                ((RestAction)action).setConsolidatedResponse(new StringBuilder());
            }
            response = action.execute(workflow, state, sourceConfig, webhookPayload);
        }
        catch (Exception e) {
            logger.error("Error occurred while performing action. Details: " + e.getMessage(), e);
            throw e;
        }
        return response;
    }
}

