/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.StateMachine;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.model.WorkflowDataStore;
import com.dvsum.workflow.service.DynamicParamExtractor;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLGenerator {
    private static final CustomLogger logger = CustomLogger.getLogger(URLGenerator.class);

    public static String generateAndResolveUrl(Workflow workflow, String domain, String path) {
        String completeUrl = URLGenerator.generateCompleteUrl(domain, path);
        return URLGenerator.resolveDynamicPathParameters(workflow, completeUrl);
    }

    public static String resolveDynamicPathParameters(Workflow workflow, String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null.");
        }
        if (workflow == null) {
            throw new IllegalArgumentException("Workflow cannot be null when resolving dynamic parameters.");
        }
        String regex = "\\{\\$\\$+\\.[^\\}]+\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(path);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String matched = matcher.group();
            try {
                String replacement = DynamicParamExtractor.fetchDynamicParam(workflow, matched.substring(1, matched.length() - 1));
                if (replacement == null) {
                    throw new IllegalArgumentException("Dynamic parameter value not found for: " + matched);
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error fetching dynamic parameter: " + matched, e);
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String generateCompleteUrl(String domain, String path) {
        if (domain == null) {
            throw new IllegalArgumentException("Domain cannot be null");
        }
        if (!domain.startsWith("http://") && !domain.startsWith("https://")) {
            domain = "https://" + domain;
        }
        if (domain.endsWith("/")) {
            domain = domain.substring(0, domain.length() - 1);
        }
        if (path == null || path.isEmpty()) {
            return domain;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return String.valueOf(domain) + path;
    }

    public static String concatQueryParam(String paramKey, String paramVal, String url) throws Exception {
        String urlWithQueryParam = url.trim();
        boolean hasQueryParams = urlWithQueryParam.contains("?");
        if (!hasQueryParams) {
            urlWithQueryParam = String.valueOf(urlWithQueryParam) + "?";
        } else {
            char lastChar = urlWithQueryParam.charAt(urlWithQueryParam.length() - 1);
            if (lastChar != '&' && lastChar != '?') {
                urlWithQueryParam = String.valueOf(urlWithQueryParam) + "&";
            }
        }
        if (Util.isNotNullOrEmpty(paramKey) && Util.isNotNullOrEmpty(paramVal)) {
            logger.info("Adding query param key: ", paramKey);
            String encodedParamKey = URLEncoder.encode(paramKey.trim(), "UTF-8");
            String encodedParamVal = URLEncoder.encode(paramVal.trim(), "UTF-8");
            urlWithQueryParam = String.valueOf(urlWithQueryParam) + encodedParamKey + "=" + encodedParamVal;
        } else {
            logger.info("Key or value is null or empty in query param. ", paramKey, ":", paramVal);
        }
        return urlWithQueryParam;
    }

    public static String replaceParam(String paramKey, String paramVal, String text) {
        String textWithPathParam;
        block4: {
            textWithPathParam = text;
            try {
                if (Util.isNotNullOrEmpty(paramKey) && paramVal != null) {
                    String subStrToReplace = String.format("<%s>", paramKey);
                    if (textWithPathParam.contains(subStrToReplace)) {
                        String encodedVal = URLEncoder.encode(paramVal.trim(), "UTF-8");
                        textWithPathParam = textWithPathParam.replace(subStrToReplace, encodedVal);
                    }
                    break block4;
                }
                throw new Exception("Parameter key or value is null or empty. Param Key: " + paramKey + "Param Value:" + paramVal);
            }
            catch (Exception e) {
                logger.error("Error while replacing param. Error: ", e.getMessage());
                e.printStackTrace();
            }
        }
        return textWithPathParam;
    }

    public static void main(String[] args) {
        Workflow workflow = new Workflow();
        workflow.setWorkflowDataStore(new WorkflowDataStore());
        workflow.getWorkflowDataStore().appendContext("version", "1.0");
        workflow.setStateMachine(new StateMachine());
        workflow.getStateMachine().setDefaultTimeout(120L);
        try {
            String url1 = "/v1/{$$.context.version}/trigger-Dvsum-bot/";
            System.out.println("Test Case 1: " + URLGenerator.resolveDynamicPathParameters(workflow, url1));
            String url2 = "/{$$.context.version}/trigger-Dvsum-bot/";
            System.out.println("Test Case 2: " + URLGenerator.resolveDynamicPathParameters(workflow, url2));
            String url3 = "/V1/trigger-Dvsum-bot/";
            System.out.println("Test Case 3: " + URLGenerator.resolveDynamicPathParameters(workflow, url3));
            try {
                System.out.println("Test Case 4: " + URLGenerator.resolveDynamicPathParameters(null, url1));
            }
            catch (IllegalArgumentException e) {
                System.out.println("Test Case 4 Expected Error: " + e.getMessage());
            }
            try {
                System.out.println("Test Case 5: " + URLGenerator.resolveDynamicPathParameters(workflow, null));
            }
            catch (IllegalArgumentException e) {
                System.out.println("Test Case 5 Expected Error: " + e.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

